
% This program performs Interactive Fixed Effects (IFE) estimation 
% as developed in Bai (2009).

function [betaIFE, seIFE, sigma2, SSR, nnn, r1, r2, betaIFE0, betaOLS, F1, L1, F2, L2, VNT1, VNT2, varcovIFE] = IFEfunction(X1,Y1,order,S,demean,rmax,rfix); 
[T,N,p]=size(X1);


% remove state-specific trends
[Xdet,Ydet] = RemoveTimeTrends(X1,Y1,order,S);
% remove fixed effects
if demean==0
    Xdot=Xdet;
    Ydot=Ydet;
elseif demean==1
    [Xdot,Ydot]=CSDemean(Xdet,Ydet,1);
elseif demean==2
    [Xdot,Ydot]=TimeDemean(Xdet,Ydet,1);
elseif demean==3
    [Xdot,Ydot]=DemeanData(Xdet,Ydet);
end
Y=Ydot;
X=Xdot;

% calculate XXinv outside of loop to save time
[XXinv]= Mul_XXinv(X); 


% Estimation
betaIFE0=zeros(p,2);
betaIFE=zeros(p,2);    % to contain the interative effect estimators, with different staring methods (2 methods)
nnn=zeros(1,2);   % contain the number of iterations for the 2 methods to achieve convergence
sigma2=zeros(1,2); % the estimated residual variance for each starting method, also the optimal value of the objective function
varcovIFE=zeros(p,p,2);  % contains the IFE variance-covariance matrix for the two starting methods
seIFE=zeros(p,2);     % contains the IFE standard errors for the 2 different starting methods
SSR=zeros(1,2);

% Starting method 1:
% Initiate IFE by calculating standard panel beta estimator (lambda=0) as a starting value
[betaOLS]=Mul_panelbeta(X,Y,eye(T)); 

U=Y;
for k=1:p;
    U=U-X(:,:,k)* betaOLS(k,1);
end
U2=U.^2;
sigsq=trace(U*U')/(N*T-p);
varcov=sigsq*XXinv*inv(XXinv)*XXinv;
seOLS=sqrt(diag(varcov));

% Get the first estimate of r and F,lambda (because iteration below starts by estimating beta
if rfix==0
    [r1,~,~,~]=nbplog(U,rmax,1,0);
elseif rfix==1
    r1=rmax;
end
[F1,L1,VNT]=panelFactorNew(U,r1);

% Perform IFE iteration
[betaIFE0(:,1), F1,L1, VNT1, e1, nnn(1,1),r1]=Mul_betaIterNew(X,XXinv, Y, F1,L1, r1,rmax,rfix, 0.00000001);
sigma2(1,1)=trace(e1*e1')/(N*T-r1*(N+T)+r1^2-2);
SSR(1,1)=trace(e1*e1');
[seIFE(:,1), varcovIFE(:,:,1)]=IFEse(X,F1,L1,e1);

% correct beta for serial corr, cross-sec corr, and heteroskedasticity
betaIFE(:,1)=IFEbias(X,F1,L1,e1,betaIFE0(:,1));



%Starting method 2:
% Initiate IFE by calculating the factors and factor loading (beta=0)
if rfix==0
    [r2,~,~,~]=nbplog(Y,rmax,1,0);
elseif rfix==1
    r2=rmax;
end
[F12,L12,VNT2]=panelFactorNew(Y,r2);

%Perform IFE iteration
[betaIFE0(:,2), F2,L2, VNT2, e2, nnn(1,2),r2]=Mul_betaIterNew(X,XXinv, Y, F12,L12, r2,rmax,rfix, 0.00000001);
sigma2(1,2)=trace(e2*e2')/(N*T-r2*(N+T)+r2^2-2);
SSR(1,2)=trace(e2*e2');
[seIFE(:,2), varcovIFE(:,:,2)]=IFEse(X,F2,L2,e2);

% correct beta for serial corr, cross-sec corr, and heteroskedasticity
betaIFE(:,2)=IFEbias(X,F2,L2,e2,betaIFE0(:,2));




betaIFE;
seIFE;
sigma2;





