%This program is a function file that performs Pesaran's (2015) test for
%strong cross-section dependence. The test is based on the average of
%pair-wise correlation coefficients.

%X is the (TxN) matrix of data/residuals to be tested.

function [CSDstat] = CSDtestPesaran15(X) 
[T,N]=size(X);

Numerator=X'*X;
SquaredMat=X.^2;
SumSquaredMat=sum(SquaredMat,1);
SqrtSumSquaredMat=sqrt(SumSquaredMat);
Denomenator=SqrtSumSquaredMat'*SqrtSumSquaredMat;
rhohat=Numerator./Denomenator;


rhohatcut=zeros(N,N);
for i=1:(N-1)
for j=(i+1):N
    rhohatcut(i,j)=rhohat(i,j);
end
end

rhohatbar = (2/(N*(N-1))) * sum(rhohatcut(:));

CSDstat = sqrt(T*N*(N-1)/2)*rhohatbar;




        














