% Computes CD test statistics (Pesaran, 2015). The CD stats are calculated on the OLS
% and IV residuals from the panel IV/OLS table in the paper; these residuals were 
% computed in STATA and then exported for these tests.

clear
LASTN=maxNumCompThreads(12)
addpath('matlabprograms')
addpath('../mydata')

load('../mydata/results_ss2aa2a4BOTH2_tFE2ch.mat')


ResIV_ss2aa2a4FEt=xlsread('ResIV_ssaa2a4FEt_panel_insampleBOTH2_2ch.xls')';
ResOLS_ss2aa2a4FEt=xlsread('ResOLS_ssaa2a4FEt_panel_insampleBOTH2_2ch.xls')';

CSDstatResIV_ss2aa2a4FEt=CSDtestPesaran15(ResIV_ss2aa2a4FEt);
CSDstatResOLS_ss2aa2a4FEt=CSDtestPesaran15(ResOLS_ss2aa2a4FEt);


save('../mydata/results_ss2aa2a4BOTH2_tFE2ch.mat')

