% Computes CD test statistics (Pesaran, 2015). The CD stats are calculated on the OLS
% and IV residuals from the panel IV/OLS table in the paper; these residuals were 
% computed in STATA and then exported for these tests.

clear
LASTN=maxNumCompThreads(12)
addpath('matlabprograms')
addpath('../mydata')

load('../mydata/results_saa2a4BOTH2_tFE1ch.mat')


ResIV_saa2a4FEt=xlsread('ResIV_saa2a4FEt_panel_insampleBOTH2_1ch.xls')';
ResOLS_saa2a4FEt=xlsread('ResOLS_saa2a4FEt_panel_insampleBOTH2_1ch.xls')';

CSDstatResIV_saa2a4FEt=CSDtestPesaran15(ResIV_saa2a4FEt);
CSDstatResOLS_saa2a4FEt=CSDtestPesaran15(ResOLS_saa2a4FEt);


save('../mydata/results_saa2a4BOTH2_tFE1ch.mat')

