% Computes CD test statistics (Pesaran, 2015). The CD stats are calculated on the OLS
% and IV residuals from the panel IV/OLS table in the paper; these residuals were 
% computed in STATA and then exported for these tests.

clear
LASTN=maxNumCompThreads(12)
addpath('matlabprograms')
addpath('../mydata')

load('../mydata/results_saa2BOTH2_tFE1ch.mat')


ResIV_saaFEt=xlsread('ResIV_saaFEt_panel_insampleBOTH2_1ch.xls')';
ResOLS_saaFEt=xlsread('ResOLS_saaFEt_panel_insampleBOTH2_1ch.xls')';
ResOLS_saaFEtDemoByYear=xlsread('ResOLS_saaFEtDemoByYear_panel_insampleBOTH2_1ch.xls')';

CSDstatResIV_saaFEt=CSDtestPesaran15(ResIV_saaFEt);
CSDstatResOLS_saaFEt=CSDtestPesaran15(ResOLS_saaFEt);
CSDstatResOLS_saaFEtDemoByYear=CSDtestPesaran15(ResOLS_saaFEtDemoByYear);


save('../mydata/results_saa2BOTH2_tFE1ch.mat')

