% Computes CD test statistics (Pesaran, 2015). The CD stats are calculated on the OLS
% and IV residuals from the panel IV/OLS table in the paper; these residuals were 
% computed in STATA and then exported for these tests.

clear
LASTN=maxNumCompThreads(12)
addpath('matlabprograms')
addpath('../mydata')

load('../mydata/results_saa2BOTH2_iFE1ch.mat')


ResOLS_saaFEi=xlsread('ResOLS_saaFEi_panel_insampleBOTH2_1ch.xls')';
ResOLS_saaFEiDemoByYear=xlsread('ResOLS_saaFEiDemoByYear_panel_insampleBOTH2_1ch.xls')';

CSDstatResOLS_saaFEi=CSDtestPesaran15(ResOLS_saaFEi);
CSDstatResOLS_saaFEiDemoByYear=CSDtestPesaran15(ResOLS_saaFEiDemoByYear);


save('../mydata/results_saa2BOTH2_iFE1ch.mat')

