/*
**   Dynamic Evaluation of Job Search Training 
**
**  Purpose:
**    Balancing Table
**    
**  Date:
**    March 2020
**
**  Author:
**   Stephen Kastoryano & Bas van der Klaauw
*/


#include <oxstd.h> // include the Ox standard library header
#include <oxfloat.h>
#import <maximize>

decl duur1, censor1, duur2, censor2, duur3, censor3, X, d, obs;


statistics(x,wT,wC)
{
	decl mT, mC, vT, vC, t;

	mT = sumc(wT .* x) / sumc(wT);
	mC = sumc(wC .* x) / sumc(wC);

	vT = sumc(wT .* (x - mT).^2)/(sumc(wT)-1);
	vC = sumc(wC .* (x - mC).^2)/(sumc(wC)-1);

	println(mT~mC);
	println(sqrt(vT~vC));

	t = (mT-mC)/sqrt(vT/sumc(wT)+vC/sumc(wC));
	t = fabs(t);
	println(t~2*(1-probt(t,sumc(wT)+sumc(wC))));
}
   
main()
{
	decl data, wT, wC, i, I, mT, mC, vT, vC;
	
	data = loadmat("BalancingData.csv");  // Load Data

println(data[0:10][]);
	data[][26] = data[][27] .* data[][26] + (1-data[][27]) .* data[][24];

	wT = zeros(rows(data),1);
	wC = zeros(rows(data),1);

	println("Number of observations ", rows(data));
	
	for(i=0;i<rows(data);++i)
	{
		if(data[i][27] .== 1)
		{
			I = (data[][24] .> data[i][26]) .* (data[][26] .> data[i][26])  .* (data[][8] .== data[i][8])
			.* densn((data[][9] - data[i][9])/3) .* densn((data[][28] - data[i][28])/20);
			if(sumc(I) .> 0)
			{
				wT[i] = wT[i] + 1;
				wC = wC + I / sumc(I);
			}
		}
	}

//	println("Unemployment hours per week");
//	statistics(

	println("DAILY BENEFITS");
	statistics(data[][2],wT,wC);

	println("WEEKLY HOURS OF UNEMPLOYMENT");
	statistics(data[][1],wT,wC);

	println("LOW SKILLED");
	statistics(data[][8],wT,wC);
	
	println("GENDER (being female)");
	statistics((data[][6].==0),wT,wC);

	println("AGE");
	statistics(data[][9],wT,wC);

	println("AGE < 35");
	statistics((data[][9].<=35),wT,wC);

	println("AGE 35-50");
	statistics((data[][9].>35).*(data[][9] .< 50),wT,wC);
	
	println("AGE >= 50");
	statistics((data[][9].>=50),wT,wC);

	println("LOST JOB IN SUMMER");
	statistics((data[][30].==7)+(data[][30].==8),wT,wC);

	println("MAXIMUM UI ENTITLEMENT PERIOD");
	statistics(data[][28],wT,wC);

	println("UI ENTITLEMENT PERIOD LESS THAN ONE YEAR");
	statistics((data[][28].<=730),wT,wC);

	data = data[3:][];
	wT = zeros(rows(data),1);
	wC = zeros(rows(data),1);

	println("Number of observations ", rows(data));
	
	for(i=0;i<rows(data);++i)
	{
		if(data[i][27] .== 1)
		{
			I = (data[][24] .> data[i][26]) .* (data[][26] .> data[i][26])  .* (data[][8] .== data[i][8])
			.* densn((data[][9] - data[i][9])/3) .* densn((data[][28] - data[i][28])/20);
			if(sumc(I) .> 0)
			{
				wT[i] = wT[i] + 1;
				wC = wC + I / sumc(I);
			}
		}
	}


	
	println("WEST");
	statistics((data[][34].==1),wT[],wC[]);

	println("NORTH-EAST");
	statistics((data[][34].==2),wT[],wC[]);
	
	println("SOUTH");
	statistics((data[][34].==3),wT[],wC[]);

	for(i=1;i<=12;++i)
	{
	println("provincie", i);
	statistics((data[][33].==i),wT[],wC[]);
	}

	println("ZUID/NOORD-HOLLAND & UTRECHT, FLEVOLAND");
	statistics((data[][33].<=4),wT[],wC[]);

	println("ZEELAND, NOORD-BRABANT, GELDERLAND & LIMBURG");
	statistics((data[][33].>=5),wT[],wC[]);
	
//	println("GELDERLAND, FLEVOLAND & OVERIJSSEL");
//	statistics((data[][33].==7)+(data[][33].==8)+(data[][33].==9),wT[],wC[]);

	println("OVERIJSSEL, DRENTHE, FRIESLAND AND GRONINGEN");
	statistics((data[][33].==10)+(data[][33].==11)+(data[][33].==12)+(data[][33].==9),wT[],wC[]);	
}


  