/*
- this do file replicates the results of Kapoor, Oosterveen and Webbink (2020, the Journal of Applied Econometrics)
- as the replication dataset is a stripped-down version of the full administrative dataset, this do file allows for partial replication
- access to the replication dataset can be granted by submitting a research request to the corresponding author: kapoor@ese.eur.nl. see the read me file
*/


cd "" // set working directory

use ReplicationDataset_ThePriceofForcedAttendance.dta, clear



***optimal bandwidth

rdbwselect grade firstyeargpa if cohort<6, c(7) p(1) all vce(cluster studentid) // cohort 6 is the abolition cohort
scalar h = e(h_mserd)
scalar h_L = 7 - e(h_mserd)
scalar h_H = 7 + e(h_mserd)



***table 1

estpost sum grade attendance if cohort<6 & firstyeargpa>=`=h_L' & firstyeargpa<7
eststo a
estpost sum grade attendance if cohort<6 & firstyeargpa>=7 		& firstyeargpa<`=h_H'
eststo b
esttab a b, gaps main(mean) aux(sd) cells(mean(fmt(2)) sd(par fmt(2)))
eststo clear 



***figure 1 and A.3; change course accordingly 

set more off
local n=1
gen y=.
gen x=.
gen w=.
forvalues bounds=6.5(0.05)7.45{
	local nx=`n'
	sum attendance if firstyeargpa>=`bounds' & firstyeargpa<(`bounds'+0.05) & cohort<6 & coursepolicy=="voluntary"
	capture replace y=`r(mean)' in `nx'
	replace x=(`bounds'+(0.05/2)) in `nx'
	replace w=`r(N)' in `nx'
	local n=`nx'+1
}
rdbwselect attendance firstyeargpa if cohort<6 & coursepolicy=="voluntary", c(7) p(1) vce(cluster studentid)
twoway (scatter y x [weight=w], sort mcolor(gs0) msymbol(Oh) msize(small)) ///
(lfit attendance  firstyeargpa if firstyeargpa>=7 & firstyeargpa<=(7 + `e(h_mserd)') & cohort<6 & coursepolicy=="voluntary", lcolor(blue) lwidth(thin) lpattern(solid)) ///
(lfit attendance  firstyeargpa if firstyeargpa<7 & firstyeargpa>=(7 - `e(h_mserd)')  & cohort<6 & coursepolicy=="voluntary", lcolor(blue) lwidth(thin) lpattern(solid)) ///
(fpfit attendance firstyeargpa if firstyeargpa>=7 & firstyeargpa<=7.5 				 & cohort<6 & coursepolicy=="voluntary", estopts(degree(3)) lcolor(gs6) lwidth(thin) lpattern(solid)) ///
(fpfit attendance firstyeargpa if firstyeargpa<7 & firstyeargpa>=6.5 				 & cohort<6 & coursepolicy=="voluntary", estopts(degree(3)) lcolor(gs6) lwidth(thin) lpattern(solid)) ///
, ytitle("Attendance second year courses") ylabel(0.40(0.1)1, nogrid) xtitle("First Year GPA") xline(7, lwidth(medium) lpattern(solid) lcolor(gs0)) xlabel(6.5(0.1)7.5) graphregion(fcolor(white) lcolor(white)) legend(off) 
drop y x w


set more off
local n=1
gen y=.
gen x=.
gen w=.
forvalues bounds=6.5(0.05)7.45{
	local nx=`n'
	sum stdgrade if firstyeargpa>=`bounds' & firstyeargpa<(`bounds'+0.05) & cohort<6 & coursepolicy=="voluntary"
	capture replace y=`r(mean)' in `nx'
	replace x=(`bounds'+(0.05/2)) in `nx'
	replace w=`r(N)' in `nx'
	local n=`nx'+1
}
rdbwselect stdgrade firstyeargpa if cohort<6 & coursepolicy=="voluntary", c(7) p(1) vce(cluster studentid)
twoway (scatter y x [weight=w], sort mcolor(gs0) msymbol(Oh) msize(small)) ///
(lfit stdgrade  firstyeargpa if firstyeargpa>=7 & firstyeargpa<=(7 + `e(h_mserd)')  & cohort<6 & coursepolicy=="voluntary", lcolor(blue) lwidth(thin) lpattern(solid)) ///
(lfit stdgrade  firstyeargpa if firstyeargpa<7 & firstyeargpa>=(7 - `e(h_mserd)')   & cohort<6 & coursepolicy=="voluntary", lcolor(blue) lwidth(thin) lpattern(solid)) ///
(fpfit stdgrade firstyeargpa if firstyeargpa>=7 & firstyeargpa<=7.5 				& cohort<6 & coursepolicy=="voluntary", estopts(degree(3)) lcolor(gs6) lwidth(thin) lpattern(solid)) ///
(fpfit stdgrade firstyeargpa if firstyeargpa<7 & firstyeargpa>=6.5 				 	& cohort<6 & coursepolicy=="voluntary", estopts(degree(3)) lcolor(gs6) lwidth(thin) lpattern(solid)) ///
, ytitle("Standardized grades second year courses") ylabel(-0.5(0.2)0.5, nogrid) xtitle("First Year GPA") xline(7, lwidth(medium) lpattern(solid) lcolor(gs0)) xlabel(6.5(0.1)7.5) graphregion(fcolor(white) lcolor(white)) legend(off)
drop y x w


set more off
local n=1
gen y=.
gen x=.
gen w=.
forvalues bounds=6.5(0.05)7.45{
	local nx=`n'
	sum stdgradeabolition if firstyeargpa>=`bounds' & firstyeargpa<(`bounds'+0.05) & cohort==6 & coursepolicy=="voluntary"
	capture replace y=`r(mean)' in `nx'
	replace x=(`bounds'+(0.05/2)) in `nx'
	replace w=`r(N)' in `nx'
	local n=`nx'+1
}
rdbwselect stdgradeabolition firstyeargpa if cohort==6 & coursepolicy=="voluntary", c(7) p(1) vce(cluster studentid)
twoway (scatter y x [weight=w], sort mcolor(gs0) msymbol(Oh) msize(vsmall)) ///
(lfit stdgradeabolition  firstyeargpa if firstyeargpa>=7 & firstyeargpa<=(7 + `e(h_mserd)')  & cohort==6 & coursepolicy=="voluntary", lcolor(blue) lwidth(thin) lpattern(solid)) ///
(lfit stdgradeabolition  firstyeargpa if firstyeargpa<7 & firstyeargpa>=(7 - `e(h_mserd)')   & cohort==6 & coursepolicy=="voluntary", lcolor(blue) lwidth(thin) lpattern(solid)) ///
(fpfit stdgradeabolition firstyeargpa if firstyeargpa>=7 & firstyeargpa<=7.5 			& cohort==6 & coursepolicy=="voluntary", estopts(degree(3)) lcolor(gs6) lwidth(thin) lpattern(solid)) ///
(fpfit stdgradeabolition firstyeargpa if firstyeargpa<7 & firstyeargpa>=6.5 			& cohort==6 & coursepolicy=="voluntary", estopts(degree(3)) lcolor(gs6) lwidth(thin) lpattern(solid)) ///
, ytitle("Standardized grades second year courses") ylabel(-1(0.5)1, nogrid) xtitle("First Year GPA") xline(7, lwidth(medium) lpattern(solid) lcolor(gs0)) xlabel(6.5(0.1)7.5) graphregion(fcolor(white) lcolor(white)) legend(off) 
drop y x w



***figure 2

preserve
keep if cohort<6 & firstyeargpa>=6.45 & firstyeargpa<=7.55
collapse (first) firstyeargpa, by(studentid)
	
rddensity firstyeargpa, c(7) all plot ///
graph_options(ytitle("Density") xtitle("First Year GPA") xline(7, lwidth(medium) lpattern(solid) lcolor(gs0)) ///
xlabel(6.5(0.1)7.5) graphregion(fcolor(white) lcolor(white)) legend(off))
restore 



***table 3

gen 	treatment=0
replace treatment=1 if firstyeargpa<7
gen  	kernwgt = (treatment*(1-abs((-firstyeargpa + 7)/`=h')) + (1-treatment)*(1-abs((firstyeargpa - 7)/`=h')))/`=h'
replace kernwgt = 0 if firstyeargpa<`=h_L' | firstyeargpa>`=h_H'

gen pol1= firstyeargpa-7
gen pol1t=pol1*treatment

gen 	volcourse=0
replace volcourse=1 if coursepolicy=="voluntary"
gen 	forcourse=0
replace forcourse=1 if coursepolicy=="forced"

gen treatmentvol=treatment*volcourse
gen treatmentfor=treatment*forcourse
gen pol1vol=pol1*volcourse
gen pol1for=pol1*forcourse
gen pol1tvol=pol1t*volcourse
gen pol1tfor=pol1t*forcourse

		rdrobust stdgrade firstyeargpa if cohort<6, c(7) p(1) h(`=h') 	vce(cluster studentid) 
eststo: reg stdgrade treatment pol1 pol1t if firstyeargpa>=`=h_L' & firstyeargpa<=`=h_H' & cohort<6 [aweight=kernwgt], vce(cluster studentid)
eststo: reg stdgrade treatment treatmentvol treatmentfor volcourse forcourse pol1 pol1t pol1vol pol1tvol pol1for pol1tfor if firstyeargpa>=`=h_L' & firstyeargpa<=`=h_H' & cohort<6 [aweight=kernwgt], vce(cluster studentid)		

esttab, b(2) se(2) scalars(N) sfmt(2) starlevel(* 0.1 ** 0.05 *** 0.01) keep(treatment treatmentvol treatmentfor)
estimates drop _all



***table 4

gen 	sufficient=0
replace sufficient=1 if grade>=5.5

eststo: rdrobust attendance firstyeargpa if cohort<6 & coursepolicy=="voluntary", 	c(7) p(1) h(`=h') vce(cluster studentid) 
eststo: rdrobust attendance firstyeargpa if cohort<6 & coursepolicy=="encouraged", 	c(7) p(1) h(`=h') vce(cluster studentid) 
eststo: rdrobust attendance firstyeargpa if cohort<6 & coursepolicy=="forced", 		c(7) p(1) h(`=h') vce(cluster studentid) 
esttab , b(2) se(2) sfmt(0) starlevel(* 0.1 ** 0.05 *** 0.01) label nonotes noobs  
estimates drop _all 	

eststo: rdrobust stdgrade firstyeargpa if cohort<6 & coursepolicy=="voluntary", 	c(7) p(1) h(`=h') vce(cluster studentid) 
eststo: rdrobust stdgrade firstyeargpa if cohort<6 & coursepolicy=="encouraged", 	c(7) p(1) h(`=h') vce(cluster studentid) 
eststo: rdrobust stdgrade firstyeargpa if cohort<6 & coursepolicy=="forced", 		c(7) p(1) h(`=h') vce(cluster studentid) 
esttab , b(2) se(2) sfmt(0) starlevel(* 0.1 ** 0.05 *** 0.01) label nonotes noobs  
estimates drop _all 

eststo: rdrobust sufficient firstyeargpa if cohort<6 & coursepolicy=="voluntary", 	c(7) p(1) h(`=h') vce(cluster studentid) 
eststo: rdrobust sufficient firstyeargpa if cohort<6 & coursepolicy=="encouraged", 	c(7) p(1) h(`=h') vce(cluster studentid) 
eststo: rdrobust sufficient firstyeargpa if cohort<6 & coursepolicy=="forced", 		c(7) p(1) h(`=h') vce(cluster studentid) 
esttab , b(2) se(2) sfmt(0) starlevel(* 0.1 ** 0.05 *** 0.01) label nonotes noobs  
estimates drop _all 



***table 5

sum grade if cohort<6  & treatment==1 & firstyeargpa>=6.9 & firstyeargpa< 7.0 & coursepolicy=="voluntary"
local a=r(mean)
sum grade if cohort<6  & treatment==0 & firstyeargpa>=7   & firstyeargpa<=7.1 & coursepolicy=="voluntary"
local b=r(mean)
sum grade if cohort==6 & treatment==1 & firstyeargpa>=6.9 & firstyeargpa< 7.0 & coursepolicy=="voluntary"
local c=r(mean)
sum grade if cohort==6 & treatment==0 & firstyeargpa>=7.0 & firstyeargpa<=7.1 & coursepolicy=="voluntary"
local d=r(mean)
di "`a'   `b'"
di "`c'   `d'"
di (`a'-`b')-(`c'-`d')



***figure A.4

set more off
local n=1
gen Bandwidth=.
gen Estimate=.
gen CI_l=.
gen CI_u=.
gen Pvalue=.
gen N=.
quietly forvalues x=0.1(0.005)0.50{
	local nx=`n'	
	g KernWgtB = (treatment*(1-abs((-firstyeargpa + 7)/`x')) + (1-treatment)*(1-abs((firstyeargpa - 7)/`x')))/`x'
	replace KernWgtB = 0 if firstyeargpa<(7-`x') | firstyeargpa>(7+`x')
	reg stdgrade treatment pol1 pol1t if firstyeargpa>=(7-`x') & firstyeargpa<=(7+`x') & cohort<6 & coursepolicy=="voluntary" [aweight=KernWgtB], vce(cluster studentid)	
	replace Estimate=_b[treatment] in `nx'
	replace CI_l=_b[treatment]+(invt(e(df_r),0.05)*_se[treatment]) in `nx'
	replace CI_u=_b[treatment]+(invt(e(df_r),0.95)*_se[treatment]) in `nx'
	replace Pvalue=(2 * ttail(e(df_r), abs(_b[treatment]/_se[treatment]))) in `nx'
	replace Bandwidth=`x' in `nx'	
	replace N=e(N) in `nx'
	drop KernWgtB
	local n=`nx'+1
	}
twoway (scatter CI_l Bandwidth, msymbol(X) mlcolor(red) mfcolor(red)) ///
(scatter Estimate Bandwidth, msymbol(Oh) mlcolor(black) mfcolor(black)) ///
(scatter CI_u Bandwidth, msymbol(X) mlcolor(red) mfcolor(red)) ///
, ytitle("Policy Effect on Grades") xtitle("Bandwidth") ylabel(, nogrid) yline(0, lwidth(medium) lpattern(dash) lcolor(gs0)) graphregion(fcolor(white) lcolor(white)) ///
legend(order(1 "90 percent confidence bands" 2 "Point Estimate"))	
drop Bandwidth-N



***table A.6

eststo: rdrobust stdgradeabolition firstyeargpa if cohort==6 & coursepolicy=="voluntary", 	c(7) p(1) h(`=h') vce(cluster studentid) 
eststo: rdrobust stdgradeabolition firstyeargpa if cohort==6 & coursepolicy=="encouraged", 	c(7) p(1) h(`=h') vce(cluster studentid) 
eststo: rdrobust stdgradeabolition firstyeargpa if cohort==6 & coursepolicy=="forced", 		c(7) p(1) h(`=h') vce(cluster studentid) 
esttab , b(2) se(2) sfmt(0) starlevel(* 0.1 ** 0.05 *** 0.01) label nonotes noobs  
estimates drop _all 


***table A.7

gen courses=1
bysort studentid: egen numberofcourses=total(courses) if cohort<6 

preserve
keep if cohort<6
duplicates drop studentid, force
eststo: rdrobust numberofcourses firstyeargpa, c(7) p(1) h(`=h') vce(cluster studentid) 
esttab , b(2) se(2) sfmt(0) starlevel(* 0.1 ** 0.05 *** 0.01) label nonotes noobs  // results are approximate, as this dataset does not allow us to count the second-year courses where the exams consists of group exercises.
estimates drop _all
restore	



***table A.10

eststo: rdrobust attendance firstyeargpa 	if cohort<6 & coursepolicy=="voluntary", c(7) p(1) all 	vce(cluster studentid) 
rdbwselect attendance firstyeargpa 			if cohort<6 & coursepolicy=="voluntary", c(7) p(1) all 	vce(cluster studentid) 
eststo: rdrobust attendance firstyeargpa 	if cohort<6 & coursepolicy=="encouraged", c(7) p(1) all vce(cluster studentid)  
rdbwselect attendance firstyeargpa 			if cohort<6 & coursepolicy=="encouraged", c(7) p(1) all vce(cluster studentid) 
eststo: rdrobust attendance firstyeargpa 	if cohort<6 & coursepolicy=="forced", c(7) p(1) all 	vce(cluster studentid) 
rdbwselect attendance firstyeargpa 			if cohort<6 & coursepolicy=="forced", c(7) p(1) all 	vce(cluster studentid) 
esttab , b(2) se(2) sfmt(0) starlevel(* 0.1 ** 0.05 *** 0.01) label nonotes noobs  
estimates drop _all 

eststo: rdrobust stdgrade firstyeargpa 		if cohort<6 & coursepolicy=="voluntary", c(7) p(1) all 	vce(cluster studentid) 
rdbwselect stdgrade firstyeargpa 			if cohort<6 & coursepolicy=="voluntary", c(7) p(1) all 	vce(cluster studentid) 
eststo: rdrobust stdgrade firstyeargpa 		if cohort<6 & coursepolicy=="encouraged", c(7) p(1) all vce(cluster studentid)  
rdbwselect stdgrade firstyeargpa 			if cohort<6 & coursepolicy=="encouraged", c(7) p(1) all vce(cluster studentid) 
eststo: rdrobust stdgrade firstyeargpa 		if cohort<6 & coursepolicy=="forced", c(7) p(1) all 	vce(cluster studentid) 
rdbwselect stdgrade firstyeargpa 			if cohort<6 & coursepolicy=="forced", c(7) p(1) all 	vce(cluster studentid) 
esttab , b(2) se(2) sfmt(0) starlevel(* 0.1 ** 0.05 *** 0.01) label nonotes noobs  
estimates drop _all 

eststo: rdrobust sufficient firstyeargpa 	if cohort<6 & coursepolicy=="voluntary", c(7) p(1) all 	vce(cluster studentid) 
rdbwselect sufficient firstyeargpa 			if cohort<6 & coursepolicy=="voluntary", c(7) p(1) all 	vce(cluster studentid) 
eststo: rdrobust sufficient firstyeargpa 	if cohort<6 & coursepolicy=="encouraged", c(7) p(1) all vce(cluster studentid)  
rdbwselect sufficient firstyeargpa 			if cohort<6 & coursepolicy=="encouraged", c(7) p(1) all vce(cluster studentid) 
eststo: rdrobust sufficient firstyeargpa 	if cohort<6 & coursepolicy=="forced", c(7) p(1) all 	vce(cluster studentid) 
rdbwselect sufficient firstyeargpa 			if cohort<6 & coursepolicy=="forced", c(7) p(1) all 	vce(cluster studentid) 
esttab , b(2) se(2) sfmt(0) starlevel(* 0.1 ** 0.05 *** 0.01) label nonotes noobs  
estimates drop _all 	
