function WW = w_gauss(t,T,H,sided)
	% the procedure computes a Tx1 vector of kernel weights to be used in
	% estimation at time t
    
   % INPUT 
   % t = current observation
   % T = sample size
   % H = smoothing parameter
   % sided =1 one sided filter (double the window size), 2 two sided filter  

if sided==1
    x=((1:T)-t)/(2*H);
    w_t = (1/sqrt(2*pi))*exp((-x.^2)/2);    
    ww = [w_t(1:t) zeros(1,T-t)];
    www = ww./(sum(ww));   
elseif sided==2
    x=((1:T)-t)/(H);
    w_t = (1/sqrt(2*pi))*exp((-x.^2)/2);        
    ww=w_t;
    www = ww./(sum(ww));
end
WW=diag(www);
