function [y_ff,rss]=var_prior(pos_phi,pos_H,lags,hmax,m,TT,y_l,x_l,slopes)
% this function computes forecasts and RSS 
% INPUT:     pos_phi  = position in the PHI Grid (scalar)
%            pos_H    = position in the H Grid (scalar)
%            lags is the # of lags of the VAR (scalar)
% 	         hmax  is the highest step ahead forecast (scalar)
%            m is the number of variables in the VAR (scalar)%       
%            TT is sample size
%            y_l = matrix of LHS variables
%            x_l = matrix of RHS regressors
%            slopes = cell of VAR coefficients estimated
% OUPTUT: y_ff = VAR forecasts for 1 to hmax steps ahead
%          rss = residual sum of squares (needed for optimization later)
%         rss =(y_ll(1:TT,:)-x_ll(1:TT,:)*b)'*(y_ll(1:TT,:)-x_ll(1:TT,:)*b)/TT;
b=slopes{pos_phi,pos_H};
%      RSS
rss =diag((y_l-x_l*b)'*(y_l-x_l*b)/(TT));
%      now perform recursive forecasts
y_f = y_l(TT,:);
x_f = x_l(TT,:);
y_ff = zeros(hmax,m);
for llags = 1:hmax
    x_f  = [y_f x_f(1,1:m*lags-m) 1];
    y_f  = x_f*b;
    y_ff(llags,:) = y_f;
end;    
% %%%%%%%%%%%%%%%%
