function [y_ff,rss]=var_RW(hmax,m,TT,y_l,x_l)
% /* INPUT:  y is the data (TTxn matrix)
% estimate the drift/constant: it is the mean of dy = y_t-y_(t-1)
dy = y_l-x_l(:,1:m);
mu = mean(dy);

resids = dy-repmat(mu,TT,1);
%      RSS
rss = diag(resids'*resids /TT);

%      now perform recursive forecasts
y_f   = y_l(TT,:);
y_ff  = zeros(hmax,m);
for llags = 1:hmax
    y_ff(llags,:) = y_f+llags*mu;
end;    
% %%%%%%%%%%%%%%%%
% 
