function y=recserar(x,y0,a)
% Computes a vector of autoregressive recursive series.
% RECSERAR(x,y0,a) constructs 
% K recursive time series of dimension N
% INPUT  x: NxK   y0: PxK   a: PxK   
% OUTPUT y: NxK
% y(t)=x(t)+a(1)y(t-1)+...a(p)y(t-p) for t=p+1,..N
% y(t)=y0(t) for t=1,..P
y=[];
y=y0;

p=size(y0,1); n=size(x,1);
for i=p+1:n
   maty=flipud(y(i-p:i-1,:));
   y(i,:)=maty.*a+x(i,:);
end
