function [xycov,xycorr] = myxcov(x,y,lags) 
% INPUT
% x is a T sized vector
% y is a T sized vector
% lags is the number of lags
% OUTPUT 
% xycov is 2*lags+1 covariance vector with covariances between x(t) and
% y(t-lags) y(t-lags+1)... y(t) y(t+1) y(t+2) ... y(t+lags)
% xycorr is 2*lags+1 correlation vector with correlations between x(t) and
% y(t-lags) y(t-lags+1)... y(t) y(t+1) y(t+2) ... y(t+lags)

if (size(x,2)>1)||(size(y,2)>1)
    error('x and y must be vectors');
end

if (size(x,1)>size(y,1))||(size(y,1)>size(x,1))
    error('x and y must have the same size')
end

if lags>(size(x,1)-1)
    error('sample too short (shorten the lags)')
end

xycov = NaN(2*lags+1,1);
xycorr = NaN(2*lags+1,1);
for kk=lags:-1:0
    xx=x(kk+1:end);
    yy=y(1:end-kk);  
    temp = cov(xx,yy);
    xycov(lags-kk+1) = temp(1,2);
    temp = corr(xx,yy);    
    xycorr(lags-kk+1) = temp(1);
end

for kk=1:lags
    yy=y(kk+1:end);
    xx=x(1:end-kk);    
    temp = cov(xx,yy);
    xycov(lags+1+kk) = temp(1,2);
    temp = corr(xx,yy);      
    xycorr(lags+1+kk) = temp(1);
end
