function [ee,et,la] = matrixaa_rwalkeig(laa,theta_low)

 % local n,a,et,ee,i,j,la;
 
 n=(-1+sqrt(1+4*size(laa,2)))/2; % this is the positive root to the equation m^2+m=size(laa,2)

 %Extract portion of matrix for G-smidht, this will be P
 a=reshape(laa(1:n^2),n,n);
 
 %Extract portion of matrix for eigevenvalues, this will be L
 la=laa(n^2+1:n^2+n);
 % make bounds for eigenvalues between ondiag and .99
 % this allows for some time variation in the first lag while justifying
 % Minnesota prior

 la_adj = boundfunc(la,theta_low);
 
 % Now initiaize Grahm Shmidt: first vector just as it is
 et = a(:,1)/((a(:,1)'*a(:,1)).^0.5);
 i=2;
 while i <= n;
     ee = a(:,i);
     j=1;
      while j <= size(et,2);
        ee = ee-(a(:,i)'*et(:,j))*et(:,j); %take residuals from projections
        j=j+1;
      end;
 ee = ee./((ee'*ee).^0.5); % normalize vectors
 et = [et ee];
 i=i+1;
 end;
 
 ee = et*(diag(la_adj))*et';
    