function [sigu_ar,Omega,OmegaprimeOmega] =get_Omega(T_est,m,lags,y_l,x_l)
% get an estimate of Omega and OmegaprimeOmega matrices which remain the
% same for all the models
    constvec     = ones(T_est,1);    
    sigu_ar = zeros(1,m);
    for ll=1:m;
        y_l_ar = y_l(:,ll);
        pos_ar = seqa(ll,m,lags);
        x_l_ar = [x_l(:,pos_ar') constvec];
        Proj_x = x_l_ar*((x_l_ar'*x_l_ar)\x_l_ar')*y_l_ar;
        sigu_ar(1,ll)=(y_l_ar-Proj_x)'*(y_l_ar-Proj_x)/T_est;
    end;
    
sigmas=sigu_ar.^.5;
Omega=[kron(diag(1:lags),diag(sigmas)) zeros(m*lags,1); zeros(1,m*lags+1)];
Omega(end,end)=1/(1e+20);%//very lose prior on the constant like banbura et al.
OmegaprimeOmega = Omega'*Omega;
