% IN THIS EXERCISE THE COEFFICIENTS FOLLOW STOCHASTIC (BOUNDED) RANDOM WALKS
% AND WE INTRODUCE STOCHASTIC VOLATILITY

s = RandStream('mt19937ar','Seed',0);
RandStream.setGlobalStream(s);

% SETUP OF THE DGP
Nsimul  = 1000 ; % number of simulations in MCARLO exercise
ar(1)   = .5; % AR(1)  for shocks to stochastic coefficients (defined "e" later)
ar(2) =  0; % AR(1)  for shocks to variables in VAR (defined "u" later)
hmax    =  1; % max number of steps ahead forecasts
const   =  0; % whether or not to have a constant
lags    =  1;
sigma_v = .01; %variance of the log stoch-volatility process
ar_v    = 1;   %AR term in the the log stoch-volatility process


% SETUP OF THE NONPARAMETRIC ESTIMATOR
%% set the parameters of the exercise
H_grid             = 0.5:.1:.9;
H_gridsize         = length(H_grid);
basic_grid         = [10^(-5) 10^(-2) 10^(-1):.33:1];
phi_grid_KK        = basic_grid*.1;
phi_grid_kernel_temp    = phi_grid_KK;
for jj=1:4
    phi_grid_kernel_temp    = [phi_grid_kernel_temp 1.25*phi_grid_kernel_temp(end)+1.25*phi_grid_kernel_temp(end-length(basic_grid)+1:end)];
end
phi_grid_kernel             = phi_grid_kernel_temp(1:2:end);
phi_grid_KK                 = phi_grid_kernel;
m_grid      = [7 15];
obs_grid    = [100 150 200];
count_sim   = 0;
tot_sim     = length(m_grid)*length(obs_grid);
