function [OUT] = VAR_estimate_KK_3(data_1,True_lev,m,d1,V_i_grid,esti_start,esti_end,phi_gridsize,hmax,NN_VAR,lags,const)
nfore          = esti_end-esti_start+1;

OUT.errors_dms   = NaN(nfore,hmax,NN_VAR);
OUT.errors_dma   = NaN(nfore,hmax,NN_VAR);
OUT.forecast = NaN(nfore,hmax,NN_VAR);

% first normalize the data

[data,std_mat,med_mat]= normaliz(data_1);
kappa            = .96;
[yy_ll,xx_ll]    = matrix_var(data(1:esti_start,:),lags,esti_start,m);
Sigma_0          = single(cov(yy_ll));
vec_sum          = ones(phi_gridsize,1); % to be used for sums below
for pp=1:phi_gridsize
%    pp
        V_prior   = V_i_grid{pp};
        prior_theta_mean = d1; % I dati sono in differenze prime
        prior_theta_V    = V_prior;
        %[y_FORGET,pred_err,F_pred_err] = var_KK_2(prior_theta_mean,prior_theta_V,data,True_lev,m,Sigma_0,kappa,lambda,hmax,NN_VAR,lags,esti_start,esti_end-hmax,1,0,0);
        [y_FORGET{pp},coeffs{pp},lambda_t{pp},pred_e{pp},pred_F{pp}] = var_KK_3(prior_theta_mean,prior_theta_V,data,True_lev,m,Sigma_0,kappa,hmax,NN_VAR,lags,esti_start,esti_end,std_mat(1,:),med_mat(1,:),const);
end

% now determine optimal shrinkage as the value within posgrid_phi that
% maximizes model weights.
% start with equal model weights
p_predict_temp(1,1:phi_gridsize) = 1/phi_gridsize;    
for tt=2:nfore+1
    % update weights
    for jj=1:phi_gridsize
        % get predictive likelihood of model jj at time tt-1
        p_jj           = mvnpdfs(pred_e{jj}(tt-1,:)', zeros(NN_VAR,1),squeeze(pred_F{jj}(tt-1,:,:)));
        pupd_jj(tt,jj) = p_predict_temp(tt-1,jj)*p_jj;
    end

    denominator_upd     = pupd_jj(tt,:)*vec_sum;
    p_update(tt,:)      = pupd_jj(tt,:)./denominator_upd;

    denominator_pred    = (p_update(tt,:).^.99)*vec_sum;
    p_predict_temp(tt,1:phi_gridsize) =  p_update(tt,:).^.99./denominator_pred;
% 
end
% get rid of initial condition
p_predict           = p_predict_temp(2:end,:);

[~,ind_DMS]         = max(p_predict,[],2);
 yy_temp  = NaN(nfore,phi_gridsize,hmax,NN_VAR);
for ll=1:phi_gridsize
    yy_temp(:,ll,:,:) = squeeze(y_FORGET{ll}.errors);
end
for hh=1:hmax
    for oo=1:NN_VAR
        OUT.errors_dma(:,hh,oo)      = squeeze(sum(p_predict.*(yy_temp(:,:,hh,oo)),2));
    end
end
for ll=1:nfore
    % FORECASTS AND FORECAST ERRORS FROM DMS
    OUT.errors_dms   = squeeze(y_FORGET{ind_DMS(ll)}.errors);
    OUT.forecast     = squeeze(y_FORGET{ind_DMS(ll)}.forecast);   
end