function result = FluctuationGR(Loss,m)
%This file calculates Giacomini-Rossi's Fluctuation test with the Diebold-Mariano-West's 
%statistics, and plots the Giacomini-Rossi's Fluctuations bands
% Loss is the difference in squared errors
% m is the size of the window to smooth forecasts
% Pred = # of predictions

% Fluctuation test for Time Varying Predictive Performance
% Rolling tests
DMrollv = [];
Pred    = size(Loss,1);
for s=1:Pred-m+1;
    frollhere=Loss(s:s+m-1,:); 
    varfrollhere=cov(frollhere)/m; 
    DMrollhere=media(frollhere)/sqrt(varfrollhere);  
    DMrollv=[DMrollv;DMrollhere]; 
end

% tvechere=tvec(R+1+round(m/2):end,:); 
% tvechere=tvechere(1:Pred-m+1,:); 
% tdshere=tds(R+1+round(m/2):end,:);  
% tdshere=tdshere(1:Pred-m+1,:); 
mu=m/Pred; 
alpha   = 0.10; %one-sided
k       = GiacominiRossiCV(mu,alpha);
result  = [DMrollv,k*ones(rows(DMrollv),1)];