function CSSE = CSSECharts(BenchErrors,ModelErrors,hmax,ForeHorizon,dates,Titles,LOCS)
CSSE  =cell(4,1);
kk=0;
figure;
for HorCSSE = ForeHorizon
    kk=kk+1;
    ErrBench    = squeeze(BenchErrors(hmax+1:end,HorCSSE,1:3));
    ErrMod      = squeeze(ModelErrors(hmax+1:end,HorCSSE,1:3));
    CSSE{kk}   =  cumsum(ErrBench.^2-ErrMod.^2);
    dates_cut   = dates(hmax+1:end);
    % FIGURE CSSE (normalized)
     h=subplot(2,2,kk);
    Toplot         = CSSE{kk};
    ToplotStandard = bsxfun(@times,Toplot,1./std(Toplot));    
    %hFit   = plot(dates(hmax+1:end),ToplotStandard);
    hFit   = plot(dates(hmax+1:end),ToplotStandard);
    set(gca,'XTick',dates_cut(1:60:end),'Fontsize',18)
    datetick('x','yy','keepticks');
    p=get(h,'pos');
    p(1) = p(1) - 0.025;
    p(2) = p(2) - 0.025;
    p(3) = p(3) + 0.05;
   
    p(4) = p(4) + 0.05;
    set(h, 'pos', p);
 
    axis tight
    %recessionplot
    title([num2str(HorCSSE),' steps ahead'],'Fontsize',18)
    set(hFit(1),'Color','b','LineWidth',4);
    %set(hFit(2),'LineStyle','--','Marker','o','Color','r', 'markersize',3,'LineWidth',1);
    set(hFit(2),'LineStyle',':','LineWidth',5,'Color','r');
    set(hFit(3),'LineStyle','-.','LineWidth',4,'Color','g');
    clear aa
    if kk==1
        aa=LOCS{kk};
        legend(Titles,'Location',aa(:)','Fontsize',18)
    end
    grid 'off'
end