function [DM, PDM,RMSE,HandleAx,HandleFig]=BarCharts(BenchErrors,ModelErrors,hmax,hors,targets,loss,wind,HorsForGraph,Titles)

clear DM* PDM* RMSE*
for variable =1:3
    ErrBench.(targets{variable})      = squeeze(BenchErrors(hmax+1:end,hors,variable));
    ErrMod.(targets{variable})        = squeeze(ModelErrors(hmax+1:end,hors,variable));
    [DM.(targets{variable}), PDM.(targets{variable}),RMSE.(targets{variable})]...
                                       = DMTests(hmax,ErrBench.(targets{variable}),ErrMod.(targets{variable}),loss,wind);
end
NumbHorsForGraph = length(HorsForGraph);
ticks = 1:NumbHorsForGraph;
%% BAR GRAPHS 
figure
for variable=1:3
    tabout         = RMSE.(targets{variable})(HorsForGraph);
    control_matrix = PDM.(targets{variable})(HorsForGraph)<.1;
    subplot(1,3,variable);
    for ll = 1:NumbHorsForGraph
        hh=bar(ll,tabout(1,ll));
        check_dm = control_matrix(1,ll)==1;
        % change colors according to the D-Mariano test
        if check_dm == 1
            col = 'r';
        else
            col = [0.3 0.3 0.3];
        end
        set(hh, 'FaceColor', col)
        hold on;
    end
    hold on;
    plot(0:NumbHorsForGraph+1,ones(NumbHorsForGraph+2,1),'k','LineWidth',1);
    title(Titles{variable},'FontName','Arial','Fontsize',38);
    set(gca,'xlim',[0 NumbHorsForGraph+1],'XTickLabel',HorsForGraph(ticks),'XTick',ticks,'XGrid','off');
    set(gca,'ylim',[0 4]);
    xlabel('Horizon');     
%    ylabel('Relative RMSE')
    set(gca,'FontName','Arial','Fontsize',38,'GridLineStyle',':','XGrid','off');
    clear hh check_dm col tabout control_matrix
end
HandleAx = get(gca);
HandleFig= get(gcf);
