
CREATE TABLE  data (
  ID bigint not NULL,
  VID bigint NOT NULL,
  SEQ int NOT NULL,
  VALUE double precision default NULL,
  UNIQUE (ID,VID,SEQ)
);


--
-- Struttura della tabella info
--
CREATE TABLE info (
  OID  int not null,
  KWORD char(255) NOT NULL,
  T int NOT NULL,
  VD double precision default NULL,
  VS char(255) default NULL
);

INSERT INTO info VALUES(1,'VERSION',0,1.0,NULL);

--
-- Struttura della tabella meta
--
CREATE TABLE meta (
  XID bigserial,
  ID int  NOT NULL,
  VID int  NOT NULL,
  MID int  NOT NULL,  
  UNIQUE  (ID,VID, MID)
);

-- --------------------------------------------------------

--
-- Struttura della tabella metaname
--

CREATE TABLE metaname (
  MID bigserial,
  TID int NOT NULL,
  Name varchar(255) default NULL
);

-- --------------------------------------------------------

--
-- Struttura della tabella metanum
--

CREATE TABLE metanum (
  XID bigserial,
  VALUE double precision default NULL
);

-- --------------------------------------------------------

--
-- Struttura della tabella metastr
--

CREATE TABLE metastr (
  XID bigserial,
  VALUE varchar(1024) default NULL 
);

-- --------------------------------------------------------

--
-- Struttura della tabella series
--

CREATE TABLE series (
  ID bigserial,
  Name varchar(255) NOT NULL unique,
  Freq int NOT NULL 
);

-- --------------------------------------------------------

--
-- Struttura della tabella version
--

CREATE TABLE version (
  VID bigserial,
  ID int  NOT NULL,
  Rel int NOT NULL,
  Start_year int NOT NULL,
  Start_period int NOT NULL,
  Version int default NULL,
  Resolution int default NULL,
  UNIQUE (VID,ID)
);

