clear; 
clc; 
close all; 
warning('off');
addpath(genpath(pwd));

%% NAME OF DIRECTORY OF OUTPUT
DirOut = [pwd,filesep,'output_forecast',filesep];
if exist(DirOut,'dir')==0
    mkdir(DirOut)
end

%% set the parameters of the exercise
H_grid        = 0.5:.1:1;
kernshape     = 'gauss';
phi_grid      = [10^(-10) 10^(-5) 10^(-4) 10^(-3) 10^(-2):.03:1].^.5;

optimize_step = 1; % determines how frequently you want to optimize tightness
H_gridsize    = length(H_grid);
phi_gridsize  = length(phi_grid);
mods          = 1;% 1 for 20 variables model, 2 for 78 variables model
NN_VAR        = 3;% # of variables to store in forecasting
NN_VAR_Lfit   = 3; % Number of Variables to take into account in L_fit method
NN_VAR_Lse    = 3; % Number of Variables to take into account in L_mse method

if NN_VAR_Lse>NN_VAR
    error('Need to store more variables if you want to analyze them with L_mse')
end

FileOutput = [pwd,'\output_forecast\ModSize','_',num2str(mods),'_JAE'];
disp(['save output in ',FileOutput])

%% prepare the data for the analysis
load('data_20_78')
if mods==1
        gamma_mean   = prior_MED;
        dataselect   = data_MED(1:T,:);
        disp('Run Models with 20 indicators')        
elseif mods==2
        gamma_mean   = prior_LAR;
        dataselect   = data_LAR(1:T,:);
        disp('Run Models with 78 indicators')
end
m               =   size(dataselect,2); % number of variables in the VAR
YY_tt           =   datamat(esti_start-presample-lags+1:esti_start,:);

%% RUN THE FORECASTS
run_models;
% MainRunModels; %this saves the results
disp(['Results saved in ',FileOutput])