clear; 
clc;
benchmodel  ='ERRORFULL{2}'; % This will set as benchmark the large BVAR with an expanding window
% DirOut = [pwd,filesep,'output_forecast',filesep];
NameFile20Variables = ['ModSize_1_JAE'];
NameFile78Variables = ['ModSize_2_JAE'];

%addpath('\\gimecb01\data\ECB business areas\DGI\Databases and Programme files\IPA\Personal folders\Venditti\Research\VARCodes\CodeRepository');
SmoothFore          = 120;
% PARAMETER FOR SELECTION UNDER MSE METHOD
hhh           = 3; % steps ahead da considerare per minimizzare l'MSE in Method-2
LL_MSE        = 36+hhh; % # di forecast errors to minimise MSE in Method-1
NN_VAR_Lfit   = 3; % Number of Variables to take into account in L_fit method
NN_VAR_Lse   = 3; % Number of Variables to take into account in L_mse method
hors  = [1:24];

set_graph_defaults;
set(0,'DefaultFigurePaperOrientation','Landscape')
set(0,'DefaultFigurePaperType','A4')
set(0,'DefaultFigurePaperUnits','centi  meters')
paperpos=[0.6345 0.6345 28.4084 19.7150];
set(0,'DefaultFigurePaperPosition',paperpos)
set(0,'DefaultFigurePaperPositionMode','Manual')
set(0,'DefaultAxesXgrid','on'  )
set(0,'DefaultAxesYgrid','on'  )
set(0,'DefaultAxesFontsize',10)

% load(NameFile20Variables);

yyyy  = [kron([1970:2010]',ones(12,1));2011*ones(7,1)];
T_N = size(yyyy,1);
mmmm  = [kron(ones(41,1),(1:12)');(1:7)'];  
dddd  = ones(T_N,1);
date  = [yyyy mmmm dddd];
xaxis = datestr(datenum(date),'yyyy');


target_ols      = NaN(nfore,H_gridsize,phi_gridsize);
target_mse      = NaN(nfore,H_gridsize,phi_gridsize);
pos_mse         = NaN(nfore,H_gridsize);
pos_ols         = NaN(nfore,H_gridsize);
relative_ols    = NaN(nfore,H_gridsize);
relative_mse    = NaN(nfore,H_gridsize);
targets         = {'cpi','ffrate','empl'};

%% compute optimal Phis/H given forecast errors
for tt=1:nfore
    rss_ols      = repmat(squeeze(VAR_NN.rss(tt,1:NN_VAR_Lfit))',1,phi_gridsize);
    rss_rw       = repmat(squeeze(RW.rss(tt,1:NN_VAR_Lfit))',1,phi_gridsize);
    rss_full     = squeeze(FULL.rss(tt,:,1:NN_VAR_Lfit))';
    target_ols_full(tt,:)                         = mean((abs(rss_full./rss_rw-rss_ols./rss_rw)'),2);
    % POSPHIFULL{1} is time varying shrinkage in Constant Coeffs VAR
    [relative_ols_full(tt,1),POSPHIFULL{1}(tt,1)] = min(target_ols_full(tt,:));
    % POSPHIFULL{2} is constant shrinkage set in pre-sample in Constant Coeffs VAR
    if tt==1
        POSPHIFULL{2}(tt,1) = POSPHIFULL{1}(tt,1);
    else
        POSPHIFULL{2}(tt,1) = POSPHIFULL{2}(tt-1,1);
    end
    
    for HH=1:H_gridsize
        % METHOD 1: Minimize In sample fit difference w.r.t. OLS
        rss_kern     = squeeze(KERNEL.rss(tt,:,HH,1:NN_VAR_Lfit))';
        target_ols(tt,HH,:)   = mean((abs(rss_kern./rss_rw-rss_ols./rss_rw)'),2);
        [relative_ols(HH,1),POSPHI{1}(tt,HH)]=min(target_ols(tt,HH,:));
        % model 1: phi chosen with L_fit at EACH T conditional on HH
        % model 2: phi chosen with L_fit in PRESAMPLE conditional on HH and
        % then fixed
        if tt==1
            POSPHI{2}(tt,HH) = POSPHI{1}(tt,HH);
        else
            POSPHI{2}(tt,HH) = POSPHI{2}(tt-1,HH);
        end
        % model 5: phi chosen with L_mse conditional on HH
        if tt<=LL_MSE % for the first LL_MSE observations fix this shrinkage to OLS method
            POSPHI{5}(tt,HH)  = POSPHI{2}(tt,HH);
            POSPHI{6}(tt,HH)  = POSPHI{2}(tt,HH);
        else
            % from LL_MSE onwards start selecting one step ahead forecast errors
            err_kern           = squeeze(KERNEL.errors(tt-LL_MSE+1:tt-hhh-1,:,HH,hhh,1:NN_VAR_Lse));
            mse_kern           = (squeeze(sum((err_kern.^2),1)))./LL_MSE;
            mse_y              = std(YY_tt(lags+1:esti_start+tt-1,1:NN_VAR_Lse)).^2;
            target_mse(tt,HH,:)= mean(mse_kern./repmat(mse_y,phi_gridsize,1),2);
            [relative_mse(HH,1),POSPHI{5}(tt,HH)]=min(target_mse(tt,HH,:));
            % model 10: keep phi constant with L_mse at the first feasible tt
            if tt==LL_MSE+1 % keep constant
                POSPHI{6}(tt,HH) = POSPHI{5}(tt,HH);
            else
                POSPHI{6}(tt,HH) = POSPHI{6}(tt-1,HH);
            end
        end
    end
    
    %% now chose optimal H with METHOD-1
    % MODEL 3: phi time varying with Lfit
    clear temp;
    for gg=1:H_gridsize;
        temp(gg)= squeeze(target_ols(tt,gg,POSPHI{1}(tt,gg)));
    end
    [val,POSH{3,1}(tt,1)]=min(temp);
    POSPHI{3}(tt,:) = POSPHI{1}(tt,POSH{3,1}(tt,1));
    % MODEL 4: phi fixed in pre sample Lfit
    clear temp;
    for gg=1:H_gridsize;
        temp(gg)= squeeze(target_ols(tt,gg,POSPHI{2}(tt,gg)));
    end
    [val,POSH{4,1}(tt,1)]=min(temp);
    POSPHI{4}(tt,:) = POSPHI{2}(tt,POSH{4,1}(tt,1));
    % now chose optimal H with METHOD-2
    % MODEL 7: phi time varying with L_mse
    clear temp;
    for gg=1:H_gridsize;
        temp(gg)= squeeze(target_mse(tt,gg,POSPHI{5}(tt,gg)));
    end
    [val,POSH{7,1}(tt,1)]=min(temp);
    POSPHI{7}(tt,:) = POSPHI{5}(tt,POSH{7,1}(tt,1));
    % MODEL 8: phi fixed in pre sample with L_mse
    clear temp;
    for gg=1:H_gridsize;
        temp(gg)= squeeze(target_mse(tt,gg,POSPHI{6}(tt,gg)));
    end
    [val,POSH{8,1}(tt,1)]=min(temp);
    POSPHI{8}(tt,:) = POSPHI{6}(tt,POSH{8,1}(tt,1));
end

%% GRAFICI PER IL PAPER
dates = datenum(date(:,1),date(:,2),date(:,3));
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FIGURE 1: OPTIMAL SMOOTHING PARAMETER
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ticks = 12:36:T_N;
close all;

figure(1)
% H - model 3
subplot(2,2,1)
plot(dates, H_grid(POSH{3}'),'Linewidth',4);
title('L_{fit} (\lambda Time Varying)','Fontsize',18,'Fontname','Arial');
set(gca,'Ylim',[0.25 1.1]);
set(gca,'XTick',dates(1:24:end),'Fontsize',14)
datetick('x','yy','keepticks'); % axis tight
% Add recession bands:
%recessionplot

% H - model 4
subplot(2,2,2)
plot(dates,H_grid(POSH{4}'),'Linewidth',4); title('L_{fit} (\lambda Fixed in presample)','Fontsize',18,'Fontname','Arial');
set(gca,'Ylim',[0.25 1.1]);
set(gca,'XTick',dates(1:24:end),'Fontsize',14)
datetick('x','yy','keepticks');%  axis tight
% Add recession bands:
%recessionplot

%% H - model 7
subplot(2,2,3)
plot(dates,H_grid(POSH{7}'),'Linewidth',4); title('L_{mse} (\lambda Time Varying)','Fontsize',18,'Fontname','Arial');
set(gca,'Ylim',[0.25 1.1]);
set(gca,'XTick',dates(1:24:end),'Fontsize',14)
datetick('x','yy','keepticks');
% Add recession bands:
%recessionplot


%% H - model 8
subplot(2,2,4)
plot(dates,H_grid(POSH{8}'),'Linewidth',4); title('L_{mse} (\lambda Fixed in presample)','Fontsize',18,'Fontname','Arial');
set(gca,'Ylim',[0.25 1.1]);
set(gca,'XTick',dates(1:24:end),'Fontsize',14)
datetick('x','yy','keepticks');
% Add recession bands:
%recessionplot

%% figure for Max's comment
%% H - model 7
figure(111)
plot(dates,H_grid(POSH{7}'),'Linewidth',4); title('L_{mse} (\lambda Time Varying)','Fontsize',18,'Fontname','Arial');
set(gca,'Ylim',[0.25 1.1]);
set(gca,'XTick',dates(1:24:end),'Fontsize',14)
datetick('x','yy','keepticks');

%% TABLES WITH RMSES and DIEBOLD MARIANO TEST
%SELECT ERRORS OF VARIOUS MODELS
for tt=1:nfore
    for gg=1:H_gridsize
        ERROR{1}(tt,gg,:,:)  = squeeze(KERNEL.errors(tt,POSPHI{1}(tt,gg),gg,:,:));
        ERROR{2}(tt,gg,:,:)  = squeeze(KERNEL.errors(tt,POSPHI{2}(tt,gg),gg,:,:));
        ERROR{5}(tt,gg,:,:)  = squeeze(KERNEL.errors(tt,POSPHI{5}(tt,gg),gg,:,:));
        ERROR{6}(tt,gg,:,:)  = squeeze(KERNEL.errors(tt,POSPHI{6}(tt,gg),gg,:,:));
    end
    ERROR{3}(tt,:,:)     = squeeze(KERNEL.errors(tt,POSPHI{3}(tt,1),POSH{3}(tt,1),:,:));
    ERROR{4}(tt,:,:)     = squeeze(KERNEL.errors(tt,POSPHI{4}(tt,1),POSH{4}(tt,1),:,:));
    ERROR{7}(tt,:,:)     = squeeze(KERNEL.errors(tt,POSPHI{7}(tt,1),POSH{7}(tt,1),:,:));
    ERROR{8}(tt,:,:)     = squeeze(KERNEL.errors(tt,POSPHI{8}(tt,1),POSH{8}(tt,1),:,:));
    
    ERRORFULL{1}(tt,:,:) = squeeze(FULL.errors(tt,POSPHIFULL{1}(tt,1),:,:));
    ERRORFULL{2}(tt,:,:) = squeeze(FULL.errors(tt,POSPHIFULL{2}(tt,1),:,:));
end

benchmodel_err = eval(benchmodel);

for kk=1:length(targets);
    RMSES_bench_full.(targets{kk})=[];
    DM.(targets{kk})=[];
    PDM.(targets{kk})=[];
end
for variable =1:3
    err_b = squeeze(benchmodel_err(hmax+1:end,hors,variable));
    bench  = rmse(err_b);  %% Recursive phi fixed benchmark
    for ll=1:8;
        errs = ERROR{ll};
        if size(errs,2)==H_gridsize%have more values for different grid value
            for gg=1:H_gridsize
                err_t  = squeeze(errs(hmax+1:end,gg,hors,variable));
                ergrid = rmse(err_t);
                RMSES_bench_full.(targets{variable}) = [RMSES_bench_full.(targets{variable});ergrid./bench];
                % DIEBOLD MARIANO TEST
                temp1=[];temp2=[];
                for h_dm=1:hmax
                    [dm,pdm] = dbmar(err_b(:,h_dm),err_t(:,h_dm),h_dm,h_dm,'SE','triang');
                    temp1 = [temp1 dm];
                    temp2 = [temp2 pdm];
                end
                DM.(targets{variable}) = [DM.(targets{variable});temp1] ;
                PDM.(targets{variable}) = [PDM.(targets{variable});temp2];
                clear temp1 temp2;
            end
        else
            err_t  = squeeze(errs(hmax+1:end,hors,variable));
            ergrid = rmse(err_t);
            RMSES_bench_full.(targets{variable}) = [RMSES_bench_full.(targets{variable});ergrid./bench];
            % DIEBOLD MARIANO TEST
            temp1=[];temp2=[];
            for h_dm=1:hmax
                [dm,pdm] = dbmar(err_b(:,h_dm),err_t(:,h_dm),h_dm,h_dm,'SE','triang');
                temp1 = [temp1 dm];
                temp2 = [temp2 pdm];
            end
            DM.(targets{variable}) = [DM.(targets{variable});temp1] ;
            PDM.(targets{variable}) = [PDM.(targets{variable});temp2];
            clear temp1 temp2;
            
        end
    end
end


aa=pwd;

clear towriteRMSE;
towriteRMSE = [...
    RMSES_bench_full.cpi(:,[1 6 12 24]) ...
    NaN(28,1)...
    RMSES_bench_full.empl(:,[1 6 12 24])...
    NaN(28,1)...
    RMSES_bench_full.ffrate(:,[1 6 12 24])];

clear towriteDM;
towriteDM = [...
    DM.cpi(:,[1 6 12 24]) ...
    NaN(28,1)...
    DM.empl(:,[1 6 12 24])...
    NaN(28,1)...
    DM.ffrate(:,[1 6 12 24])];

clear towritePDM;
towritePDM = [...
    PDM.cpi(:,[1 6 12 24]) ...
    NaN(28,1)...
    PDM.empl(:,[1 6 12 24])...
    NaN(28,1)...
    PDM.ffrate(:,[1 6 12 24])];
towrite_res = [towriteRMSE NaN(28,2) towriteDM NaN(28,2) towritePDM];
open towrite_res;


%% EQUAL WEIGHTS AVERAGING ACROSS MODELS
% Size of KERNEL.errors is as follows
% [T_N,phi_gridsize,H_gridsize,hors(end),3]
% equal weights average
ErrorsToAverage20 = squeeze(reshape(KERNEL.errors,[T_N,phi_gridsize*H_gridsize,hors(end),NN_VAR]));
ErrorsAverage20   = squeeze(mean(ErrorsToAverage20,2));
%% equal weights average with phi fixed in pre-sample (only TPV matter)
ErrorsToAverageFixedPhi20   = squeeze(KERNEL.errors(:,POSPHIFULL{2}(1),:,:,:));
ErrorsAverageFixedPhi20     = squeeze(mean(ErrorsToAverageFixedPhi20,2));
%%
% TVP VS FIXED 20 variables
BenchErrors = benchmodel_err;
HorsForGraph= [ 3 12 18 24];
CSSEForeHorizon = [3 12 18 24];
Titles = {'CPI','Fed Funds Rates','Employment'};

ModelErrors = ErrorsAverage20;
[DM20TvpVs20Fix, PDM20TvpVs20Fix,RMSE20TvpVs20Fix]=BarCharts(BenchErrors,ModelErrors,hmax,hors,targets,'SE','triang',HorsForGraph,Titles);
fullscreen; tightfig(gcf)
print(gcf,'-dpdf','RMSE_20TvpVs20Fix');
Locations={'NorthWest'};
CSSE20TvpVs20Fix  = CSSECharts(BenchErrors,ModelErrors,hmax,CSSEForeHorizon,dates,Titles,Locations);
fullscreen; pause(.5); tightfig(gcf)
print(gcf,'-dpdf','CSSE_20TvpVs20Fix');
Fluc20TvpVs20Fix = FluctGRCharts(BenchErrors,ModelErrors,CSSEForeHorizon,dates,Titles,Locations,SmoothFore);
print(gcf,'-dpdf','FLUC_20TvpVs20Fix');
%
Table1 = [RMSE20TvpVs20Fix.cpi(HorsForGraph);...
          RMSE20TvpVs20Fix.ffrate(HorsForGraph);...
          RMSE20TvpVs20Fix.empl(HorsForGraph);...
          NaN(1,size(HorsForGraph,2));...
          PDM20TvpVs20Fix.cpi(HorsForGraph);...
          PDM20TvpVs20Fix.ffrate(HorsForGraph);...
          PDM20TvpVs20Fix.empl(HorsForGraph)];
open('Table1');
%%
% Change to Fixed Phi
ModelErrors = ErrorsAverageFixedPhi20;
[DM20TvpFixedPhiVs20Fix, PDM20TvpFixedPhiVs20Fix,RMSE20TvpFixedPhiVs20Fix]=BarCharts(BenchErrors,ModelErrors,hmax,hors,targets,'SE','triang',HorsForGraph,Titles);
fullscreen
tightfig(gcf)
print(gcf,'-dpdf','RMSE_20TvpFixedPhiVs20Fix'); 
%%
Locations={'NorthWest'};
CSSE20TvpFixedPhiVs20Fix  = CSSECharts(BenchErrors,ModelErrors,hmax,CSSEForeHorizon,dates,Titles,Locations);
print(gcf,'-dpdf','CSSE_20TvpFixedPhiVs20Fix');
Fluc20TvpFixedPhiVs20Fix  = FluctGRCharts(BenchErrors,ModelErrors,CSSEForeHorizon,dates,Titles,Locations,SmoothFore);
print(gcf,'-dpdf','FLUC_20TvpFixedPhiVs20Fix');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% IN THIS SECTION DIMENSION SELECTION: DOES IT PAY OFF TO GO BIGGER THAN 20 if you focus on 3 variables?
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dates = datenum(date(:,1),date(:,2),date(:,3));
tt=1;

% FIND POSPHIFULL{2} in pre-sample in 78 variables VAR
rss_ols      = repmat(squeeze(VAR_NN.rss(tt,1:NN_VAR_Lfit))',1,phi_gridsize);
rss_rw       = repmat(squeeze(RW.rss(tt,1:NN_VAR_Lfit))',1,phi_gridsize);
rss_full     = squeeze(FULL.rss(tt,:,1:NN_VAR_Lfit))';
target_ols_full(tt,:)                         = mean((abs(rss_full./rss_rw-rss_ols./rss_rw)'),2);
[relative_ols_full(1,1),POSPHIFULL78{2}(1,1)] = min(target_ols_full(1,:));
%%
%COMPUTE ERRORS OF 78 VAR FIXED COEFFICIENTS MODEL WITH phi SELECTED IN PRE-SAMPLE
for tt=1:nfore
    ERRORFULL78(tt,:,:) = squeeze(FULL.errors(tt,POSPHIFULL78{2},:,:));
    
    for HH=1:H_gridsize
        % METHOD 1: Minimize In sample fit difference w.r.t. OLS
        rss_kern     = squeeze(KERNEL.rss(tt,:,HH,1:NN_VAR_Lfit))';
        target_ols(tt,HH,:)   = mean((abs(rss_kern./rss_rw-rss_ols./rss_rw)'),2);
        [relative_ols(HH,1),POSPHI78{1}(tt,HH)]=min(target_ols(tt,HH,:));
    end
    
    %% now chose optimal H with METHOD-1
    % MODEL 3: phi time varying with Lfit
    clear temp;
    for gg=1:H_gridsize;
        temp(gg)= squeeze(target_ols(tt,gg,POSPHI78{1}(tt,gg)));
    end
    [val,POSH78{3,1}(tt,1)]=min(temp);
    POSPHI78{3}(tt,:) = POSPHI78{1}(tt,POSH78{3,1}(tt,1));
    
end

%COMPUTE ERRORS OF 78 VAR TVP MODEL WITH EQUAL WEIGHTS AVERAGE
ErrorsToAverage78 = squeeze(reshape(KERNEL.errors,[T_N,phi_gridsize*H_gridsize,hors(end),NN_VAR]));
ErrorsAverage78   = squeeze(mean(ErrorsToAverage78,2));
% equal weights average with phi fixed in pre-sample (only TPV matter)
ErrorsToAverageFixedPhi78   = squeeze(KERNEL.errors(:,POSPHIFULL78{2}(1),:,:,:));
ErrorsAverageFixedPhi78   = squeeze(mean(ErrorsToAverageFixedPhi78,2));

ErrorsAverage78 = squeeze(mean(ErrorsToAverage78,2));
ErrorsAverageFixedPhi78 = squeeze(mean(ErrorsToAverageFixedPhi78,2));

clear temp* ErrBench ErrEqWeights

% QUESTION 1: SMALL TVP VS LARGE AND FIXED?
BenchErrors = ERRORFULL78;
ModelErrors = ErrorsAverage20;
[DM20TvpVs78Fix, PDM20TvpVs78Fix,RMSE20TvpVs78Fix]=BarCharts(BenchErrors,ModelErrors,hmax,hors,targets,'SE','triang',HorsForGraph,Titles);
fullscreen; tightfig(gcf)
print(gcf,'-dpdf','RMSE_20TvpVs78Fix');
Locations={'SouthWest'};
CSSE20TvpVs78Fix  = CSSECharts(BenchErrors,ModelErrors,hmax,CSSEForeHorizon,dates,Titles,Locations);
fullscreen; pause(.5); tightfig(gcf)
print(gcf,'-dpdf','CSSE_20TvpVs78Fix');
FLUC20TvpVs78Fix  = FluctGRCharts(BenchErrors,ModelErrors,CSSEForeHorizon,dates,Titles,Locations,SmoothFore);
print(gcf,'-dpdf','FLUC_20TvpVs78Fix');

Table2 = [RMSE20TvpVs78Fix.cpi(HorsForGraph);...
          RMSE20TvpVs78Fix.ffrate(HorsForGraph);...
          RMSE20TvpVs78Fix.empl(HorsForGraph);...
          NaN(1,size(HorsForGraph,2));...
          PDM20TvpVs78Fix.cpi(HorsForGraph);...
          PDM20TvpVs78Fix.ffrate(HorsForGraph);...
          PDM20TvpVs78Fix.empl(HorsForGraph)];
open('Table2');

% QUESTION 2: LARGE TVP VS LARGE FIXED
BenchErrors = ERRORFULL78;
ModelErrors = ErrorsAverage78;
%% Diebold Mariano tests
[DM78TvpVs78Fix, PDM78TvpVs78Fix,RMSE78TvpVs78Fix]=BarCharts(BenchErrors,ModelErrors,hmax,hors,targets,'SE','triang',HorsForGraph,Titles);
fullscreen; tightfig(gcf)
print(gcf,'-dpdf','RMSE_78TvpVs78Fix');
Locations={'SouthEast'};
CSSE78TvpVs78Fix = CSSECharts(BenchErrors,ModelErrors,hmax,CSSEForeHorizon,dates,Titles,Locations);
fullscreen; tightfig(gcf)
print(gcf,'-dpdf','CSSE_78TvpVs78Fix');
FLUC78TvpVs78Fix   = FluctGRCharts(BenchErrors,ModelErrors,CSSEForeHorizon,dates,Titles,Locations,SmoothFore);
fullscreen; tightfig(gcf)
print(gcf,'-dpdf','FLUC_78TvpVs78Fix');

% QUESTION 3: LARGE TVP VS SMALL TVP
BenchErrors = ErrorsAverage78;
ModelErrors = ErrorsAverage20;
%% Diebold Mariano tests
[DM78TvpVs20Tvp, PDM78TvpVs20Tvp,RMSE78TvpVs20Tvp]=BarCharts(BenchErrors,ModelErrors,hmax,hors,targets,'SE','triang',HorsForGraph,Titles);
fullscreen; tightfig(gcf)
print(gcf,'-dpdf','RMSE_20TvpVs78Tvp');
Locations={'SouthWest'};
CSSE78TvpVs20Tvp = CSSECharts(BenchErrors,ModelErrors,hmax,CSSEForeHorizon,dates,Titles,Locations);
fullscreen; pause(.5); tightfig(gcf)
print(gcf,'-dpdf','CSSE_20TvpVs78Tvp');
FLUC78TvpVs20Tvp   = FluctGRCharts(BenchErrors,ModelErrors,CSSEForeHorizon,dates,Titles,Locations,SmoothFore);
fullscreen; tightfig(gcf)
print(gcf,'-dpdf','FLUC_20TvpVs78Tvp');

Table3 = [RMSE78TvpVs78Fix.cpi(HorsForGraph);...
          RMSE78TvpVs78Fix.ffrate(HorsForGraph);...
          RMSE78TvpVs78Fix.empl(HorsForGraph);...
          NaN(1,size(HorsForGraph,2));...
          PDM78TvpVs78Fix.cpi(HorsForGraph);...
          PDM78TvpVs78Fix.ffrate(HorsForGraph);...
          PDM78TvpVs78Fix.empl(HorsForGraph)];
open('Table3');