/******************************************************
Monte Carlo Experiments to Assess the Coverage of
Marginal vs. Scheffe Bands for path forecasts.

"Path Forecasting Evaluation" by Oscar Jorda and
Massimiliano Marcellino (2008)

Revision for Journal of Applied Econometrics

Per referee requests
- The DGP is a VAR.
- The confidence bands include parameter estimation 
uncertainty
- the lag length of the VAR is pressumed to be unknown
and chosen with an information criterion

Author: Oscar Jorda
Initial Date: 6/18/2008
Last Updated: 6/27/2008
*******************************************************/
new;
cls;

// Use the next line to save your Monte Carlo Output
//output file = h1_t400_a05_h.out reset;
/*******************************************
Initial Analysis Choices
********************************************/
sample = 400;       // Sample 1960:I - 2007:I (189 obs)
alpha = 0.05;       // Size of tests
hmax = 8;           // Forecast horizon 

vars = 3;		    // variables in the data set 
plg = 1;		    // if plg = 0, lag length is set to maxp. if 1, lag length is chosen automatically 
maxp = 8;           // Max Lag for Info Criteria (SW choose 4)
infoc = 1;      	// 1 for AICc, 2 for AIC, 3 for SIC 
hlim = 12;          // Max forecast horizon
nreps = 1000;       // MC replications
freps = 1000;       // Forecast replilcations
dograph = 0;        // 1 to display graphs, 0 otherwise
psw = 4;            // lag length of VAR in SW(2001)
state   =   10;         //meaningless used for rng
pres    =   2;     //presample for graphs
/*************************************************
load the Data for the Stock and Watson (2001) VAR
*************************************************/
load z[] =  swqdata.csv; 
z = reshape(z,rows(z)/vars,vars);
TT = rows(z);
T = TT-hlim;        // reserve the last hlim obs for evaluation

sers = "P"$|"UN"$|"FF";        @Label your series here @

/********************************************
Estimate the VAR
*********************************************/
{beta, sig_u_sw, sig_a_sw} = varols(z[1:T,.], psw, 1);
/********************************************
The last entry in varols proc is zero if the vcv
of the coefficients is not wanted, 1 otherwise
Note that sig_sw is the vcv matrix of vec(beta'),
not of vec(beta)
********************************************/
/***************************************************
This section is to evaluate the SW VAR itself
and is not needed for the Monte Carlos
****************************************************/


/*********************************************
Estimate the local Projections
**********************************************/
{sig_lp_sw, sig_H_lp_sw, betlp_sw} = proj(z[1:T,.], hmax, psw); 
{sig_lp1_sw, sig_H_lp1_sw} = pirf(z[1:T,.], psw, hmax);
/**********************************************
sig_H_lp is calculated directly from the 
residuals as sig_H_lp = (u'u/T)

sig_h_lp1 is calculated using the estimated MA
coefficients from the projections, that is,
sig_H_LP1 = Phi*(eye(h).*.sig_u)*Phi'
**********************************************/
//{irf} = varirf(beta, psw, hmax); //IRF from VAR

// Forecast based on obs X_Tp
X_Tp = 1~reshape(z[T:T-psw,.],1,psw*vars);

// Forecast and forecast error variance (including estimation error)
{y_H_sw, Xi_H_sw, sig_H_sw} = varfcst(beta, psw, vars, sig_u_sw, hmax, sig_a_sw, X_Tp', T);

//Forecast from the projections
y_H_LP_sw = (X_Tp*betlp_sw)';

// Forecast error variance from projections (sig_H_LP)
Xi_H_LP_sw = (X_Tp.*.eye(vars*hmax))*sig_lp_sw*(X_Tp'.*.eye(vars*hmax));
Xi_H_LP_sw = Xi_H_LP_sw + sig_H_lp_sw;

// Forecast error variance from projections (sig_H_LP1)
Xi_H_LP1_sw = (X_Tp.*.eye(vars*hmax))*sig_lp1_sw*(X_Tp'.*.eye(vars*hmax));
Xi_H_LP1_sw = Xi_H_LP1_sw + sig_H_lp1_sw;



/**********************************************
The actual Monte Carlo instructions begin here
**********************************************/
if dograph eq 0;

/******************************************
Generate freps paths conditional on the last
observations from the actual data
******************************************/
yf = zeros(hmax*vars, freps);
//we will later stack the paths for the variables using vec()

i = 1;          //Counter
// Construct the regressors
//************************************************************
y = zeros(hmax,vars);
do while i le freps;
        xf = reshape(z[T:T-psw+1,.],1,psw*vars);
        {uf, state} = rndKMn(hmax,vars,state);
        y[1,.] = (1~xf)*beta + uf[1,.]*chol(sig_u_sw);
        h = 2;
        do while h le hmax;
            xf = y[h-1,.]~xf[.,1:vars*(psw-1)];
            y[h,.] = (1~xf)*beta + uf[h,.]*chol(sig_u_sw);
            h = h+1;
        endo;
        yf[.,i] = vec(y');
        i = i+1;
endo;

/************************************************************
From yf, one can recover the nth replication
in the original format with
reshape(yf[.,i],vars,hmax])'
************************************************************/

/************************************************************
Generate Nreps of samples of size "sample" to estimate
the parameters and generate forecasts from
************************************************************/
// Initialize the counters
// For VAR forecasts
var_m   =   zeros(vars,nreps);
var_b   =   zeros(vars,nreps);
var_s   =   zeros(vars,nreps);
var_c   =   zeros(vars,nreps);
var_wm  =   zeros(vars,nreps);
var_wb  =   zeros(vars,nreps);
var_ws  =   zeros(vars,nreps);
var_wc  =   zeros(vars,nreps);
//For LP Forecasts
lp_m    =   zeros(vars, nreps);
lp_b    =   zeros(vars, nreps);
lp_s    =   zeros(vars, nreps);
lp_c    =   zeros(vars, nreps);
lp_wm   =   zeros(vars, nreps);
lp_wb   =   zeros(vars, nreps);
lp_ws   =   zeros(vars, nreps);
lp_wc   =   zeros(vars, nreps);
//For LPs Forecasts analytic
lp1_m    =   zeros(vars, nreps);
lp1_b    =   zeros(vars, nreps);
lp1_s    =   zeros(vars, nreps);
lp1_c    =   zeros(vars, nreps);
lp1_wm   =   zeros(vars, nreps);
lp1_wb   =   zeros(vars, nreps);
lp1_ws   =   zeros(vars, nreps);
lp1_wc   =   zeros(vars, nreps);


k = 1;
// The line below can be useful to check
//betmc = zeros(vars*(1+vars*psw),nreps);

do while k le nreps;
//Initialize the sample with the actual data
x = reshape(z[psw:1,.],1,psw*vars);
y = zeros(sample,vars);
{u, state} = rndKMn(sample,vars,state);
y[1,.] = (1~x)*beta + u[1,.]*chol(sig_u_sw);

    i = 2;
    do while i le sample;
        x = y[i-1,.]~x[.,1:vars*(psw-1)];
        y[i,.] = (1~x)*beta + u[i,.]*chol(sig_u_sw);
        i = i+1;
    endo;

// Choose lag length with Info criterion
{aicc, aic, sic, p} = lagcrit(y, plg, maxp, infoc);

// Obtain VAR OLS estimates
{betv, sig_u_v, sig_a_v} = varols(y, p,1);

// Forecast based on obs X_Tp
X_Tp = 1~reshape(z[T:T-p,.],1,p*vars);

// FEV from VAR
{y_H_v, Xi_H_v, sig_H_v} = varfcst(betv, p, vars, sig_u_v, hmax, sig_a_v, X_Tp', sample);

// Obtain LP estimates
{sig_lp, sig_H_lp, betlp} = proj(y, hmax, p);

// LP estimates with analytic VCV 
{sig_lp1, sig_H_lp1} = pirf(y, p, hmax);

// Forecast error variance from projections (sig_H_LP)
Xi_H_LP = (X_Tp.*.eye(vars*hmax))*sig_lp*(X_Tp'.*.eye(vars*hmax)); 
Xi_H_LP = Xi_H_LP + sig_H_lp;

// Forecast error variance from projections (sig_H_LP1)
Xi_H_LP1 = (X_Tp.*.eye(vars*hmax))*sig_lp1*(X_Tp'.*.eye(vars*hmax)); 
Xi_H_LP1 = Xi_H_LP1 + sig_H_lp1; 

//Coverage of the different methods
{var_m[.,k],var_b[.,k],var_s[.,k],var_c[.,k],var_wm[.,k],var_wb[.,k],var_ws[.,k],var_wc[.,k]} = evalc(yf, vars, hmax, xi_H_v);
{lp_m[.,k],lp_b[.,k],lp_s[.,k],lp_c[.,k],lp_wm[.,k],lp_wb[.,k],lp_ws[.,k],lp_wc[.,k]} = evalc(yf, vars, hmax, xi_H_lp);
{lp1_m[.,k],lp1_b[.,k],lp1_s[.,k],lp1_c[.,k],lp1_wm[.,k],lp1_wb[.,k],lp1_ws[.,k],lp1_wc[.,k]} = evalc(yf, vars, hmax, xi_H_lp1);



//betmc[.,k] = vec(betv);
k = k+1;
endo;

//reshape(meanc(betmc'),vars, vars*psw+1)'; //useful trick


"===========================================================";
"       SIMULATION SET_UP                                   ";
"===========================================================";
"Forecast Horizon:      ";; hmax;
"Forecast Replications: ";; freps;
"MC Replications:       ";; nreps;
"Sample Size:           ";; sample;
"-----------------------------------------------------------";
"PROBABILITY COVERAGE OF VAR BASED BANDS";
"-----------------------------------------------------------";
"Nominal Level"$~"Marginal"$~"Bonferroni"$~"Scheffe"@$~"Conditional"@;
(1-alpha)*ones(vars,1)~meanc(var_m')~meanc(var_b')~meanc(var_s')@~meanc(var_c')@;
"-----------------------------------------------------------";
"PROBABILITY COVERAGE OF VAR BASED BANDS - WALD DISTANCE";
"-----------------------------------------------------------";
"Nominal Level"$~"Marginal"$~"Bonferroni"$~"Scheffe"@$~"Conditional"@;
(1-alpha)*ones(vars,1)~meanc(var_wm')~meanc(var_wb')~meanc(var_ws')@~meanc(var_wc')@;
"-----------------------------------------------------------";
"PROBABILITY COVERAGE OF LP BASED BANDS";
"-----------------------------------------------------------";
"Nominal Level"$~"Marginal"$~"Bonferroni"$~"Scheffe"@$~"Conditional"@;
(1-alpha)*ones(vars,1)~meanc(lp_m')~meanc(lp_b')~meanc(lp_s')@~meanc(lp_c')@;
"-----------------------------------------------------------";
"PROBABILITY COVERAGE OF LP BASED BANDS - WALD DISTANCE";
"-----------------------------------------------------------";
"Nominal Level"$~"Marginal"$~"Bonferroni"$~"Scheffe"@$~"Conditional"@;
(1-alpha)*ones(vars,1)~meanc(lp_wm')~meanc(lp_wb')~meanc(lp_ws')@~meanc(lp_wc')@;
"-----------------------------------------------------------";
"PROBABILITY COVERAGE OF ANALYTIC LP BASED BANDS";
"-----------------------------------------------------------";
"Nominal Level"$~"Marginal"$~"Bonferroni"$~"Scheffe"@$~"Conditional"@;
(1-alpha)*ones(vars,1)~meanc(lp1_m')~meanc(lp1_b')~meanc(lp1_s')@~meanc(lp1_c')@;
"-----------------------------------------------------------";
"PROBABILITY COVERAGE OF ANALYTIC LP BASED BANDS - WALD DISTANCE";
"-----------------------------------------------------------";
"Nominal Level"$~"Marginal"$~"Bonferroni"$~"Scheffe"@$~"Conditional"@;
(1-alpha)*ones(vars,1)~meanc(lp1_wm')~meanc(lp1_wb')~meanc(lp1_ws')@~meanc(lp1_wc')@;


else;
// This section does graphs for the Stock-Watson VAR


y_H_sw = reshape(y_H_sw, hmax, vars);
y_H_LP_sw = reshape(y_H_LP_sw, hmax, vars);

zf = z[T-pres+1:T+hmax,.];
saux = eye(vars);
mbp_sw = zeros(hmax, vars);
mbn_sw = zeros(hmax, vars);
sbp_sw = zeros(hmax, vars);
sbn_sw = zeros(hmax, vars);
bbp_sw = zeros(hmax, vars);
bbn_sw = zeros(hmax, vars);

j = 1;
do while j le vars;

    s = eye(hmax).*.saux[j,.];
    xi_sw = s*xi_H_sw*s';
    {mbp_sw[.,j], mbn_sw[.,j]} = marband(y_H_sw[.,j], xi_sw, 0.05);
    {sbp_sw[.,j], sbn_sw[.,j]} = scheffe(y_H_sw[.,j], xi_sw, 0.05);
    {bbp_sw[.,j], bbn_sw[.,j]} = bonfband(y_H_sw[.,j], xi_sw, 0.05);
  
   j = j+1;
endo;
y_H_sw = z[T-pres+1:T,.]|y_H_sw;
y_H_LP_sw = z[T-pres+1:T,.]|y_H_LP_sw;

mbp_sw = z[T-pres+1:T,.]|mbp_sw;
mbn_sw = z[T-pres+1:T,.]|mbn_sw;
sbp_sw = z[T-pres+1:T,.]|sbp_sw;
sbn_sw = z[T-pres+1:T,.]|sbn_sw;
bbp_sw = z[T-pres+1:T,.]|bbp_sw;
bbn_sw = z[T-pres+1:T,.]|bbn_sw;


begwind;
window(1,3,0);

setwind(1);
//title("Probability: "$+ftocv(1-alpha[1],3,2));
title(sers[1]);
xlabel("Horizon");
_pltype = {1,2,2,4,4,3,3,6};
_pcolor = {10,7,7,3,3,12,12,1};
_plwidth = 8;
_pnumht = 0.18;
_ptitlht = 0.25;
xy(seqa(-1,1,hmax+pres), y_H_sw[.,1]~mbp_sw[.,1]~mbn_sw[.,1]~sbp_sw[.,1]~sbn_sw[.,1]~bbp_sw[.,1]~bbn_sw[.,1]~zf[.,1]);
s = 2;
do while s le vars;
    nextwind;
    //title("Probability: "$+ftocv(1-alpha[s],3,2));
    title(sers[s]);
    xlabel("Horizon");
    xy(seqa(-1,1,hmax+pres), y_H_sw[.,s]~mbp_sw[.,s]~mbn_sw[.,s]~sbp_sw[.,s]~sbn_sw[.,s]~bbp_sw[.,s]~bbn_sw[.,s]~zf[.,s]);
    s = s+1;
endo;

endwind;
endif;


/*******************************************************
Libraries
********************************************************/
#include jae_mc.src;
library pgraph;
graphset;
