# Code for "International Spillovers of Forward Guidance Shocks"

by Callum Jones, Mariano Kulish and Daniel M. Rees

Last updated on 24-June-2021.

The paper is available [here](https://callumjones.github.io/files/OpenFG.pdf).

## Software Requirements

- The code is written in Matlab and R.
- The [Dynare](https://www.dynare.org/) package is used to extract the structural equations of the linearized model. The scripts work with version 4.6.0 of Dynare.
- Some figures rely on the use of [Ambrogio Cesa-Bianchi's VAR Toolbox](https://github.com/ambropo/VAR-Toolbox), included in the `/routines` folder.

## Estimation

The estimation is conducted by running the script `run_mcmc` in the `/Matlab` folder. The output of the estimation -- the posterior draws of the parameters and lower bound durations -- are stored in the `output` subfolder. File size considerations preclude us from uploading the full estimated posterior distributions. A short draw of the posterior distribution is included in the `output` subfolder under the file `mhall-05-Mar-2020_estimatechis.mat`, which can be used to draw the figures in the paper. A full replication requires an estimation with two independent chains of length 500,000.

## Figures

The figures generated using the estimated model are reproduced by running the following files from the `/Matlab` folder.

| Figure    | Matlab Script to Run   |
|---------- | ---------------------- |
| Figure 3  | `prior_post_scatter`   |
| Figure 4  | `prior_post_scatter`   |
| Figure 5  | `fg_decomposition`     |
| Figure 6  | `fg_decomposition`     |
| Figure 7  | `girf`                 |
| Figure 8  | `state_dep_spillovers` |
| Figure 9  | `fg_decomposition`     |
| Figure 10 | `fg_decomposition`     |

## Tables

Table 1 to 3 are generated by running `generate_tables` from the `/Matlab` folder. The tables print to the Matlab command window.

### Event Study Table 4

In the folder `/Event_study`, the file `Event_study.R` reproduces the results in Table 4 of the paper.

- The coefficient estimates and t-stats are printed and available in the data frames with names corresponding to “variable name.estimates”

The file calls two sets of data:

- `Event_study_data.RData`: data for the dependent variables
- `FG_Shocks.xlsx`: Data for the forward guidance shocks.

The file `Event_study_Canadian_data.R` reproduces the data downloads for the dependent variables. All data is sourced from Canstat and FRED.

The file `FG_Shocks.xlsx` contains the series of forward guidance shocks. These are the “Path” shocks in the replication files of Bundick and Smith, “The Dynamic Effects of Forward Guidance Shocks” available at [https://dataverse.harvard.edu/dataset.xhtml?persistentId=doi:10.7910/DVN/EH3JBW](https://dataverse.harvard.edu/dataset.xhtml?persistentId=doi:10.7910/DVN/EH3JBW).
