library("quadprog")
for (version in 1:3) {
  alpha=0.05
  for(loop in 1:1000)
  {
    B =5000
    beta=alpha/10
    epsilon=0.012
    u=0.001
    
    K<-10

US_safety<-1/100*c(2.5,0.0,5.0,0.0,5.0,2.5,2.5,22.5,37.5)
US_skill<-1/100*c(0.0,2.4,2.4,2.4,0.0,12.2,22.0,12.2,26.8)

k<-c(1:K)
data<-US_safety
n<-40   #N=40, 41
cumudata<-cumsum(data)

upper<-2/K*k
lower<-1-2/K*k
uplow<-cbind(upper[K],lower[-K])
##########################################
# data
answer<-matrix(0,n,K-1)
length1=round(cumudata*n)
for(p in 1:(K-1))
{ if(length1[p]!=0)
  answer[c(1:length1[p]),p]<-1       # answers: filled with 1 and 0
}
answerdata<-cbind(answer,-answer)
wMat<-answerdata-matrix(rep(uplow,n),n,2*(K-1),byrow=T)

#wMat<-wMat[,c(2*(K-1)-3,2*(K-1)-2,2*(K-1)-1,2*(K-1))] # top 4 only
wMat<-wMat[,c(1:4,2*(K-1)-3,2*(K-1)-2,2*(K-1)-1,2*(K-1))] # 1-4 and 6-9 / 2-4 and 6-9
kk<-ncol(wMat)    # 3 columns

Sigma = var(wMat)
sd = sqrt(diag(Sigma))
wMeans = apply(wMat, 2, mean)

#############################################
Sadjusted<-function(w, version)
{
  testSigma = var(w)
  Svariance<-diag(testSigma)
  ss<-pmax(u-sqrt(Svariance),0)+sqrt(Svariance)
  testwMeans = apply(w, 2, mean)
  diag(testSigma)<-ss^2
  if (1 == version) {
    wMean.j.greater.zero = testwMeans > 0
    s = n * sum(((testwMeans/ss)^2)* wMean.j.greater.zero)
  }
  else if (2 == version) {
    diag(testSigma)<-ss^2
    DD<-matrix(diag(ss^2),kk,kk)
    DDsqrt<-matrix(diag(ss^(-1)),kk,kk)
    
    Omega<-DDsqrt%*%testSigma%*%DDsqrt
    Sigmaadjusted<-pmax(epsilon-det(Omega),0)*DD+testSigma
    SigmaInv = solve(Sigmaadjusted)
    
    m = sqrt(n) * testwMeans
    dvec = m %*% SigmaInv
    Amat = diag(rep(-1, kk))
    qp.sol = solve.QP(SigmaInv, dvec, Amat)
    s = as.numeric(2 * qp.sol$val + m %*% SigmaInv %*% m)
  }
  else if (3 == version) {
    s = sqrt(n) * max(testwMeans/ss)
  }
  else 
    stop("the argument `version' must equal 1, 2 or 3")
  s
}

####################################

# compute centered bootstrap test statistics
s.boot = rep(1, B)
centerVec = -wMeans
centerMat = matrix(rep(centerVec,n),ncol =kk,byrow = T)
for (b in (1:B)) {
  set.seed(b)
  boot<-sample(1:n, n, T)
  wMat.boot.center = wMat[boot,] + centerMat
  s.boot[b] = Sadjusted(wMat.boot.center, version)
}

# compute critical value of two-step test
crit.val = as.numeric(quantile(s.boot,1-alpha))

# compute test statistic and decision of two-step test
s = Sadjusted(wMat, version)
reject = 0
if (s > crit.val)
  reject = 1
if(loop==1) {
  testreject=reject
  teststatistics=s
  testcrit.val=crit.val
  # alpha<-0.8
}
if(testreject==0) {
  #alpha<-alpha+0.01 
  alpha<-alpha+0.001
  if(reject==1) break}

if(testreject==1) {
  alpha<-alpha-0.001
  if(reject==0) break}
  }
  pvalue=alpha
  cat("version", "reject"," ", "statistics"," ","crit.val","pvalue","\n",
      "   ",version,"    ",testreject, "   ",teststatistics, " ",testcrit.val," ",pvalue,"\n")
}



