library("quadprog")
for (version in 1:3) {
alpha=0.05
for(loop in 1:1000)
{
B =5000
beta=alpha/10
epsilon=0.012
u=0.001

K<-10

US_safety<-1/100*c(2.5,0.0,5.0,0.0,5.0,2.5,2.5,22.5,37.5)
US_skill<-1/100*c(0.0,2.4,2.4,2.4,0.0,12.2,22.0,12.2,26.8)
SW_safety<-1/100*c(0.0,5.7,0.0,14.3,2.9,11.4,14.3,28.6,17.1)
SW_skill<-1/100*c(2.2,6.7,2.2,4.4,15.5,17.7,11.1,24.4,13.3)

k<-c(1:K)
data<-US_safety
n<-40   #N=40, 41, 35, 45
cumudata<-cumsum(data)

upper<-2/K*k
lower<-1-2/K*k
uplow<-cbind(upper[K],lower[-K])
##########################################
# data
answer<-matrix(0,n,K-1)
length1=round(cumudata*n)
for(p in 1:(K-1))
{ if(length1[p]!=0)
  answer[c(1:length1[p]),p]<-1       # answers: filled with 1 and 0
}
answerdata<-cbind(answer,-answer)
wMat<-answerdata-matrix(rep(uplow,n),n,2*(K-1),byrow=T)

wMat<-wMat[,c(1:4,2*(K-1)-3,2*(K-1)-2,2*(K-1)-1,2*(K-1))] # 1-4 and 6-9  / 2-4 and 6-9
kk<-ncol(wMat)    # 3 columns

Sigma = var(wMat)
sd = sqrt(diag(Sigma))
wMeans = apply(wMat, 2, mean)
#############################################
Sadjusted<-function(w, version)
{
  testSigma = var(w)
  Svariance<-diag(testSigma)
  ss<-pmax(u-sqrt(Svariance),0)+sqrt(Svariance)
  testwMeans = apply(w, 2, mean)
  diag(testSigma)<-ss^2
  if (1 == version) {
    wMean.j.greater.zero = testwMeans > 0
    s = n * sum(((testwMeans/ss)^2)* wMean.j.greater.zero)
  }
  else if (2 == version) {
    diag(testSigma)<-ss^2
    DD<-matrix(diag(ss^2),kk,kk)
    DDsqrt<-matrix(diag(ss^(-1)),kk,kk)
    
    Omega<-DDsqrt%*%testSigma%*%DDsqrt
    Sigmaadjusted<-pmax(epsilon-det(Omega),0)*DD+testSigma
    SigmaInv = solve(Sigmaadjusted)
    
    m = sqrt(n) * testwMeans
    dvec = m %*% SigmaInv
    Amat = diag(rep(-1, kk))
    qp.sol = solve.QP(SigmaInv, dvec, Amat)
    s = as.numeric(2 * qp.sol$val + m %*% SigmaInv %*% m)
  }
  else if (3 == version) {
    s = sqrt(n) * max(testwMeans/ss)
  }
  else 
    stop("the argument `version' must equal 1, 2 or 3")
  s
}

####################################
#two-step test

if (alpha - beta < 0.0001)
  stop("alpha - beta < 0.0001")

root.n = sqrt(n)
# compute multiplier d of first-step confidence region
max.boot = rep(1, B)
for (b in (1:B)) {
  set.seed(b+3)
  boot<-sample(1:n, n, T)
  wMat.boot = wMat[boot, ]
  Svariance.boot<-diag(var(wMat.boot))
  ss.boot<-pmax(u-sqrt(Svariance.boot),0)+sqrt(Svariance.boot)
  #ss.boot<-sqrt(Svariance.boot)
  t.boot = root.n*((apply(wMat.boot,2,mean)-
                      wMeans)/ss.boot)
  max.boot[b] = max(t.boot)
}
d = quantile(max.boot,1-beta)
# print(d)

# intersect resulting confidence region with third quadrant to get "null vector"
mu.null=pmin(rep(0,kk),wMeans+d*sd/root.n)

# compute centered bootstrap test statistics
s.boot = rep(1, B)
centerVec = -wMeans + mu.null
centerMat = matrix(rep(centerVec,n),ncol =kk,byrow = T)
for (b in (1:B)) {
  set.seed(b)
  boot<-sample(1:n, n, T)
  wMat.boot.center = wMat[boot,] + centerMat
  s.boot[b] = Sadjusted(wMat.boot.center, version)
}

# compute critical value of two-step test
crit.val = as.numeric(quantile(s.boot,1-alpha+beta))

# compute test statistic and decision of two-step test
s = Sadjusted(wMat, version)
reject = 0
if (s >= crit.val)
  reject = 1
if(loop==1) {
  testreject=reject
  teststatistics=s
  testcrit.val=crit.val
  testmu.null=mu.null
  # alpha<-0.8  #
}
if(testreject==0) {
  if(alpha<=1)
  #alpha<-alpha+0.01 
  alpha<-alpha+0.001
  else break
  if(reject==1) break}

if(testreject==1) {
  alpha<-alpha-0.001
  if(reject==0) break}
}
pvalue=alpha
cat("version", "reject"," ", "statistics"," ","crit.val","pvalue","mu.null","\n",
    "   ",version,"    ",testreject, "   ",teststatistics, " ",testcrit.val," ",pvalue," ",testmu.null,"\n")
}