library("quadprog")
library(readxl)
dtexpm2 <- read_excel("expm2.xlsx")
dt2<-as.matrix(dtexpm2[-76,c(1:19)])
#Median is 18.
actual<-read_excel("expm2actual.xlsx")
act<-as.matrix(actual[-76,c(1:19)])

for (version in 1:3) {
  alpha=0.05
  for(loop in 1:1000)
  {
    B =5000
    beta=alpha/10
    epsilon=0.012
    u=0.001
    
    kk<-19
    n<-74
    q<-c(1,0.98,0.96,0.94,0.92,0.90,0.88,0.86,0.84,0.80, 
         0.78,0.76,0.74,0.72,0.70,0.68,0.66,0.60,0.58)
    ##########################################
    wMat<-sweep(dt2,MARGIN=2,q,`*`) - act
    
    Sigma = var(wMat)
    sd = sqrt(diag(Sigma))
    wMeans = apply(wMat, 2, mean)
    #############################################
    Sadjusted<-function(w, version)
    {
      testSigma = var(w)
      Svariance<-diag(testSigma)
      ss<-pmax(u-sqrt(Svariance),0)+sqrt(Svariance)
      testwMeans = apply(w, 2, mean)
      diag(testSigma)<-ss^2
      if (1 == version) {
        wMean.j.greater.zero = testwMeans > 0
        s = n * sum(((testwMeans/ss)^2)* wMean.j.greater.zero)
      }
      else if (2 == version) {
        diag(testSigma)<-ss^2
        DD<-matrix(diag(ss^2),kk,kk)
        DDsqrt<-matrix(diag(ss^(-1)),kk,kk)
        
        Omega<-DDsqrt%*%testSigma%*%DDsqrt
        Sigmaadjusted<-pmax(epsilon-det(Omega),0)*DD+testSigma
        SigmaInv = solve(Sigmaadjusted)
        
        m = sqrt(n) * testwMeans
        dvec = m %*% SigmaInv
        Amat = diag(rep(-1, kk))
        qp.sol = solve.QP(SigmaInv, dvec, Amat)
        s = as.numeric(2 * qp.sol$val + m %*% SigmaInv %*% m)
      }
      else if (3 == version) {
        s = sqrt(n) * max(testwMeans/ss)
      }
      else 
        stop("the argument `version' must equal 1, 2 or 3")
      s
    }
    
    ####################################
    #two-step test
    
    if (alpha - beta < 0.0001)
      stop("alpha - beta < 0.0001")
    
    root.n = sqrt(n)
    # compute multiplier d of first-step confidence region
    max.boot = rep(1, B)
    for (b in (1:B)) {
      set.seed(b+3)
      boot<-sample(1:n, n, T)
      wMat.boot = wMat[boot, ]
      Svariance.boot<-diag(var(wMat.boot))
      ss.boot<-pmax(u-sqrt(Svariance.boot),0)+sqrt(Svariance.boot)
      #ss.boot<-sqrt(Svariance.boot)
      t.boot = root.n*((apply(wMat.boot,2,mean)-
                          wMeans)/ss.boot)
      max.boot[b] = max(t.boot)
    }
    d = quantile(max.boot,1-beta)
    # print(d)
    
    # intersect resulting confidence region with third quadrant to get "null vector"
    mu.null=pmin(rep(0,kk),wMeans+d*sd/root.n)
    
    # compute centered bootstrap test statistics
    s.boot = rep(1, B)
    centerVec = -wMeans + mu.null
    centerMat = matrix(rep(centerVec,n),ncol =kk,byrow = T)
    for (b in (1:B)) {
      set.seed(b)
      boot<-sample(1:n, n, T)
      wMat.boot.center = wMat[boot,] + centerMat
      s.boot[b] = Sadjusted(wMat.boot.center, version)
    }
    
    # compute critical value of two-step test
    crit.val = as.numeric(quantile(s.boot,1-alpha+beta))
    
    # compute test statistic and decision of two-step test
    s = Sadjusted(wMat, version)
    reject = 0
    if (s >= crit.val)
      reject = 1
    if(loop==1) {
      testreject=reject
      teststatistics=s
      testcrit.val=crit.val
      testmu.null=mu.null
      # alpha<-0.8  #
    }
    if(testreject==0) {
      if(alpha<=1)
        #alpha<-alpha+0.01 
        alpha<-alpha+0.001
      else break
      if(reject==1) break}
    
    if(testreject==1) {
      alpha<-alpha-0.001
      if(reject==0) break}
  }
  pvalue=alpha
  cat("version", "reject"," ", "statistics"," ","crit.val","pvalue","mu.null","\n",
      "   ",version,"    ",testreject, "   ",teststatistics, " ",testcrit.val," ",pvalue," ",testmu.null,"\n")
}
