#-------- Compute finite-sample size and power of HTZ test using Asymptotic Distribution --------#
#-------- The Benchmark Case with GARCH error term following Normal Distribution --------#
## Author: Ke Wu
## Last Update: 05/2018

rm(list=ls())
setwd('.../code_sum')
#----------------------------------- source code --------------------------------------
source("FuncLib/exceed_correl.R")
#--------------------------------------------------------------------------------------


#------------- Read in simulated data -------------#
load("simulation/simDGPs/simCopGarch3600norm.RData", .GlobalEnv) 


#------------- Simulation, T=240, No. sim=1000 -------------#
N <- 1000

sim1.25clnr.pval <- rep(NA, N)
sim1.375clnr.pval <- rep(NA, N)
sim1.50clnr.pval <- rep(NA, N)
sim1.75clnr.pval <- rep(NA, N)
sim1nr.pval <- rep(NA, N)
sim1cl.pval <- rep(NA, N)

#- Compute pvalues
for(i in 1:1000){
  sim1.25clnr.pval[i] <- exceed_correl(simgarch.sz5.25clnr[1:240, i], simgarch.mkt.25clnr[1:240, i],
                                          qc=c(0))[2]
}


for(i in 1:1000){
  sim1.375clnr.pval[i] <- exceed_correl(simgarch.sz5.375clnr[1:240, i], simgarch.mkt.375clnr[1:240, i],
                                           qc=c(0))[2]
}


for(i in 1:1000){
  sim1.50clnr.pval[i] <- exceed_correl(simgarch.sz5.50clnr[1:240, i], simgarch.mkt.50clnr[1:240, i],
                                          qc=c(0))[2]
}

for(i in 1:1000){
  sim1.75clnr.pval[i] <- exceed_correl(simgarch.sz5.75clnr[1:240, i], simgarch.mkt.75clnr[1:240, i],
                                        qc=c(0))[2]
}

for(i in 1:1000){
  sim1nr.pval[i] <- exceed_correl(simgarch.sz5.nr[1:240, i], simgarch.mkt.nr[1:240, i],
                                     qc=c(0))[2]
}


for(i in 1:1000){
  sim1cl.pval[i] <- exceed_correl(simgarch.sz5.cl[1:240, i], simgarch.mkt.cl[1:240, i],
                                     qc=c(0))[2]
}

power1htz.25clnr <- mean(ifelse(sim1.25clnr.pval <= .05, 1, 0))
power1htz.375clnr <- mean(ifelse(sim1.375clnr.pval <= .05, 1, 0))
power1htz.50clnr <- mean(ifelse(sim1.50clnr.pval <= .05, 1, 0))
power1htz.75clnr <- mean(ifelse(sim1.75clnr.pval <= .05, 1, 0))
power1htz.cl <- mean(ifelse(sim1cl.pval <= .05, 1, 0))
size1htz.nr <- mean(ifelse(sim1nr.pval <= .05, 1, 0))


#------------- Simulation, T=420, No. sim=1000 -------------#
N <- 1000


sim2.25clnr.pval <- rep(NA, N)
sim2.375clnr.pval <- rep(NA, N)
sim2.50clnr.pval <- rep(NA, N)
sim2.75clnr.pval <- rep(NA, N)
sim2nr.pval <- rep(NA, N)
sim2cl.pval <- rep(NA, N)

#- Compute pvalues
for(i in 1:1000){
  sim2.25clnr.pval[i] <- exceed_correl(simgarch.sz5.25clnr[1:420, i], simgarch.mkt.25clnr[1:420, i],
                                          qc=c(0))[2]
}


for(i in 1:1000){
  sim2.375clnr.pval[i] <- exceed_correl(simgarch.sz5.375clnr[1:420, i], simgarch.mkt.375clnr[1:420, i],
                                           qc=c(0))[2]
}


for(i in 1:1000){
  sim2.50clnr.pval[i] <- exceed_correl(simgarch.sz5.50clnr[1:420, i], simgarch.mkt.50clnr[1:420, i],
                                          qc=c(0))[2]
}

for(i in 1:1000){
  sim2.75clnr.pval[i] <- exceed_correl(simgarch.sz5.75clnr[1:420, i], simgarch.mkt.75clnr[1:420, i],
                                        qc=c(0))[2]
}

for(i in 1:1000){
  sim2nr.pval[i] <- exceed_correl(simgarch.sz5.nr[1:420, i], simgarch.mkt.nr[1:420, i],
                                     qc=c(0))[2]
}


for(i in 1:1000){
  sim2cl.pval[i] <- exceed_correl(simgarch.sz5.cl[1:420, i], simgarch.mkt.cl[1:420, i],
                                     qc=c(0))[2]
}

power2htz.25clnr <- mean(ifelse(sim2.25clnr.pval <= .05, 1, 0))
power2htz.375clnr <- mean(ifelse(sim2.375clnr.pval <= .05, 1, 0))
power2htz.50clnr <- mean(ifelse(sim2.50clnr.pval <= .05, 1, 0))
power2htz.75clnr <- mean(ifelse(sim2.75clnr.pval <= .05, 1, 0))
power2htz.cl <- mean(ifelse(sim2cl.pval <= .05, 1, 0))
size2htz.nr <- mean(ifelse(sim2nr.pval <= .05, 1, 0))



#------------- Simulation, T=600, No. sim=1000 -------------#
N <- 1000

sim3.25clnr.pval <- rep(NA, N)
sim3.375clnr.pval <- rep(NA, N)
sim3.50clnr.pval <- rep(NA, N)
sim3.75clnr.pval <- rep(NA, N)
sim3nr.pval <- rep(NA, N)
sim3cl.pval <- rep(NA, N)

#- Compute pvalues
for(i in 1:1000){
  sim3.25clnr.pval[i] <- exceed_correl(simgarch.sz5.25clnr[1:600, i], simgarch.mkt.25clnr[1:600, i],
                                          qc=c(0))[2]
}


for(i in 1:1000){
  sim3.375clnr.pval[i] <- exceed_correl(simgarch.sz5.375clnr[1:600, i], simgarch.mkt.375clnr[1:600, i],
                                           qc=c(0))[2]
}


for(i in 1:1000){
  sim3.50clnr.pval[i] <- exceed_correl(simgarch.sz5.50clnr[1:600, i], simgarch.mkt.50clnr[1:600, i],
                                          qc=c(0))[2]
}

for(i in 1:1000){
  sim3.75clnr.pval[i] <- exceed_correl(simgarch.sz5.75clnr[1:600, i], simgarch.mkt.75clnr[1:600, i],
                                        qc=c(0))[2]
}

for(i in 1:1000){
  sim3nr.pval[i] <- exceed_correl(simgarch.sz5.nr[1:600, i], simgarch.mkt.nr[1:600, i],
                                     qc=c(0))[2]
}


for(i in 1:1000){
  sim3cl.pval[i] <- exceed_correl(simgarch.sz5.cl[1:600, i], simgarch.mkt.cl[1:600, i],
                                     qc=c(0))[2]
}

power3htz.25clnr <- mean(ifelse(sim3.25clnr.pval <= .05, 1, 0))
power3htz.375clnr <- mean(ifelse(sim3.375clnr.pval <= .05, 1, 0))
power3htz.50clnr <- mean(ifelse(sim3.50clnr.pval <= .05, 1, 0))
power3htz.75clnr <- mean(ifelse(sim3.75clnr.pval <= .05, 1, 0))
power3htz.cl <- mean(ifelse(sim3cl.pval <= .05, 1, 0))
size3htz.nr <- mean(ifelse(sim3nr.pval <= .05, 1, 0))



#------------- Simulation, T=1200, No. sim=1000 -------------#
N <- 1000


sim4.25clnr.pval <- rep(NA, N)
sim4.375clnr.pval <- rep(NA, N)
sim4.50clnr.pval <- rep(NA, N)
sim4.75clnr.pval <- rep(NA, N)
sim4nr.pval <- rep(NA, N)
sim4cl.pval <- rep(NA, N)

#- Compute pvalues
for(i in 1:1000){
  sim4.25clnr.pval[i] <- exceed_correl(simgarch.sz5.25clnr[1:1200, i], simgarch.mkt.25clnr[1:1200, i],
                                          qc=c(0))[2]
}


for(i in 1:1000){
  sim4.375clnr.pval[i] <- exceed_correl(simgarch.sz5.375clnr[1:1200, i], simgarch.mkt.375clnr[1:1200, i],
                                           qc=c(0))[2]
}


for(i in 1:1000){
  sim4.50clnr.pval[i] <- exceed_correl(simgarch.sz5.50clnr[1:1200, i], simgarch.mkt.50clnr[1:1200, i],
                                          qc=c(0))[2]
}

for(i in 1:1000){
  sim4.75clnr.pval[i] <- exceed_correl(simgarch.sz5.75clnr[1:1200, i], simgarch.mkt.75clnr[1:1200, i],
                                       qc=c(0))[2]
}

for(i in 1:1000){
  sim4nr.pval[i] <- exceed_correl(simgarch.sz5.nr[1:1200, i], simgarch.mkt.nr[1:1200, i],
                                     qc=c(0))[2]
}


for(i in 1:1000){
  sim4cl.pval[i] <- exceed_correl(simgarch.sz5.cl[1:1200, i], simgarch.mkt.cl[1:1200, i],
                                     qc=c(0))[2]
}


power4htz.25clnr <- mean(ifelse(sim4.25clnr.pval <= .05, 1, 0))
power4htz.375clnr <- mean(ifelse(sim4.375clnr.pval <= .05, 1, 0))
power4htz.50clnr <- mean(ifelse(sim4.50clnr.pval <= .05, 1, 0))
power4htz.75clnr <- mean(ifelse(sim4.75clnr.pval <= .05, 1, 0))
power4htz.cl <- mean(ifelse(sim4cl.pval <= .05, 1, 0))
size4htz.nr <- mean(ifelse(sim4nr.pval <= .05, 1, 0))

save(sim1.25clnr.pval, sim1.375clnr.pval, sim1.50clnr.pval, sim1.75clnr.pval, sim1nr.pval, sim1cl.pval, 
     sim2.25clnr.pval, sim2.375clnr.pval, sim2.50clnr.pval, sim2.75clnr.pval, sim2nr.pval, sim2cl.pval, 
     sim3.25clnr.pval, sim3.375clnr.pval, sim3.50clnr.pval, sim3.75clnr.pval, sim3nr.pval, sim3cl.pval, 
     sim4.25clnr.pval, sim4.375clnr.pval, sim4.50clnr.pval, sim4.75clnr.pval, sim4nr.pval, sim4cl.pval, 
     file="simulation/comp_pvals/htz_asymptpvals.RData")






