## Test asymmetric dependence with US data
## Author: J.Pan
## Last Update: 05/2018
rm(list=ls())

library(np)
library(foreign)
library(boot)

#----------------------------------- source code --------------------------------------
setwd('.../code_sum')

source("FuncLib/console.R")

source("FuncLib/KLdiv.R")
source("FuncLib/npcdepKL.R")

source("FuncLib/exceed_cor.R")
source("FuncLib/exceed_corSBpiv.R")

console <<- newLineConsole()
console <<- printClear(console)  

#----------------------------------- Read Data --------------------------------------
# ALL US PORTFOLIOS
US <- read.dta("Data/US/US.dta")
attach(US)

US.sz.kl <- rep(NA,10)
US.sz.rho <- matrix(data=NA,nrow=10,ncol=2)
US.sz.htz <- rep(NA,10)

sz = cbind(sz1,sz2,sz3,sz4,sz5,sz6,sz7,sz8,sz9,sz10)

US.bm.kl <- rep(NA,10)
US.bm.rho <- matrix(data=NA,nrow=10,ncol=2)
US.bm.htz <- rep(NA,10)

bm = cbind(bm1,bm2,bm3,bm4,bm5,bm6,bm7,bm8,bm9,bm10)

US.mom.kl <- rep(NA,10)
US.mom.rho <- matrix(data=NA,nrow=10,ncol=2)
US.mom.htz <- rep(NA,10)

mom = cbind(mom1,mom2,mom3,mom4,mom5,mom6,mom7,mom8,mom9,mom10)

for (i in 1:10) {
  # value-wtd size
  US.sz.rho[i,] <- npcdepKL(data.x = rmrf,data.y = sz[,i], C=0, method="MI", bootstrap=F, boot.num=399, idx=i, boot.method="geom")
  US.sz.kl[i] <- npcdepKL(data.x = rmrf,data.y = sz[,i], C=0, method="MI", bootstrap=T, boot.num=399, idx=i, boot.method="geom")
  US.sz.htz[i] <- exceed_corSBpiv(X = rmrf,Y = sz[,i],qc=0,boot.num=399,idx=i)[[3]]
  
  # value-wtd bm
  US.bm.rho[i,] <- npcdepKL(data.x = rmrf,data.y = bm[,i], C=0, method="MI", bootstrap=F, boot.num=399, idx=i, boot.method="geom")
  US.bm.kl[i] <- npcdepKL(data.x = rmrf,data.y = bm[,i], C=0, method="MI", bootstrap=T, boot.num=399, idx=i, boot.method="geom")
  US.bm.htz[i] <- exceed_corSBpiv(X = rmrf,Y = bm[,i],qc=0,boot.num=399,idx=i)[[3]]
  
  # equal-wtd mom
  US.mom.rho[i,] <- npcdepKL(data.x = rmrf,data.y = mom[,i], C=0, method="MI", bootstrap=F, boot.num=399, idx=i, boot.method="geom")
  US.mom.kl[i] <- npcdepKL(data.x = rmrf,data.y = mom[,i], C=0, method="MI", bootstrap=T, boot.num=399, idx=i, boot.method="geom")
  US.mom.htz[i] <- exceed_corSBpiv(X = rmrf,Y = mom[,i],qc=0,boot.num=399,idx=i)[[3]]
}

save(US.sz.rho,US.sz.kl,US.sz.htz, US.bm.rho,US.bm.kl,US.bm.htz, US.mom.rho,US.mom.kl,US.mom.htz,
     file="output/empirics/US.RData")
detach(US)
