## Test asymmetric dependence with UK data
## Author: J.Pan
## Last Update: 05/2018
rm(list=ls())

library(np)
library(foreign)
library(boot)

#----------------------------------- source code --------------------------------------
setwd('.../code_sum')

source("FuncLib/console.R")

source("FuncLib/KLdiv.R")
source("FuncLib/npcdepKL.R")

source("FuncLib/exceed_cor.R")
source("FuncLib/exceed_corSBpiv.R")

console <<- newLineConsole()
console <<- printClear(console)  

#----------------------------------- Read Data --------------------------------------
UK <- read.dta("Data/InterData/UK.dta")
attach(UK)

UK.kl <- rep(NA, 6)
UK.htz <- rep(NA,6)

UK.kl[1] <- npcdepKL(data.x = Mkt,data.y=BE_h,C=0,method="MI",bootstrap=T,boot.num=399,idx="BE_h",boot.method="geom")
UK.htz[1] <- exceed_corSBpiv(X = Mkt,Y = BE_h,qc=0,boot.num=399,idx="BE_h")[[3]]

UK.kl[2] <- npcdepKL(data.x = Mkt,data.y=BE_l,C=0,method="MI",bootstrap=T,boot.num=399,idx="BE_l",boot.method="geom")
UK.htz[2] <- exceed_corSBpiv(X = Mkt,Y = BE_l,qc=0,boot.num=399,idx="BE_l")[[3]]

UK.kl[3] <- npcdepKL(data.x = Mkt,data.y=ep_h,C=0,method="MI",bootstrap=T,boot.num=399,idx="ep_h",boot.method="geom")
UK.htz[3] <- exceed_corSBpiv(X = Mkt,Y = ep_h,qc=0,boot.num=399,idx="ep_h")[[3]]

UK.kl[4] <- npcdepKL(data.x = Mkt,data.y=ep_l,C=0,method="MI",bootstrap=T,boot.num=399,idx="ep_l",boot.method="geom")
UK.htz[4] <- exceed_corSBpiv(X = Mkt,Y = ep_l,qc=0,boot.num=399,idx="ep_l")[[3]]

UK.kl[5] <- npcdepKL(data.x = Mkt,data.y=ce_h,C=0,method="MI",bootstrap=T,boot.num=399,idx="ce_h",boot.method="geom")
UK.htz[5] <- exceed_corSBpiv(X = Mkt,Y = ce_h,qc=0,boot.num=399,idx="ce_h")[[3]]

UK.kl[6] <- npcdepKL(data.x = Mkt,data.y=ce_l,C=0,method="MI",bootstrap=T,boot.num=399,idx="ce_l",boot.method="geom")
UK.htz[6] <- exceed_corSBpiv(X = Mkt,Y = ce_l,qc=0,boot.num=399,idx="ce_l")[[3]]

save(UK.kl,UK.htz,file="output/empirics/UK.RData")
