## Test asymmetric dependence with Japan data
## Author: J.Pan
## Last Update: 05/2018
rm(list=ls())

library(np)
library(foreign)
library(boot)

#----------------------------------- source code --------------------------------------
setwd('.../code_sum')

source("FuncLib/console.R")

source("FuncLib/KLdiv.R")
source("FuncLib/npcdepKL.R")

source("FuncLib/exceed_cor.R")
source("FuncLib/exceed_corSBpiv.R")

console <<- newLineConsole()
console <<- printClear(console)  

#----------------------------------- Read Data --------------------------------------
Japan <- read.dta("Data/InterData/Japan.dta")
attach(Japan)

Japan.kl <- rep(NA, 6)
Japan.htz <- rep(NA,6)

Japan.kl[1] <- npcdepKL(data.x = Mkt,data.y=BE_h,C=0,method="MI",bootstrap=T,boot.num=399,idx="BE_h",boot.method="geom")
Japan.htz[1] <- exceed_corSBpiv(X = Mkt,Y = BE_h,qc=0,boot.num=399,idx="BE_h")[[3]]

Japan.kl[2] <- npcdepKL(data.x = Mkt,data.y=BE_l,C=0,method="MI",bootstrap=T,boot.num=399,idx="BE_l",boot.method="geom")
Japan.htz[2] <- exceed_corSBpiv(X = Mkt,Y = BE_l,qc=0,boot.num=399,idx="BE_l")[[3]]

Japan.kl[3] <- npcdepKL(data.x = Mkt,data.y=ep_h,C=0,method="MI",bootstrap=T,boot.num=399,idx="ep_h",boot.method="geom")
Japan.htz[3] <- exceed_corSBpiv(X = Mkt,Y = ep_h,qc=0,boot.num=399,idx="ep_h")[[3]]

Japan.kl[4] <- npcdepKL(data.x = Mkt,data.y=ep_l,C=0,method="MI",bootstrap=T,boot.num=399,idx="ep_l",boot.method="geom")
Japan.htz[4] <- exceed_corSBpiv(X = Mkt,Y = ep_l,qc=0,boot.num=399,idx="ep_l")[[3]]

Japan.kl[5] <- npcdepKL(data.x = Mkt,data.y=ce_h,C=0,method="MI",bootstrap=T,boot.num=399,idx="ce_h",boot.method="geom")
Japan.htz[5] <- exceed_corSBpiv(X = Mkt,Y = ce_h,qc=0,boot.num=399,idx="ce_h")[[3]]

Japan.kl[6] <- npcdepKL(data.x = Mkt,data.y=ce_l,C=0,method="MI",bootstrap=T,boot.num=399,idx="ce_l",boot.method="geom")
Japan.htz[6] <- exceed_corSBpiv(X = Mkt,Y = ce_l,qc=0,boot.num=399,idx="ce_l")[[3]]

save(Japan.kl,Japan.htz,file="output/empirics/Japan.RData")
