## Test asymmetric dependence with Canada data
## Author: J.Pan
## Last Update: 05/2018
rm(list=ls())

library(np)
library(foreign)
library(boot)

#----------------------------------- source code --------------------------------------
setwd('.../code_sum')

source("FuncLib/console.R")

source("FuncLib/KLdiv.R")
source("FuncLib/npcdepKL.R")

source("FuncLib/exceed_cor.R")
source("FuncLib/exceed_corSBpiv.R")

console <<- newLineConsole()
console <<- printClear(console)  

#----------------------------------- Read Data --------------------------------------
Canada <- read.dta("Data/InterData/Canada.dta")
attach(Canada)

Canada.kl <- rep(NA, 6)
Canada.htz <- rep(NA,6)

Canada.kl[1] <- npcdepKL(data.x = Mkt,data.y=BE_h,C=0,method="MI",bootstrap=T,boot.num=399,idx="BE_h",boot.method="geom")
Canada.htz[1] <- exceed_corSBpiv(X = Mkt,Y = BE_h,qc=0,boot.num=399,idx="BE_h")[[3]]

Canada.kl[2] <- npcdepKL(data.x = Mkt,data.y=BE_l,C=0,method="MI",bootstrap=T,boot.num=399,idx="BE_l",boot.method="geom")
Canada.htz[2] <- exceed_corSBpiv(X = Mkt,Y = BE_l,qc=0,boot.num=399,idx="BE_l")[[3]]

Canada.kl[3] <- npcdepKL(data.x = Mkt,data.y=ep_h,C=0,method="MI",bootstrap=T,boot.num=399,idx="ep_h",boot.method="geom")
Canada.htz[3] <- exceed_corSBpiv(X = Mkt,Y = ep_h,qc=0,boot.num=399,idx="ep_h")[[3]]

Canada.kl[4] <- npcdepKL(data.x = Mkt,data.y=ep_l,C=0,method="MI",bootstrap=T,boot.num=399,idx="ep_l",boot.method="geom")
Canada.htz[4] <- exceed_corSBpiv(X = Mkt,Y = ep_l,qc=0,boot.num=399,idx="ep_l")[[3]]

Canada.kl[5] <- npcdepKL(data.x = Mkt,data.y=ce_h,C=0,method="MI",bootstrap=T,boot.num=399,idx="ce_h",boot.method="geom")
Canada.htz[5] <- exceed_corSBpiv(X = Mkt,Y = ce_h,qc=0,boot.num=399,idx="ce_h")[[3]]

Canada.kl[6] <- npcdepKL(data.x = Mkt,data.y=ce_l,C=0,method="MI",bootstrap=T,boot.num=399,idx="ce_l",boot.method="geom")
Canada.htz[6] <- exceed_corSBpiv(X = Mkt,Y = ce_l,qc=0,boot.num=399,idx="ce_l")[[3]]

save(Canada.kl,Canada.htz,file="output/empirics/Canada.RData")
