## Test asymmetric dependence with G7-country data
## Author: J.Pan
## Last Update: 05/2018
rm(list=ls())

library(np)
library(foreign)
library(boot)

#----------------------------------- source code --------------------------------------
setwd('.../code_sum')

source("FuncLib/console.R")

source("FuncLib/KLdiv.R")
source("FuncLib/npcdepKL.R")

source("FuncLib/exceed_cor.R")
source("FuncLib/exceed_corSBpiv.R")

console <<- newLineConsole()
console <<- printClear(console)  

#----------------------------------- Read Data --------------------------------------
combine <- read.dta("Data/InterData/index/combine.dta")
attach(combine)

combine.kl <- rep(NA,6)
combine.htz <- rep(NA,6)

combine.kl[1] <- npcdepKL(data.x = ret_us,data.y=ret_can,C=0,method="MI",bootstrap=T,boot.num=399,idx="Canada",boot.method="geom")
combine.htz[1] <- exceed_corSBpiv(X = ret_us,Y = ret_can,qc=0,boot.num=399,idx="Canada")[[3]]

combine.kl[2] <- npcdepKL(data.x = ret_us,data.y=ret_fr,C=0,method="MI",bootstrap=T,boot.num=399,idx="France",boot.method="geom")
combine.htz[2] <- exceed_corSBpiv(X = ret_us,Y = ret_fr,qc=0,boot.num=399,idx="France")[[3]]

combine.kl[3] <- npcdepKL(data.x = ret_us,data.y=ret_ger,C=0,method="MI",bootstrap=T,boot.num=399,idx="Germany",boot.method="geom")
combine.htz[3] <- exceed_corSBpiv(X = ret_us,Y = ret_ger,qc=0,boot.num=399,idx="Germany")[[3]]

combine.kl[4] <- npcdepKL(data.x = ret_us,data.y=ret_jp,C=0,method="MI",bootstrap=T,boot.num=399,idx="Japan",boot.method="geom")
combine.htz[4] <- exceed_corSBpiv(X = ret_us,Y = ret_jp,qc=0,boot.num=399,idx="Japan")[[3]]

combine.kl[5] <- npcdepKL(data.x = ret_us,data.y=ret_swiss,C=0,method="MI",bootstrap=T,boot.num=399,idx="Swiss",boot.method="geom")
combine.htz[5] <- exceed_corSBpiv(X = ret_us,Y = ret_swiss,qc=0,boot.num=399,idx="Swiss")[[3]]

combine.kl[6] <- npcdepKL(data.x = ret_us,data.y=ret_uk,C=0,method="MI",bootstrap=T,boot.num=399,idx="UK",boot.method="geom")
combine.htz[6] <- exceed_corSBpiv(X = ret_us,Y = ret_uk,qc=0,boot.num=399,idx="UK")[[3]]

save(combine.kl,combine.htz,file="output/empirics/combine.RData")
