#-------- HTZ pivotized test with stationary bootstrap --------#
## Author: Jiening Pan
## Last Update: 07/27/2015

exceed_corSBpiv <- function(X = NULL, 
                            Y = NULL,
                            qc = NULL,
                            boot.num = NULL,
                            idx = NULL,
                            boot.blocklen = NULL,
                            random.seed = 42){
  
  if(exists(".Random.seed", .GlobalEnv)) {
    save.seed <- get(".Random.seed", .GlobalEnv)
    exists.seed = TRUE
  } else {
    exists.seed = FALSE
  }
  
  set.seed(random.seed)
  
  if(is.null(boot.num)) {boot.num=199}
  B1 = round(boot.num/10)
  
  B.counter <- 0
  
  temp.stat <- exceed_cor(X=X,Y=Y,qc=qc)
  drho.sample <- temp.stat[,2]-temp.stat[,1]
  if (is.na(drho.sample)) {return(list(NA,NA,NA))}

  data <- cbind(X, Y)
  
  if(is.null(boot.blocklen)) boot.blocklen <- mean(b.star(data, round=T)[,1])
  
  se.nest <- function(ii,data,qc){
    null.sample <- data[ii,]
    temp.nested <- exceed_cor(X=null.sample[,1],Y=null.sample[,2],qc=qc)
    drho.nested <- temp.nested[,2]-temp.nested[,1]
    return(drho.nested)
  }
  
  drho.nested <- tsboot(tseries = 1:length(X),
                        statistic = se.nest,
                        R = B1,
                        n.sim = length(X),
                        l = boot.blocklen,
                        sim = "geom",
                        data = data,
                        qc = qc)$t
  
  se.sample <- cov(drho.nested)
  if (is.na(se.sample)) {return(list(NA,NA,NA))}
  if (det(as.matrix(se.sample))==0) {return(list(NA,NA,NA))}
  t.sample <- as.numeric(t(drho.sample)%*%solve(se.sample)%*%drho.sample)
  
  boot.fun <- function(ii,data,drho.sample,qc,idx) {
    console <<- printClear(console)
    console <<- printPush(paste(sep="", "Bootstrap replication ",B.counter, "/", boot.num, " of the ", idx, " sample."), console = console)
    null.sample1 <- data[ii,]
    B.counter <<- B.counter + 1
    
    temp.stat <- exceed_cor(X=null.sample1[,1],Y=null.sample1[,2],qc=qc)
    drho.boot <- temp.stat[,2]-temp.stat[,1]
    
    drho.nested1 <- tsboot(tseries = 1:length(X),
                          statistic = se.nest,
                          R = B1,
                          n.sim = length(X),
                          l = boot.blocklen,
                          sim = "geom",
                          data = null.sample1,
                          qc = qc)$t
    se.boot <- cov(drho.nested1)
    if(is.na(se.boot)){return(NA)}
    if(det(as.matrix(se.boot))==0){return(NA)}
    t.boot <- t(drho.boot-drho.sample)%*%solve(se.boot)%*%(drho.boot-drho.sample)
    return(t.boot)
  }
  
  resampled.stat <- tsboot(tseries = 1:length(X),
                           statistic = boot.fun,
                           R = boot.num,
                           n.sim = length(X),
                           l = boot.blocklen,
                           sim = "geom",
                           data = data,
                           drho.sample = drho.sample,
                           qc = qc, idx = idx)$t
  
  p.value <- mean(ifelse(resampled.stat>t.sample, 1, 0), na.rm=T)
  
  console <- printClear(console)
  console <- printPop(console)  
  
  ## Restore seed
  if(exists.seed) assign(".Random.seed", save.seed, .GlobalEnv)
  
  return(list(J = t.sample, J.boot = resampled.stat, P = p.value))
  
}