#-------- Exceedance Correlation tests in HTZ(2007) --------#
## R version of Patton's Matlab code
## Computes the 'exceedance correlations' discussed in
## Ang and Chen, Journal of Financial Economics, 2002.
##
## Corr[X,Y|X>v,Y>v] if v>0 and X<v,Y<v if v<0
##
## Testing the significance of the differences using the test of Hong, Tu and Zhou (2003).
## 
## INPUTS:  X, a Tx1 vector of data
##      	  Y, a Tx1 vector of data
##				  qc, a (k)x1 vector of quantiles or standard deviations to estimate the correl. must be increasing, and only the
##		    	"upper" part (ie, >=0.5 for q and >=0 for c)
##          drho difference btw rho+ and rho- in the original sample
##          
## OUTPUT:	Test statistic
## Author: Ke Wu & Jiening Pan
## Last Update: 09/02/2015

exceed_cor  <- function(X = NULL, 
                        Y = NULL,
                        qc = NULL) {
  
  k <- length(qc)
  C <- qc
  
  X <- (X-mean(X))/sd(X)
  Y <- (Y-mean(Y))/sd(Y)
  
  out1 = matrix(NA,k,1)
  out2 = matrix(NA,k,1)
    
  for(jj in 1:k) {
    temp1 = which (X<= -C[jj] & Y<= -C[jj]) # - comes first
    if (length(unique(X[temp1]))<=3|length(unique(Y[temp1]))<=3){
      return(cbind(NA,NA))
    } else {
      out1[jj,1] = cor(X[temp1], Y[temp1])
    }
    
    temp2 = which (X>=C[jj] & Y>=C[jj])   # + comes second
    if (length(unique(X[temp1]))<=3|length(unique(Y[temp1]))<=3){
      return(cbind(NA,NA))
    } else {
      out2[jj,1] = cor(X[temp2],Y[temp2])
    }
    
  }
  
  return(cbind(out1,out2))
}

