## Estimate exceedance dependence of return distribution at
## any give exceedance level using EMI measure following
## Jiang, Maasoumi, Pan and Wu, Journal of Applied Econometrics, 2018
## Author: Jiening Pan
## Last Update: 04/2018

KLdiv <- function (data.x = NULL, data.y = NULL, data.original = NULL, C = NULL,
                   bw.x = NULL, bw.y = NULL, bw.joint = NULL, method = c("MI","VI")) {
  
  ## MI - Mutual Information: \int\int f(x,y) log(f(x,y)/(f(x)*f(y)))
  ## VI - Modified MI with properties of a metric H(x,y)-MI
  
  if (is.null(bw.x)) {bw.x = npudensbw(~data.x)$bw}
  if (is.null(bw.y)) {bw.y = npudensbw(~data.y)$bw}
  if (is.null(bw.joint)) {bw.joint = npudensbw(dat = cbind(data.x,data.y))$bw}
  
  method <- match.arg(method)
  # Already standardized
  data <- cbind (data.x,data.y)
  if (is.null(data.original)) {data.original <- data}
  
  if (is.null(C)) {C=0}
  data.l <- as.matrix(data[which(data[,1] <= -C & data[,2] <= -C),])
  if (dim(data.l)[2]==1) {return(c(NA,NA))}
  if (length(unique(data.l[,1]))<=3|length(unique(data.l[,2]))<=3){
    return (c(NA,NA))
  }
  fx.l <- fitted(npudens(tdat=data.original[,1],edat=data.l[,1],bws=bw.x))
  fy.l <- fitted(npudens(tdat=data.original[,2],edat=data.l[,2],bws=bw.y))
  fxy.l <- fitted(npudens(tdat=data.original,edat=data.l,bws=bw.joint))
  summand.l <- log(fxy.l/(fx.l*fy.l))
  
  data.r <- as.matrix(data[which(data[,1] >= C & data[,2] >= C),])
  if (dim(data.r)[2]==1) {return(c(NA,NA))}
  if (length(unique(data.r[,1]))<=3|length(unique(data.r[,2]))<=3){
    return (c(NA,NA))
  }
  fx.r <- fitted(npudens(tdat=data.original[,1],edat=data.r[,1],bws=bw.x))
  fy.r <- fitted(npudens(tdat=data.original[,2],edat=data.r[,2],bws=bw.y))
  fxy.r <- fitted(npudens(tdat=data.original,edat=data.r,bws=bw.joint))
  summand.r <- log (fxy.r/(fx.r*fy.r))
  
  l = length(data.x)
  if (method=="MI"){
    summand.l <- sum(summand.l)
    summand.r <- sum(summand.r)
    summand = c(summand.l/l,summand.r/l)
    return(summand)
    
  } else if (method=="VI") {
    summand.l <- sum(-log(fxy.l))-summand.l
    summand.r <- sum(-log(fxy.r))-summand.r
    summand = c(summand.l/l,summand.r/l)
    return(summand)
  }
}