program define jae_table3, rclass
	local mean_r=$pi_r *$mean_e +(1-$pi_r )*$mean_t 
	local mean_s=$mean_e +(1-$pi_s )*($mean_n +$pi_w *$mean_w )		
	local sig_rr=$pi_r *$sig_e^2+(1-$pi_r )*$sig_t^2+$pi_r *(1-$pi_r )*($mean_e -$mean_t )^2
	local sig_rs=$pi_r *($pi_s +(1-$pi_s )*(1+$rho_s ))*$sig_e^2
	local sig_ss=($pi_s +(1-$pi_s )*(1+$rho_s )^2)*$sig_e^2     ///
			+(1-$pi_s )*$sig_n^2             					///
			+(1-$pi_s )*$pi_w *$sig_w^2  						///
			+(1-$pi_s )*($pi_s *($mean_n +$pi_w *$mean_w )^2    ///
			                   +$pi_w *(1-$pi_w )*$mean_w ^2 ) 
	** COV R;S with xi ~(e)
	local sig_ey1=$pi_r *$sig_e^2
	local sig_ey2=(1+(1-$pi_s )*$rho_s )*$sig_e^2
	
	matrix SSy=[`sig_rr',`sig_rs' \ ///
			   `sig_rs' , `sig_ss']
	matrix SSey=[`sig_ey1',`sig_ey2']
	matrix SSw=SSey*invsym(SSy)

	local a0=SSw[1,1]
	local b0=SSw[1,2]
	local c0=$mean_e - SSw[1,1]*`mean_r' - SSw[1,2]*`mean_s'
	
	matrix ABC=[`a0',`b0',`c0']
	matrix colname ABC = A B C
	matrix list ABC
end


/*

See MRW Table 3, last 2 rows: equations of form LHS = a + b*s

This code evaluates a and b for the various models
										
Class 5 (R2 S2): 
-----------------
(xi_hat)_Uj = mean_e + (s - mean_e - mean_n)/(1+rho)
			
			= [mean_e - (1/(1+rho_s))*(mean_e + mean_n)] + (1/(1+rho_s))*s
					
(xi_hat)_j = [mean_e - (theta)*(mean_e + mean_n)] + (theta)*s

			where theta = expression in Table 2

Class 6 (R2 S3): 
-----------------				
				
(xi_hat)_Uj = [mean_e - (1/(1+rho_s))*(mean_e + mean_n + mean_w)] + (1/(1+rho_s))*s				
					

(xi_hat)_j = [mean_e - (beta)*(mean_e + mean_n + mean_w)] + (beta)*s

			where beta = expression in Table 2					

*/

******************************************************
	/*local invrho = 1/(1 + $rho_s)

	local theta = ( (1 + $rho_s)*($sig_e)^2 )   ///
					/ ( ((1 + $rho_s)^2)*($sig_e)^2 + ($sig_n)^2 	)
					
	local beta  = ( (1 + $rho_s)*($sig_e)^2 )   ///
					/ ( ((1 + $rho_s)^2)*($sig_e)^2 + ($sig_n)^2 + ($sig_w)^2	)

	local Uj5_a = $mean_e - `invrho'*( $mean_e + $mean_n )
	
	local Uj5_b = `invrho'
	
	local Uj6_a = $mean_e - `invrho'*( $mean_e + $mean_n  + $mean_w )

	local Uj6_b = `invrho'
	

	local j5_a = $mean_e - `theta'*( $mean_e + $mean_n )
		
	local j5_b = `theta'

	local j6_a = $mean_e - `beta'*( $mean_e + $mean_n  + $mean_w )

	local j6_b = `beta'

				
	tempname tab2 

	matrix `tab2' =  [  `Uj5_a' , `Uj5_b', `j5_a' , `j5_b' ] \  /// 
					 [  `Uj6_a' , `Uj6_b', `j6_a' , `j6_b' ] 

					
	matrix colname `tab2' = Uj_a  Uj_b j_a  j_b  			
	matrix rowname `tab2' = "class5 R2-S2" "class6 R2-S3" 
	
	di " "
	di "Within-class predictors, classes 5 and 6 (Table 3, last 2 rows)"
	matrix list `tab2'
	di " "
	return matrix tab2 =`tab2'				
	
	***** (xi_tilde)_L , as per MRW p. 198 ***
	*****
	*****  formulae in MRW supplementary material, pp. 11-12 ***

	local sig_rr = $pi_r*($sig_e)^2 + (1-$pi_r)*($sig_t)^2  ///
					+ $pi_r*(1-$pi_r)*($mean_e - $mean_t)
					
	local sig_rs = $pi_r * ( $pi_s + (1-$pi_s)*(1+$rho_s) ) * ($sig_e)^2
	
	local sig_ss = ( $pi_s + (1-$pi_s)*(1+$rho_s)^2 )*($sig_e)^2  ///
					 + (1-$pi_s)*($sig_n)^2 + (1-$pi_s)*$pi_w*($sig_w)^2  ///
					 + (1-$pi_s)*( $pi_s*($mean_n + $pi_w*$mean_w)^2  )   ///
					 + (1-$pi_s)*( $pi_w*(1-$pi_w)*($mean_w)^2 ) 
					 
	tempname Sig InvSig pre AB C  ABC
	
	matrix `Sig' = [ `sig_rr' , `sig_rs' ] \    ///
					[ `sig_rs' , `sig_ss' ]		

	matrix `InvSig' = invsym(`Sig')				
	
	matrix `pre' = [ ($sig_e)^2*$pi_r , ($sig_e)^2*(1 + (1-$pi_s)*$rho_s)  ]

	matrix `AB' = `pre'*`InvSig'
	
	local a = $pi_r*(1 - .5*$pi_s)
	local b = .5*$pi_r*$pi_s + (1-$pi_r)*( $pi_s + (1-$pi_s)/(1+$rho_s) )
	
	local c = $mean_e - `a'*( $pi_r*$mean_e + (1-$pi_r)*$mean_t )   ///
				- `b'*( $mean_e + (1-$pi_s)*($mean_n + $pi_w*$mean_w)  )			
	
	matrix `C' = [ `c' ]
	matrix `ABC' = `AB' , `C'
	matrix colname `ABC' = a  b c 
	