program define jae_setup_uk_7

*** This program simply sets up all the moments as globals

	di " "
	di "*****************************************************************"
	di " "
	di "jae_set_up_uk_7"
	display "Based on sdpan30:  abs|r_i - s_i| <  0.02. CL fraction   13.87%"
	di " "
	di "*****************************************************************"
	di " "
	
/*
------------------------------------------------------------------------------
             |      Coef.   Std. Err.      z    P>|z|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
        mu_e |   9.812131   .0101499   966.72   0.000     9.792238    9.832025
       sig_e |    .752223   .0075595    99.51   0.000     .7374066    .7670395
        mu_t |    8.53032   .1113841    76.58   0.000     8.312011    8.748629
       sig_t |   1.259558   .0631884    19.93   0.000     1.135711    1.383405
        mu_w |  -.1498676   .0276815    -5.41   0.000    -.2041223   -.0956129
       sig_w |    .730928   .0274956    26.58   0.000     .6770375    .7848185
        mu_n |  -.0128811   .0028515    -4.52   0.000      -.01847   -.0072922
       sig_n |   .1412755   .0031508    44.84   0.000        .1351    .1474509
        pi_r |    .939345   .0056118   167.39   0.000      .928346    .9503439
        pi_s |   .1469314   .0047698    30.80   0.000     .1375826    .1562801
        pi_w |   .2373085   .0126557    18.75   0.000     .2125037    .2621132
       rho_s |  -.0278917   .0040825    -6.83   0.000    -.0358933   -.0198901
------------------------------------------------------------------------------

*/	

	global mean_e   9.812131
	global mean_t   8.53032
	global mean_w   (-.1498676)
	global mean_n   (-.0128811)

	global sig_e   0.752223
	global sig_t   1.259558
	global sig_w   0.730928
	global sig_n   0.1412755 

	global pi_r   0.939345
	global pi_s   0.1469314
	global pi_w   0.2373085

	global rho_s   (-0.0278917)
	
	
noisily {	
di _col(12) "xi" _col(20) "zeta"  _col(30) "eta"  _col(40) "omega" 
di " "
di "means:"  _col(12) %05.3f $mean_e _col(20) %04.3f $mean_t _col(30)  %04.3f $mean_n _col(40)  %04.3f $mean_w
di "std dev.s:"  _col(12) %04.3f $sig_e _col(20) %04.3f $sig_t _col(30)  %04.3f $sig_n _col(40)  %04.3f $sig_w
di "variances:"  _col(12) %04.3f $sig_e^2 _col(20) %04.3f $sig_t^2 _col(30)  %04.3f $sig_n^2 _col(40)  %04.3f $sig_w^2
di " "
di _col(5) "pi_r = " %04.3f $pi_r  _col(20) "pi_s = " %04.3f $pi_s _col(35)  "pi_w = " %04.3f $pi_w _col(50) "rho = " %04.3f $rho_s 
}
	

	*** Set up constructed parameters
	global mean_r1   ($mean_e)
	global mean_r2   ($mean_t)
	global mean_s1   ($mean_e)
	global mean_s2   ($mean_e+$mean_n)
	global mean_s3   ($mean_e+$mean_n+$mean_w)

	global sig_r1   ($sig_e)
	global sig_r2   ($sig_t)
	global sig_s1   ($sig_e)
	global sig_s2   (sqrt((1+$rho_s)^2*$sig_e^2+$sig_n^2))
	global sig_s3   (sqrt((1+$rho_s)^2*$sig_e^2+$sig_n^2+$sig_w^2))

	global rho_r1s1   1
	global rho_r1s2   (((1+$rho_s)*$sig_e^2)/($sig_r1*$sig_s2))
	global rho_r1s3   (((1+$rho_s)*$sig_e^2)/($sig_r1*$sig_s3))
	global rho_r2s1   0
	global rho_r2s2   0
	global rho_r2s3   0
	
end
