program define jae_setup_uk_5

*** This program simply sets up all the moments as globals

	di " "
	di "*****************************************************************"
	di " "
	di "jae_set_up_uk_5"
    display "using sdpan29: abs|r_i - s_i| <  0.010. CL fraction   7.74%"
	di " "
	di "*****************************************************************"
	di " "	
	
/*
------------------------------------------------------------------------------
             |      Coef.   Std. Err.      z    P>|z|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
        mu_e |   9.811243   .0101605   965.63   0.000     9.791329    9.831157
       sig_e |   .7541528   .0076241    98.92   0.000     .7392098    .7690958
        mu_t |   8.571628   .1067464    80.30   0.000     8.362409    8.780847
       sig_t |   1.275164    .060696    21.01   0.000     1.156202    1.394126
        mu_w |  -.1353675   .0241426    -5.61   0.000    -.1826861   -.0880489
       sig_w |   .6813984   .0263201    25.89   0.000     .6298119    .7329848
        mu_n |  -.0104581   .0024687    -4.24   0.000    -.0152966   -.0056196
       sig_n |   .1254891   .0029023    43.24   0.000     .1198007    .1311776
        pi_r |   .9380927   .0055781   168.18   0.000     .9271599    .9490255
        pi_s |   .0820758   .0036795    22.31   0.000     .0748642    .0892874
        pi_w |    .248349   .0123436    20.12   0.000     .2241559     .272542
       rho_s |  -.0230636    .003569    -6.46   0.000    -.0300586   -.0160685
------------------------------------------------------------------------------
*/	
	
	global mean_e   9.811243   
	global mean_t   8.571628
	global mean_w   (-.1353675)
	global mean_n   (-.0104581)

	global sig_e   0.7541528
	global sig_t   1.275164
	global sig_w   0.6813984
	global sig_n   0.1254891 

	global pi_r   0.9380927
	global pi_s   0.0820758
	global pi_w   0.248349   

	global rho_s   (-0.0230636)
	
	
noisily {	
di _col(12) "xi" _col(20) "zeta"  _col(30) "eta"  _col(40) "omega" 
di " "
di "means:"  _col(12) %05.3f $mean_e _col(20) %04.3f $mean_t _col(30)  %04.3f $mean_n _col(40)  %04.3f $mean_w
di "std dev.s:"  _col(12) %04.3f $sig_e _col(20) %04.3f $sig_t _col(30)  %04.3f $sig_n _col(40)  %04.3f $sig_w
di "variances:"  _col(12) %04.3f $sig_e^2 _col(20) %04.3f $sig_t^2 _col(30)  %04.3f $sig_n^2 _col(40)  %04.3f $sig_w^2
di " "
di _col(5) "pi_r = " %04.3f $pi_r  _col(20) "pi_s = " %04.3f $pi_s _col(35)  "pi_w = " %04.3f $pi_w _col(50) "rho = " %04.3f $rho_s 
}
	

	*** Set up constructed parameters
	global mean_r1   ($mean_e)
	global mean_r2   ($mean_t)
	global mean_s1   ($mean_e)
	global mean_s2   ($mean_e+$mean_n)
	global mean_s3   ($mean_e+$mean_n+$mean_w)

	global sig_r1   ($sig_e)
	global sig_r2   ($sig_t)
	global sig_s1   ($sig_e)
	global sig_s2   (sqrt((1+$rho_s)^2*$sig_e^2+$sig_n^2))
	global sig_s3   (sqrt((1+$rho_s)^2*$sig_e^2+$sig_n^2+$sig_w^2))

	global rho_r1s1   1
	global rho_r1s2   (((1+$rho_s)*$sig_e^2)/($sig_r1*$sig_s2))
	global rho_r1s3   (((1+$rho_s)*$sig_e^2)/($sig_r1*$sig_s3))
	global rho_r2s1   0
	global rho_r2s2   0
	global rho_r2s3   0
	
end
