program define jae_setup_uk_3

*** This program simply sets up all the moments as globals

	di " "
	di "*****************************************************************"
	di " "
	di "jae_set_up_uk_3"	
	display  "Based on sdpan27: abs|r_i - s_i| <  0.002. CL fraction   1.74%"
	di " "
	di "*****************************************************************"
	di " "	
	/*
	------------------------------------------------------------------------------
             |      Coef.   Std. Err.      z    P>|z|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
        mu_e |   9.810088   .0101895   962.77   0.000     9.790117    9.830059
       sig_e |   .7581703   .0079459    95.42   0.000     .7425966     .773744
        mu_t |   8.654945   .1049446    82.47   0.000     8.449257    8.860633
       sig_t |   1.293856   .0566532    22.84   0.000     1.182818    1.404894
        mu_w |  -.1188553   .0202815    -5.86   0.000    -.1586063   -.0791043
       sig_w |   .6118212   .0312739    19.56   0.000     .5505255    .6731169
        mu_n |  -.0083874   .0021405    -3.92   0.000    -.0125826   -.0041921
       sig_n |   .1092784   .0030774    35.51   0.000     .1032468      .11531
        pi_r |   .9345942   .0059381   157.39   0.000     .9229558    .9462325
        pi_s |   .0185364   .0018032    10.28   0.000     .0150021    .0220707
        pi_w |   .2682058   .0135542    19.79   0.000     .2416401    .2947715
       rho_s |  -.0176842   .0032192    -5.49   0.000    -.0239937   -.0113747
------------------------------------------------------------------------------
	*/
	global mean_e   9.810088
	global mean_t   8.654945
	global mean_w   (-.1188553)
	global mean_n   (-.0083874)

	global sig_e   0.7581703
	global sig_t   1.293856
	global sig_w   0.6118212
	global sig_n   0.1092784 

	global pi_r   0.9345942
	global pi_s   0.0185364
	global pi_w   0.2682058

	global rho_s   (-0.0176842)
	
	
noisily {	
di _col(12) "xi" _col(20) "zeta"  _col(30) "eta"  _col(40) "omega" 
di " "
di "means:"  _col(12) %05.3f $mean_e _col(20) %04.3f $mean_t _col(30)  %04.3f $mean_n _col(40)  %04.3f $mean_w
di "std dev.s:"  _col(12) %04.3f $sig_e _col(20) %04.3f $sig_t _col(30)  %04.3f $sig_n _col(40)  %04.3f $sig_w
di "variances:"  _col(12) %04.3f $sig_e^2 _col(20) %04.3f $sig_t^2 _col(30)  %04.3f $sig_n^2 _col(40)  %04.3f $sig_w^2
di " "
di _col(5) "pi_r = " %04.3f $pi_r  _col(20) "pi_s = " %04.3f $pi_s _col(35)  "pi_w = " %04.3f $pi_w _col(50) "rho = " %04.3f $rho_s 
}
	

	*** Set up constructed parameters
	global mean_r1   ($mean_e)
	global mean_r2   ($mean_t)
	global mean_s1   ($mean_e)
	global mean_s2   ($mean_e+$mean_n)
	global mean_s3   ($mean_e+$mean_n+$mean_w)

	global sig_r1   ($sig_e)
	global sig_r2   ($sig_t)
	global sig_s1   ($sig_e)
	global sig_s2   (sqrt((1+$rho_s)^2*$sig_e^2+$sig_n^2))
	global sig_s3   (sqrt((1+$rho_s)^2*$sig_e^2+$sig_n^2+$sig_w^2))

	global rho_r1s1    1
	global rho_r1s2    (((1+$rho_s)*$sig_e^2)/($sig_r1*$sig_s2))
	global rho_r1s3   (((1+$rho_s)*$sig_e^2)/($sig_r1*$sig_s3))
	global rho_r2s1   0
	global rho_r2s2   0
	global rho_r2s3   0
	
end
