program define jae_setup_sw

*** This program simply sets up all the moments as globals
*** using KY original estimates. Need to do one that is equivalent but for UK data

	di " "
	di "*****************************************************************"
	di " " 
	di "jae_set_up_sw"
	display "Based on KY's Full Model estimates"
	di " "
	di "*****************************************************************"
	di " " 
	
	global mean_e  12.283
	global mean_t   9.187
	global mean_w  (-0.304)
	global mean_n  (-0.048)

	global sig_e  0.717
	global sig_t  1.807
	global sig_w  1.239
	global sig_n  0.099 

	global pi_r  0.959
	global pi_s  0.152
	global pi_w  0.156

	global rho_s  (-0.013)
	
noisily {	
di _col(12) "xi" _col(20) "zeta"  _col(30) "eta"  _col(40) "omega" 
di " "
di "means:"  _col(12) %05.3f $mean_e _col(20) %04.3f $mean_t _col(30)  %04.3f $mean_n _col(40)  %04.3f $mean_w
di "std dev.s:"  _col(12) %04.3f $sig_e _col(20) %04.3f $sig_t _col(30)  %04.3f $sig_n _col(40)  %04.3f $sig_w
di "variances:"  _col(12) %04.3f $sig_e^2 _col(20) %04.3f $sig_t^2 _col(30)  %04.3f $sig_n^2 _col(40)  %04.3f $sig_w^2
di " "
di _col(5) "pi_r = " %04.3f $pi_r  _col(20) "pi_s = " %04.3f $pi_s _col(35)  "pi_w = " %04.3f $pi_w _col(50) "rho = " %04.3f $rho_s 
}

	*** Set up constructed parameters
	global mean_r1  ($mean_e)
	global mean_r2  ($mean_t)
	global mean_s1  ($mean_e)
	global mean_s2  ($mean_e+$mean_n)
	global mean_s3  ($mean_e+$mean_n+$mean_w)

	global sig_r1  ($sig_e)
	global sig_r2  ($sig_t)
	global sig_s1  ($sig_e)
	global sig_s2  (sqrt((1+$rho_s)^2*$sig_e^2+$sig_n^2))
	global sig_s3  (sqrt((1+$rho_s)^2*$sig_e^2+$sig_n^2+$sig_w^2))

	global rho_r1s1  1
	global rho_r1s2  (((1+$rho_s)*$sig_e^2)/($sig_r1*$sig_s2))
	global rho_r1s3  (((1+$rho_s)*$sig_e^2)/($sig_r1*$sig_s3))
	global rho_r2s1  0
	global rho_r2s2  0
	global rho_r2s3  0
	
end
