** this will generate a figure with 1000x1000 resolution
program define jae_fig_setup
	*For graph
	clear
	qui {
	noi di " "
	noi di "Drawing graphs"
	noi di " "
	noisily:display "1. Generating Grid"	
	local dim 1000
	set obs `dim'
	gen n_r=_n
	range r_var `1' `2'
	expand `dim'
	bysort r_var: gen s_var = `1' +_n*(`2'-`1')/(`dim'+1)
	by     r_var: gen n_s=_n
	noisily:display "2. Generating two-step class"
	tempvar std_r1 std_r2 std_s1 std_s2 std_s3
	** creating Densities	
	gen double `std_r1'= (r_var-$mean_r1 )/$sig_r1
	gen double `std_r2'= (r_var-$mean_r2 )/$sig_r2
	gen double `std_s1'= (s_var-$mean_s1 )/$sig_s1
	gen double `std_s2'= (s_var-$mean_s2 )/$sig_s2
	gen double `std_s3'= (s_var-$mean_s3 )/$sig_s3
	tempvar lf_2 lf_3 lf_4 lf_5 lf_6 
	*ocal lf_1=(normalden(`_r',`_mean_r1',`_sig_r1'))
	gen double `lf_2'=(1/(2*_pi*$sig_r1 *$sig_s2 *sqrt(1-$rho_r1s2^2))*exp(-1/(2*(1-$rho_r1s2^2))*(`std_r1'^2+`std_s2'^2-2*$rho_r1s2 *`std_r1' *`std_s2' )))
	gen double `lf_3'=(1/(2*_pi*$sig_r1 *$sig_s3 *sqrt(1-$rho_r1s3^2))*exp(-1/(2*(1-$rho_r1s3^2))*(`std_r1'^2+`std_s3'^2-2*$rho_r1s3 *`std_r1' *`std_s3' ))) 
	gen double `lf_4'=(normalden(r_var,$mean_r2 ,$sig_r2 )*normalden(s_var, $mean_s1 , $sig_s1 ))
	gen double `lf_5'=(normalden(r_var,$mean_r2 ,$sig_r2 )*normalden(s_var, $mean_s2 , $sig_s2 ))
	gen double `lf_6'=(normalden(r_var,$mean_r2 ,$sig_r2 )*normalden(s_var, $mean_s3 , $sig_s3 ))  
	** unconditional prob	
	gen double pa_1=(r_var==s_var)
	gen double pa_2=(r_var!=s_var)*   $pi_r  *(1-$pi_s )*(1-$pi_w )/(1-$pi_r *$pi_s )
	gen double pa_3=(r_var!=s_var)*   $pi_r  *(1-$pi_s )*   $pi_w  /(1-$pi_r *$pi_s )
	gen double pa_4=(r_var!=s_var)*(1-$pi_r )*   $pi_s             /(1-$pi_r *$pi_s )
	gen double pa_5=(r_var!=s_var)*(1-$pi_r )*(1-$pi_s )*(1-$pi_w )/(1-$pi_r *$pi_s )
	gen double pa_6=(r_var!=s_var)*(1-$pi_r )*(1-$pi_s )*   $pi_w  /(1-$pi_r *$pi_s )
		
	** Posterior/conditional prob
	tempvar pb2_6
	gen double `pb2_6'=(pa_2*`lf_2'+pa_3*`lf_3'+pa_4*`lf_4'+pa_5*`lf_5'+pa_6*`lf_6')
	gen double pb_1=(r_var==s_var)
	gen double pb_2=pa_2*`lf_2'/`pb2_6'
	gen double pb_3=pa_3*`lf_3'/`pb2_6'
	gen double pb_4=pa_4*`lf_4'/`pb2_6'
	gen double pb_5=pa_5*`lf_5'/`pb2_6'
	gen double pb_6=pa_6*`lf_6'/`pb2_6'
	recode pb_2-pb_6 (.=0)
	**  Two step. Class assigment
 	tempvar pc0 
		gen byte `pc0'=0
		gen byte pc=0
		forvalues i=1/6 {
			replace pc=`i' if (pb_`i'>`pc0')
			replace `pc0'=max(`pc0',pb_`i')
		}
	noisily:display "3. Identifying changes in classification"
	** transfering all to mata		
	mata: pc = st_data(.,"pc")
	** this identifies the "changes"
	mata {
		k=sqrt(rows(pc))
		sqr_pc=J(k*k,1,0)
		for(i=2;i<=k-1;i++) {
			for(j=2;j<=k-1;j++) {
				   jj=(i-1)*`dim'+j
					// 8 neighbors
					// i ->    j|
					//          v 
					// 1  2  3  
					// 4  x  5
					// 6  7  8 
					//ij1=((i-1)-1)*`dim'+(j-1)
					//ij2=((i+0)-1)*`dim'+(j-1)
					//ij3=((i+1)-1)*`dim'+(j-1)
					//ij4=((i-1)-1)*`dim'+(j-0)
					ij5=((i+1)-1)*`dim'+(j-0)
					//ij6=((i-1)-1)*`dim'+(j+1)
					ij7=((i+0)-1)*`dim'+(j+1)
					ij8=((i+1)-1)*`dim'+(j+1)
					if (pc[jj,1]!=pc[ij5,1] | pc[jj,1]!=pc[ij7,1] | pc[jj,1]!=pc[ij8,1])   {
							sqr_pc[jj]=1      
					}
			}
		}
	}
	getmata sqr_pc
	mata:mata drop pc
	mata:mata drop sqr_pc
	noisily:display "4. Identifying relative weight for log(R)"

	*** This is to obtain Fig 3.	
	tempvar a b
	gen double `a' = pb_1*0.5 + pb_2 + pb_3	
	gen double `b' = pb_1*0.5 + pb_4 + pb_5*$b5_2 + pb_6*$b6_2
	gen double aa = `a'/(`a'+`b')
	noisily:display "5. Slimming data for figures"
	** reducing size of data:
	** for contour Fig3 (idea keep 1 every 16 points
	gen flag_fig3=1 if mod(n_r,4)==0 & mod(n_s,4)==0 
	** for fig2. Only keep the "jumps"
	gen flag_fig2=1 if sqr_pc==1 
	keep if flag_fig3==1 | flag_fig2==1
	}


end
