function p2p = vecparm(sv)

% For portability, the parameters are stored in a structure.  It is
% occasionally necessary to convert the parameters into a vector, for
% example to check convergence.  This program creates a function handle
% called p2p that converts the structure of parameters to a vector of
% parameters if the input is a structure and converts a vector of
% parameters to a structure of parameters if the input is a vector
%
% syntax
% vector_of_parameters = p2p(structure_of_parameters);
% structure_of_parameters = p2p(vector_of_parameters);
% structure_of_parameters = p2p(p2p(structure_of_parameters));

nrx = numel(sv.RCmean);

ind_lowtri = tril(ones(nrx))==1;

split_vec = [numel(sv.FC) nrx nnz(ind_lowtri)];

p2p = @calc;
        
function Y = calc(X)
        
    if isstruct(X)==0
        
        X = mat2cell(X,split_vec,1);
            
        Y.FC = X{1};
        Y.RCmean = X{2};
        cholRCvar = zeros(nrx);
        cholRCvar(ind_lowtri) = X{3};
        Y.RCvar = cholRCvar*cholRCvar';
        Y.cholRCvar = cholRCvar;
        
    else
        
        Y = [X.FC ; X.RCmean ; X.cholRCvar(ind_lowtri)];
                    
    end
                
end

end

