sim_piecewise <- function(sig_beta=0.25,sig_eta=0.1,T=400,d_true=0.3){
beta_t <- NULL
bt <- 0
beta <- 0 #initial state of beta 

for (t in 1:T){
  innov_beta <- rnorm(1,0,sig_beta)
  if (abs(innov_beta)>d_true){
    bt <- bt+innov_beta
    beta_t <- c(beta_t,bt)
  }else{
    beta_t <- c(beta_t,bt)
  }
}



x <- runif(T,-1,1) #cumsum(rnorm(T,0,0.1))##
f <- runif(T,-1,1)#  cumsum(rnorm(T,0,0.01))
z <- runif(T,-1,1)#  cumsum(rnorm(T,0,0.01))
y <- NULL
#beta_t[,1] <- beta_t[,1]#*0

for (jj in 1:T) y <- c(y,c(x[jj]%*%beta_t[jj]+rnorm(1,0,sig_eta)))

return(list(X=x,Y=y,beta=beta_t))
}

sim_huber <- function(sig_beta=0.1,sig_eta=0.01,T=400){
  beta <- 0 #initial state of beta 
  beta_t <- NULL

  for (jj in 1:T){
    if (jj <= 0.3*T) beta <- c(0,0) else{
      if (jj>0.3*T && jj<0.7*T) beta <- c(0,0.15) else  beta <- c(0,0)#+rnorm(2,0,sig_beta)
    }
    if (  jj>=0.7*T) beta <- c(0,0)
    
    beta_t <- rbind(beta_t,beta)
  }
  
  x <- runif(T,-1,1) #cumsum(rnorm(T,0,0.1))#
  f <- runif(T,-1,1)#  cumsum(rnorm(T,0,0.01))
  z <- runif(T,-1,1)#  cumsum(rnorm(T,0,0.01))
  y <- NULL
  #beta_t[,1] <- beta_t[,1]#*0
  
  for (jj in 1:T) y <- c(y,x[jj]%*%beta_t[jj,2]+rnorm(1,0,sig_eta))
  return(list(X=x,Y=y,beta=beta_t[,2]))
}

sim_tvp <- function(sig_beta=0.15,sig_eta=0.1,T=400){
  
  b_rw <- cumsum(rnorm(T,0,sig_beta))
  
  b_rw[(0.5*T):(0.85*T)] <- b_rw[0.5*T]
  x <- runif(T,-.5,.5) #cumsum(rnorm(T,0,0.1))#
  f <- runif(T,-1,1)#  cumsum(rnorm(T,0,0.01))
  z <- runif(T,-1,1)#  cumsum(rnorm(T,0,0.01))
  y <- NULL
  
for (jj in 1:T) y <- c(y,c(x[jj]%*%b_rw[jj])+rnorm(1,0,sig_eta))
return(list(X=cbind(f,x,z),Y=y,beta=b_rw))
}
