    MODULE TOOL


    CONTAINS

    !*****************************************!

    SUBROUTINE networksize(GG, MAX, path1, path2, r, N)
    IMPLICIT NONE
    CHARACTER(100), INTENT(IN) :: path1, path2
    CHARACTER(40) :: numchr1, numchr2
    INTEGER :: g, i, io
    INTEGER, INTENT(IN) :: GG, MAX, r
    REAL, DIMENSION(MAX,MAX) :: temp
    INTEGER, DIMENSION(GG), INTENT(OUT) :: N
    
    WRITE(numchr1,*) r
    DO g = 1,GG
        WRITE(numchr2,*) g
        !  Read rows from file "**.dat"
        OPEN (g, file = trim(adjustl(path1)) // trim(adjustl(path2)) // '/R' // trim(adjustl(numchr1)) //  '/C/C' // trim(adjustl(numchr2))   // '.txt', status='old')         
        N(g)=0
        DO i=1, max
            READ(g,*,IOSTAT=io)  temp(i,1)   
            IF (io < 0) THEN
                EXIT
            END IF
            N(g) = N(g) + 1
        END DO
        CLOSE(g)    
    END DO
    END SUBROUTINE networksize
    
    !********************************************************************!

    SUBROUTINE define_variable(C_raw, X_raw, W_raw, Y_raw, GG, N, r, path1, path2, MAX)
    IMPLICIT NONE
    INTEGER, INTENT(IN) :: GG, r, MAX
    INTEGER, DIMENSION(GG), INTENT(IN) :: N
    CHARACTER(100), INTENT(IN) :: path1, path2
    CHARACTER(40) :: numchr1, numchr2
    REAL, DIMENSION(MAX,MAX,GG), INTENT(INOUT) :: W_raw, C_raw
    REAL, DIMENSION(MAX,GG), INTENT(INOUT) :: X_raw, Y_raw
    INTEGER :: i, j, g
    
    WRITE(numchr1,*) r
    
    DO g=1, GG        
        WRITE(numchr2,*) g
        OPEN (1000, file = trim(adjustl(path1)) //trim(adjustl(path2)) //  'R' // trim(adjustl(numchr1))  // '/C/C' // trim(adjustl(numchr2)) // '.txt', status='old') 
        OPEN (2000, file = trim(adjustl(path1)) //trim(adjustl(path2)) //  'R' // trim(adjustl(numchr1))  // '/W/W' // trim(adjustl(numchr2)) // '.txt', status='old') 
        OPEN (3000, file = trim(adjustl(path1)) //trim(adjustl(path2)) //  'R' // trim(adjustl(numchr1))  // '/X/X' // trim(adjustl(numchr2)) // '.txt', status='old') 
        OPEN (4000, file = trim(adjustl(path1)) //trim(adjustl(path2)) //  'R' // trim(adjustl(numchr1))  // '/Y/Y' // trim(adjustl(numchr2)) // '.txt', status='old') 

        READ(1000,*) ((C_raw(i,j,g),j=1,N(g)),i=1,N(g))
        READ(2000,*) ((W_raw(i,j,g),j=1,N(g)),i=1,N(g))
        READ(3000,*) (X_raw(i,g), i=1,N(g))
        READ(4000,*) (Y_raw(i,g), i=1,N(g))

        CLOSE(1000)
        CLOSE(2000)
        CLOSE(3000)
        CLOSE(4000)
    END DO

    END SUBROUTINE define_variable 

    !************************************************!
    FUNCTION  zeros(d1,d2) RESULT(val_fun)
    IMPLICIT  NONE
    INTEGER, INTENT(IN) :: d1, d2
    INTEGER :: i, j
    REAL, DIMENSION(d1,d2) :: val_fun  
    val_fun=0.0
    RETURN
    END FUNCTION  zeros


    !************************************************!
    FUNCTION  ones(d1,d2) RESULT(val_fun)
    IMPLICIT  NONE
    INTEGER, INTENT(IN) :: d1, d2
    INTEGER :: i, j
    REAL, DIMENSION(d1,d2) :: val_fun  
    val_fun=1.0
    RETURN
    END FUNCTION  ones


    !************************************************!
    FUNCTION  EYE(d) RESULT(val_fun)
    IMPLICIT  NONE
    INTEGER, INTENT(IN) :: d
    INTEGER :: i, j
    REAL, DIMENSION(d,d) :: val_fun
    DO i=1, d
        DO j=1, d
            val_fun(i,j)=0.0
        END DO
        val_fun(i,i)=1.0
    END DO
    RETURN
    END FUNCTION  EYE


    !**********************************!

    FUNCTION reshape_cov(s,n) RESULT(val_fun)
    IMPLICIT NONE
    INTEGER, INTENT(IN) :: n
    INTEGER :: i, j
    REAL, DIMENSION(n,n), INTENT(IN) :: s
    REAL, DIMENSION(n*(n+1)/2) :: val_fun

    IF (n==1) THEN
        val_fun(1)=s(1,1)
    ELSE
        DO j=1, n        
            DO i=1, j            
                val_fun(j*(j-1)/2+i)=s(i,j)                    
            END DO
        END DO
    END IF
    END FUNCTION reshape_cov

    !********************************************************************!

    FUNCTION dematrixize(z1,d) RESULT(z2)

    INTEGER, INTENT(IN)  :: d
    REAL, DIMENSION(d,1) :: z1
    REAL, DIMENSION(d)   :: z2
    z2(:)=z1(:,1)
    RETURN
    END FUNCTION dematrixize

    !***************************************************!

    FUNCTION trace(matrix,m) RESULT(val_fun)
    INTEGER, INTENT(IN) :: m
    REAL, DIMENSION(m,m), INTENT(IN) :: matrix
    REAL :: val_fun
    INTEGER :: i, j

    val_fun=0.0
    DO i=1, m
        DO j=1, m
            IF(j==i) val_fun=val_fun+matrix(i,j)
        END DO 
    END DO
    RETURN
    END FUNCTION trace

    !*********************************************************!

    FUNCTION mvnpdf(x,v,n) RESULT(val_fun)
    REAL, PARAMETER          :: pi=3.1415927
    INTEGER                  :: INDX(n), INFO,IPIV(n) , J  
    INTEGER, INTENT(IN)      :: n
    REAL, INTENT(IN)         :: x(n), v(n,n) 
    REAL                     :: x_t(n), inv_v(n,n)
    REAL(kind=8)             :: val_fun,det
    
   
    det=FindDet(v, n)
    x_t=x
    CALL SGESV(n,1,v,n,IPIV,x_t,n,INFO)
    val_fun= (2*pi)**(-(n)/2.0)*(det**(-0.5))*exp(-0.5*dot_product(x,x_t)) 
    RETURN
    END FUNCTION mvnpdf

    
    !*********************************************************!

    FUNCTION logmvnpdf(x,v,n) RESULT(val_fun)
    INTEGER, INTENT(IN)      :: n
    REAL, INTENT(IN)         :: x(n), v(n,n) 
    REAL                     :: x_t(n), inv_v(n,n)
    REAL(kind=8)             :: val_fun,det
    REAL, PARAMETER :: pi=3.1415927
    INTEGER :: INDX(n),  INFO,IPIV(n) , J  
   
    det=FindDet(v, n)
    x_t=x
    CALL SGESV(n,1,v,n,IPIV,x_t,n,INFO)
    val_fun= (-0.5*n)*log(2*pi)-0.5*log(det)-0.5*dot_product(x,x_t) 
    RETURN
    END FUNCTION logmvnpdf
    
    
     
    !********************************************************************!

    FUNCTION diag(x,n) RESULT(digx)

    INTEGER, INTENT(IN)      :: n
    REAL, DIMENSION(n,n)       :: x
    REAL, DIMENSION(n)     :: digx 
    INTEGER :: i
    digx=0.0
    DO i=1,n
        digx(i)=x(i,i)
    END DO
    RETURN
    END FUNCTION diag
    
    
    !********************************************************************!

    FUNCTION diagonalize(x,n) RESULT(digx)

    INTEGER, INTENT(IN)      :: n
    REAL, DIMENSION(n)       :: x
    REAL, DIMENSION(n,n)     :: digx 
    INTEGER :: i
    digx=0.0
    DO i=1,n
        digx(i,i)=x(i)
    END DO
    RETURN
    END FUNCTION diagonalize
    
    

    !********************************************************************!


    SUBROUTINE FINDInv(matrix, inverse, n, errorflag)
    !Subroutine to find the inverse of a square matrix
    !Author : Louisda16th a.k.a Ashwith J. Rego
    !Reference : Algorithm has been well explained in:
    !http://math.uww.edu/~mcfarlat/inverse.htm           
    !http://www.tutor.ms.unimelb.edu.au/matrix/matrix_inverse.html
    IMPLICIT NONE
    !Declarations
    INTEGER, INTENT(IN) :: n
    INTEGER, INTENT(OUT) :: errorflag  !Return error status. -1 for error, 0 for normal
    REAL, INTENT(IN), DIMENSION(n,n) :: matrix  !Input matrix
    REAL, INTENT(OUT), DIMENSION(n,n) :: inverse !Inverted matrix

    LOGICAL :: FLAG = .TRUE.
    INTEGER :: i, j, k, l
    REAL :: m
    REAL, DIMENSION(n,2*n) :: augmatrix !augmented matrix

    !Augment input matrix with an identity matrix
    DO i = 1, n
        DO j = 1, 2*n
            IF (j <= n ) THEN
                augmatrix(i,j) = matrix(i,j)
            ELSE IF ((i+n) == j) THEN
                augmatrix(i,j) = 1
            Else
                augmatrix(i,j) = 0
            ENDIF
        END DO
    END DO

    !Reduce augmented matrix to upper traingular form
    DO k =1, n-1
        IF (augmatrix(k,k) == 0) THEN
            FLAG = .FALSE.
            DO i = k+1, n
                IF (augmatrix(i,k) /= 0) THEN
                    DO j = 1,2*n
                        augmatrix(k,j) = augmatrix(k,j)+augmatrix(i,j)
                    END DO
                    FLAG = .TRUE.
                    EXIT
                ENDIF
                IF (FLAG .EQV. .FALSE.) THEN
                    PRINT*, "Matrix is non - invertible"
                    inverse = 0
                    errorflag = -1
                    return
                ENDIF
            END DO
        ENDIF
        DO j = k+1, n			
            m = augmatrix(j,k)/augmatrix(k,k)
            DO i = k, 2*n
                augmatrix(j,i) = augmatrix(j,i) - m*augmatrix(k,i)
            END DO
        END DO
    END DO

    !Test for invertibility
    DO i = 1, n
        IF (augmatrix(i,i) == 0) THEN
            PRINT*, "Matrix is non - invertible"
            inverse = 0
            errorflag = -1
            return
        ENDIF
    END DO

    !Make diagonal elements as 1
    DO i = 1 , n
        m = augmatrix(i,i)
        DO j = i , (2 * n)				
            augmatrix(i,j) = (augmatrix(i,j) / m)
        END DO
    END DO

    !Reduced right side half of augmented matrix to identity matrix
    DO k = n-1, 1, -1
        DO i =1, k
            m = augmatrix(i,k+1)
            DO j = k, (2*n)
                augmatrix(i,j) = augmatrix(i,j) -augmatrix(k+1,j) * m
            END DO
        END DO
    END DO				

    !store answer
    DO i =1, n
        DO j = 1, n
            inverse(i,j) = augmatrix(i,j+n)
        END DO
    END DO
    errorflag = 0
    END SUBROUTINE FINDinv


    !****************************************************!


    FUNCTION FindDet(matrix, n) RESULT(Det)

    !***********************************************!

    !Function to find the determinant of a square matrix
    !Author : Louisda16th a.k.a Ashwith J. Rego
    !Description: The subroutine is based on two key points:
    !1] A determinant is unaltered when row operations are performed: Hence, using this principle,
    !row operations (column operations would work as well) are used
    !to convert the matrix into upper traingular form
    !2]The determinant of a triangular matrix is obtained by finding the product of the diagonal elements
    !
    IMPLICIT NONE
    INTEGER, INTENT(IN) :: n
    REAL, DIMENSION(n,n) :: matrix	
    REAL(kind=8) :: m, temp, Det
    INTEGER :: i, j, k, l
    LOGICAL :: DetExists = .TRUE.
    l = 1
    !Convert to upper triangular form
    DO k = 1, n-1
        IF (matrix(k,k) == 0) THEN
            DetExists = .FALSE.
            DO i = k+1, n
                IF (matrix(i,k) /= 0) THEN
                    DO j = 1, n
                        temp = matrix(i,j)
                        matrix(i,j)= matrix(k,j)
                        matrix(k,j) = temp
                    END DO
                    DetExists = .TRUE.
                    l=-l
                    EXIT
                ENDIF
            END DO
            IF (DetExists .EQV. .FALSE.) THEN
                Det = 0
                return
            END IF
        ENDIF
        DO j = k+1, n
            m = matrix(j,k)/matrix(k,k)
            DO i = k+1, n
                matrix(j,i) = matrix(j,i) - m*matrix(k,i)
            END DO
        END DO
    END DO

    !Calculate determinant by finding product of diagonal elements
    Det = l
    DO i = 1, n
        Det = Det * matrix(i,i)
    END DO
    RETURN
    END FUNCTION FindDet

    !***************************************************************!

    SUBROUTINE SOLVE(a, x, n, errflag)
    !Declarations
    IMPLICIT NONE
    INTEGER, INTENT(IN) :: n   !Stores the number of unknowns
    INTEGER, INTENT(OUT) :: errflag
    REAL, DIMENSION(n,n+1) :: a!An n x n+1 matrix which stores the simultaneous equations
    REAL, INTENT(OUT), DIMENSION(n) :: x !Array to store the solutions
    INTEGER :: i,j,k !Counters for Loops
    INTEGER :: largest
    REAL :: temp, m, sums
    LOGICAL :: FLAG
    m = 0
    !Solve Using Gaussian Elimination
    FLAG = .FALSE.
    x = 0
    DO k = 1, n-1
        DO j = 1, n
            IF (a(j, 1) /= 0 ) FLAG = .TRUE.
        END DO
        IF (FLAG .EQV. .FALSE.) THEN
            PRINT*,"No Unique Solution"
            errflag = -1
            x = 0
            EXIT
        ELSE
            largest = k
            !Find largest coefficient of first unknown
            DO j = k, n
                IF (ABS(a(j, k)) > ABS(a(largest,k))) largest = j
            END DO			
            !Make the equation with largest first coefficient as the first equation
            !Largest coefficient is chosen to prevent round-off errors as far as possible
            DO j = 1, n + 1
                temp = a(k, j)
                a(k,j) = a(largest,j)
                a(largest,j)=temp
            END DO
        ENDIF
        !Convert the input matrix to Upper Traingualar form
        DO j = k+1, n
            m = a(j,k)/a(k,k)
            DO i = k+1, n+1
                a(j,i) = a(j,i) - m*a(k,i)
            END DO
        END DO
        !No unique solution exists if the last element in the upper triangular matrix is zero
        IF (a(n,n) == 0) THEN
            PRINT*,"No Unique Solution"
            errflag = -1
            x = 0
            EXIT
        ELSE
            !Find xn
            x(n) = a(n,n+1)/a(n,n)
            !Find the remaining unknowns by back-substitution
            DO i = n-1, 1, -1
                sums = 0
                DO j = i+1, n
                    sums = sums + a(i,j)*x(j)
                END DO
                x(i) = (a(i,n+1) - sums)/a(i,i)
            END DO
        ENDIF
    END DO

    END SUBROUTINE SOLVE


    !  ***************************************************************
    !  * Given an N x N matrix A, this routine replaces it by the LU *
    !  * decomposition of a rowwise permutation of itself. A and N   *
    !  * are input. INDX is an output vector which records the row   *
    !  * permutation effected by the partial pivoting; D is output   *
    !  * as -1 or 1, depending on whether the number of row inter-   *
    !  * changes was even or odd, respectively. This routine is used *
    !  * in combination with LUBKSB to solve linear equations or to  *
    !  * invert a matrix. Return code is 1, if matrix is singular.   *
    !  ***************************************************************
    Subroutine LUDCMP(A,N,INDX,D,CODE)
    PARAMETER(NMAX=100,TINY=1.5D-16)
    REAL    AMAX,DUM, SUM, A(N,N),VV(NMAX)
    INTEGER CODE, D, INDX(N)

    D=1; CODE=0

    DO I=1,N
        AMAX=0.d0
        DO J=1,N
            IF (ABS(A(I,J)).GT.AMAX) AMAX=ABS(A(I,J))
        END DO ! j loop
        IF(AMAX.LT.TINY) THEN
            CODE = 1
            RETURN
        END IF
        VV(I) = 1.d0 / AMAX
    END DO ! i loop

    DO J=1,N
        DO I=1,J-1
            SUM = A(I,J)
            DO K=1,I-1
                SUM = SUM - A(I,K)*A(K,J) 
            END DO ! k loop
            A(I,J) = SUM
        END DO ! i loop
        AMAX = 0.d0
        DO I=J,N
            SUM = A(I,J)
            DO K=1,J-1
                SUM = SUM - A(I,K)*A(K,J) 
            END DO ! k loop
            A(I,J) = SUM
            DUM = VV(I)*ABS(SUM)
            IF(DUM.GE.AMAX) THEN
                IMAX = I
                AMAX = DUM
            END IF
        END DO ! i loop  

        IF(J.NE.IMAX) THEN
            DO K=1,N
                DUM = A(IMAX,K)
                A(IMAX,K) = A(J,K)
                A(J,K) = DUM
            END DO ! k loop
            D = -D
            VV(IMAX) = VV(J)
        END IF

        INDX(J) = IMAX
        IF(ABS(A(J,J)) < TINY) A(J,J) = TINY

        IF(J.NE.N) THEN
            DUM = 1.d0 / A(J,J)
            DO I=J+1,N
                A(I,J) = A(I,J)*DUM
            END DO ! i loop
        END IF 
    END DO ! j loop

    RETURN
    END subroutine LUDCMP


    !  ******************************************************************
    !  * Solves the set of N linear equations A . X = B.  Here A is     *
    !  * input, not as the matrix A but rather as its LU decomposition, *
    !  * determined by the routine LUDCMP. INDX is input as the permuta-*
    !  * tion vector returned by LUDCMP. B is input as the right-hand   *
    !  * side vector B, and returns with the solution vector X. A, N and*
    !  * INDX are not modified by this routine and can be used for suc- *
    !  * cessive calls with different right-hand sides. This routine is *
    !  * also efficient for plain matrix inversion.                     *
    !  ******************************************************************
    Subroutine LUBKSB(A,N,INDX,B)
    REAL  SUM, A(N,N),B(N)
    INTEGER INDX(N)

    II = 0

    DO I=1,N
        LL = INDX(I)
        SUM = B(LL)
        B(LL) = B(I)
        IF(II.NE.0) THEN
            DO J=II,I-1
                SUM = SUM - A(I,J)*B(J)
            END DO ! j loop
        ELSE IF(SUM.NE.0.d0) THEN
            II = I
        END IF
        B(I) = SUM
    END DO ! i loop

    DO I=N,1,-1
        SUM = B(I)
        IF(I < N) THEN
            DO J=I+1,N
                SUM = SUM - A(I,J)*B(J)
            END DO ! j loop
        END IF
        B(I) = SUM / A(I,I)
    END DO ! i loop

    RETURN
    END subroutine LUBKSB


    !**********************************!
    FUNCTION cov(s,n,t) RESULT(val_fun)
    IMPLICIT NONE
    INTEGER, INTENT(IN) :: n, t
    INTEGER :: i, j
    REAL, DIMENSION(n) :: mean_i, var_i
    REAL, DIMENSION(n,t), INTENT(IN) :: s
    REAL, DIMENSION(n,n) :: val_fun

    DO i=1, n
        mean_i(i)=sum(s(i,:))/t
        var_i(i)=0.0
        DO j=1, t
            var_i(i)=var_i(i)+(s(i,j)-mean_i(i))**2
        END DO
        var_i(i)=var_i(i)/t
    END DO

    IF (n==1) THEN
        val_fun(1,1)=var_i(1)
        !RESHAPE(val_fun, (/n/)) 
    ELSE
        DO i=1, n
            val_fun(i,i)=var_i(i)
            DO j=i+1, n
                val_fun(i,j)=dot_product(s(i,:)-mean_i(i),s(j,:)-mean_i(j))/t
                val_fun(j,i)=val_fun(i,j)
            END DO
        END DO
    END IF
    END FUNCTION cov

    !**********************************!
    FUNCTION var(s,t) RESULT(val_fun)
    IMPLICIT NONE
    INTEGER, INTENT(IN) :: t
    INTEGER :: i
    REAL :: mean
    REAL, DIMENSION(t), INTENT(IN) :: s
    REAL :: val_fun

    mean=sum(s)/t
    val_fun=0.0
    DO i=1, t  
        val_fun=val_fun+(s(i)-mean)**2
    END DO
    val_fun=val_fun/t

    END FUNCTION var

    
    !**********************************!
    FUNCTION var_8(s,t) RESULT(val_fun)
    IMPLICIT NONE
    INTEGER, INTENT(IN) :: t
    INTEGER :: i
    REAL(kind=8) :: mean
    REAL(kind=8), DIMENSION(t), INTENT(IN) :: s
    REAL(kind=8) :: val_fun

    mean=sum(s)/t
    val_fun=0.0
    DO i=1, t  
        val_fun=val_fun+(s(i)-mean)**2
    END DO
    val_fun=val_fun/t

    END FUNCTION var_8
    

    END MODULE TOOL