    include 'mkl_vsl.f90'

    PROGRAM estimation

    USE random
    USE TOOL
    USE lapack95
    USE MKL_VSL_TYPE
    USE MKL_VSL
    USE omp_lib
    IMPLICIT NONE

    !****************** GENERAL VARIABLES ****************!

    CHARACTER(100)     :: path1='D:/research/social_preference_and_social_interaction/simulation/'
    CHARACTER(100)     :: path2='/data/'
    CHARACTER(100)     :: path3='/result/modelV/'
    CHARACTER(40)      :: numchr1
    INTEGER, PARAMETER :: GG=30, TT=20000, MAX=50, RR=100, THIN=100, Nthreads=80
    REAL               :: c_1, c_2, acc_1, acc_2, rand, c_3, acc_3(GG), acc_3v, acc_4, kk
    INTEGER            ::   NN, N(GG),  k
    INTEGER            :: brng, method, me, i, j, g, t, d, flag, ier,  r, m, seedsize, seed(2), errorflag, INFO, seed_mkl, t_round
    INTEGER            :: clock_max, clock_rate, clock_start, clock_stop, ithread, iblock,ibegin,iend
    REAL, DIMENSION(MAX,MAX,GG):: C_raw, W_raw
    REAL, DIMENSION(MAX,GG):: X_raw, Y_raw
    REAL, ALLOCATABLE:: C(:,:), W(:,:), IPIV(:)
    REAL, ALLOCATABLE:: Y(:),X(:)
    LOGICAL            :: first=.true.
    TYPE (VSL_STREAM_STATE) :: stream
    INTEGER(kind=4)            ::  errcode


    !*** hyperparameters in the prior distribution ***!
    REAL, DIMENSION(2) :: beta_0
    REAL, DIMENSION(2,2) :: B_0, INV_B_0
    REAL         ::  eta_0, ALPHA_0
    INTEGER  ::  rho_0

    !*** MC collections of parameters *******!

    REAL, DIMENSION(RR)     :: lambda_R
    REAL, DIMENSION(2, RR)  :: beta_R
    REAL, DIMENSION(RR)     :: sigma_R


    !*** posterior draws of parameters *******!

    REAL, DIMENSION(TT)     :: lambda_T, acc_rate1, acc_rate2, acc_rate4
    REAL, DIMENSION(2, TT)  :: beta_T
    REAL, DIMENSION(TT)     :: sigma_T
    REAL, DIMENSION(GG,TT)  :: alpha_T, acc_rate3

    !******  VARIABLE IN M-H FOR Z_G  *******************************!


    REAL, ALLOCATABLE  :: V(:,:), S1(:,:), S2(:,:), XX(:,:)
    REAL, ALLOCATABLE  :: V1(:,:), V2(:,:), V3(:,:), V4(:,:)
    REAL, ALLOCATABLE  :: ep_1(:), ep_2(:), ep_3(:), ep_4(:)
    REAL, ALLOCATABLE  :: ep_1v(:), ep_2v(:), ep_3v(:), ep_4v(:)
    REAL(kind=8) :: like_Y1, like_Y2, q_1, q_2


    !********VARIABLE IN M-H FOR GAMMA & LAMBDA   ***************!

    REAL         :: lambda_1, lambda_2
    REAL(kind=8) ::  pp_l(GG), pp_G(GG)

    !*************VARIABLE IN M-H FOR BETA **************!

    REAL :: XVX(2,2,GG), XVY(2,GG), INV_B(2,2), INV_B2(2,2), beta_temp(2)
    REAL, ALLOCATABLE ::  XX2(:,:), YY(:), S(:,:)

    !*************VARIABLE IN M-H FOR SIGMA_E **************!

    REAL :: R_g
    REAL, ALLOCATABLE :: ep_v(:), ep(:)
    INTEGER           :: rho_1, stack

    !***********************************************************!

    seedsize=2
    seed(1)=2.1103e+005
    seed(2)=2.1103e+005
    CALL RANDOM_SEED
    CALL RANDOM_SEED(SIZE=seedsize)
    CALL RANDOM_SEED(PUT=seed)

    seed_mkl=12345
    brng=VSL_BRNG_MCG31
    method=VSL_RNG_METHOD_GAUSSIANMV_BOXMULLER
    me=VSL_MATRIX_STORAGE_FULL

    errcode=vslnewstream(stream,brng,seed_mkl)



    OPEN (40000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'lambda_R.txt', status='unknown')
    OPEN (50000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'beta_R.txt', status='unknown')
    OPEN (60000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'sigma_R.txt', status='unknown')


    DO r=1, RR

        print*, 'r=', r
        WRITE(numchr1,*) r

        !OPEN (10000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'lambda.txt', status='unknown')
        !OPEN (20000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'beta.txt', status='unknown')
        !OPEN (30000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'sigma.txt', status='unknown')


        beta_0=0.0
        B_0=eye(2)*10.0
        CALL FINDInv(B_0,INV_B_0,2,ier)
        ALPHA_0=100.0
        eta_0=0.1
        rho_0=2

        CALL networksize(GG, MAX, path1, path2, r, N)
        CALL define_variable(C_raw, X_raw, W_raw, Y_raw, GG, N, r, path1, path2, MAX)



        ! initial value of the draws !
        c_3=0.1
        acc_3=0.0
        acc_1=0
        acc_2=0
        acc_4=0

        lambda_T(1)=0.05

        DO t=2, TT
            call system_clock ( clock_start, clock_rate, clock_max )

            DO
                lambda_1=random_normal()*0.1+lambda_T(t-1)
                IF (t>2) THEN
                    lambda_2=random_normal()*sqrt(var(lambda_T(1:t-1),t-1))*2.38+lambda_T(t-1)
                    lambda_1=0.95*lambda_2+0.05*lambda_1
                END IF
                IF (abs(lambda_1)<=0.1) EXIT
            END DO


            Call OMP_SET_NUM_THREADS(Nthreads)
            !$omp parallel default(shared) private(g, V, NN, Y, X, XX, W,  &
            !$omp & ep_1, ep_2, ep_1v, ep_2v, V1,V2, S1, S2, INFO, IPIV,  &
            !$omp & i, j, like_Y1, like_Y2, rand, &
            !$omp & ithread, iblock, ibegin, iend)

            ithread = OMP_GET_THREAD_NUM()
            iblock = (GG+Nthreads-1)/Nthreads
            ibegin = ithread*iblock+1
            iend = min((ithread+1)*iblock,GG)

            DO g = ibegin,iend

                NN=N(g)
                ALLOCATE(V(NN,NN));
                ALLOCATE(W(NN,NN));    ALLOCATE(Y(NN))
                ALLOCATE(X(NN));       ALLOCATE(XX(NN,2))
                ALLOCATE(S1(NN,NN));   ALLOCATE(S2(NN,NN))
                ALLOCATE(V1(NN,NN));   ALLOCATE(V2(NN,NN))
                ALLOCATE(ep_1(NN));    ALLOCATE(ep_2(NN))
                ALLOCATE(ep_1v(NN));   ALLOCATE(ep_2v(NN))
                ALLOCATE(IPIV(NN))

                V=sigma_T(t-1)*EYE(NN)
                W=W_raw(1:NN,1:NN,g)
                Y=Y_raw(1:NN,g)
                X=X_raw(1:NN,g)

                !***** THE M-H ALGORITHM FOR SAMPLING LAMBDA ******!


                XX(:,1)=X
                XX(:,2)=matmul(W,X)

                S1=eye(NN)-lambda_1*W
                S2=eye(NN)-lambda_T(t-1)*W
                ep_1=matmul(S1,Y)-matmul(XX,beta_T(:,t-1))-alpha_T(g,t-1)
                ep_2=matmul(S2,Y)-matmul(XX,beta_T(:,t-1))-alpha_T(g,t-1)

                ep_1v=ep_1
                ep_2v=ep_2
                V1=V
                V2=V

                CALL SGESV(NN,1,V1,NN,IPIV,ep_1v,NN,INFO)
                CALL SGESV(NN,1,V2,NN,IPIV,ep_2v,NN,INFO)
                like_Y1=log(FindDet(S1, NN))-dot_product(ep_1, ep_1v)/2
                like_Y2=log(FindDet(S2, NN))-dot_product(ep_2, ep_2v)/2

                pp_l(g)=like_Y1-like_Y2

                DEALLOCATE(V);
                DEALLOCATE(W);     DEALLOCATE(Y)
                DEALLOCATE(S1);    DEALLOCATE(S2)
                DEALLOCATE(X);     DEALLOCATE(XX)
                DEALLOCATE(V1);    DEALLOCATE(V2)
                DEALLOCATE(ep_1);  DEALLOCATE(ep_2)
                DEALLOCATE(ep_1v); DEALLOCATE(ep_2v)
                DEALLOCATE(IPIV)

            END DO
            !$omp end parallel

            CALL random_number(rand)
            IF (log(rand)<=sum(pp_l)) THEN
                lambda_T(t)=lambda_1
                acc_2=acc_2+1.0
            ELSE
                lambda_T(t)=lambda_T(t-1)
            END IF
            acc_rate2(t)=acc_2/t



            !***************GIBBS STEP TO SIMULTE BETA *********************!


            XVX=0.0
            XVY=0.0

            Call OMP_SET_NUM_THREADS(Nthreads)
            !$omp parallel default(shared) private(g,NN, Y, YY, W,  &
            !$omp & X, XX, XX2, S, V, V1, V2,  IPIV, INFO, i, j, &
            !$omp & ithread, iblock, ibegin, iend)

            ithread = OMP_GET_THREAD_NUM()
            iblock = (GG+Nthreads-1)/Nthreads
            ibegin = ithread*iblock+1
            iend = min((ithread+1)*iblock,GG)

            DO g = ibegin,iend

                NN=N(g)
                ALLOCATE(Y(NN));        ALLOCATE(YY(NN))
                ALLOCATE(X(NN)) ;
                ALLOCATE(XX(NN,2));ALLOCATE(XX2(NN,2)) ;
                ALLOCATE(W(NN,NN));
                ALLOCATE(S(NN,NN));
                ALLOCATE(V(NN,NN));
                ALLOCATE(V1(NN,NN)); ALLOCATE(V2(NN,NN))
                ALLOCATE(IPIV(NN))

                V=sigma_T(t-1)*EYE(NN)
                W=W_raw(1:NN,1:NN,g)
                Y=Y_raw(1:NN,g)
                X=X_raw(1:NN,g)
                XX(:,1)=X
                XX(:,2)=matmul(W,X)

                S=eye(NN)-lambda_T(t)*W

                XX2=XX
                V1=V
                CALL SGESV(NN,2,V1,NN,IPIV,XX2,NN,INFO)
                YY=matmul(S,Y)-alpha_T(g,t-1)
                V2=V
                CALL SGESV(NN,1,V2,NN,IPIV,YY,NN,INFO)

                XVX(:,:,g)=matmul(transpose(XX) , XX2)
                XVY(:,g)=matmul(transpose(XX) , YY)

                DEALLOCATE(Y,YY,X,XX,XX2,W,S,V,V1,V2,IPIV)
            END DO
            !$omp end parallel

            CALL FINDInv(sum(XVX,3)+INV_B_0,INV_B,2,ier)
            INV_B2=INV_B
            CALL spotrf('U',2, INV_B2, 2, info)
            errcode=vsrnggaussianmv(method, stream, 1, beta_temp, 2, me, beta_0,  INV_B2)
            beta_T(:,t)=beta_temp+matmul(INV_B,sum(XVY,2))



            !******************M-H STEP FOR SIGMA_E & SIGMA_EZ *****************!

            rho_1=0
            ALLOCATE(ep_v(sum(N)))
            stack=0
            DO g=1,GG

                NN=N(g)
                ALLOCATE(V(NN,NN))
                ALLOCATE(W(NN,NN));    ALLOCATE(Y(NN))
                ALLOCATE(X(NN));       ALLOCATE(XX(NN,2))
                ALLOCATE(S(NN,NN))
                ALLOCATE(ep(NN))
                ALLOCATE(IPIV(NN))

                V=sigma_T(t-1)*EYE(NN)
                W=W_raw(1:NN,1:NN,g)
                Y=Y_raw(1:NN,g)
                X=X_raw(1:NN,g)

                S=eye(NN)-lambda_T(t)*W
                XX(:,1)=X
                XX(:,2)=matmul(W,X)
                ep=matmul(S,Y)-matmul(XX,beta_T(:,t))-alpha_T(g,t-1)
                ep_v(stack+1:stack+NN)=ep
                rho_1=rho_1+NN
                stack=stack+NN

                DEALLOCATE(V)
                DEALLOCATE(W);    DEALLOCATE(Y)
                DEALLOCATE(X);    DEALLOCATE(XX)
                DEALLOCATE(S)
                DEALLOCATE(ep)
                DEALLOCATE(IPIV)
            END DO

            sigma_T(t)=(dot_product(ep_v,ep_v)+eta_0)/random_chisq(rho_1+rho_0, first)
            DEALLOCATE(ep_v)

            !*************GIBBS STEP FOR ALPHA_G*********************!


            DO g=1,GG
                NN=N(G)
                ALLOCATE(W(NN,NN));         ALLOCATE(Y(NN))
                ALLOCATE(X(NN));                ALLOCATE(XX(NN,2))
                ALLOCATE(S(NN,NN));          ALLOCATE(YY(NN))


                R_g=(ALPHA_0**(-1)+sigma_T(t)**(-1.0)*NN)**(-1.0)
                W=W_raw(1:NN,1:NN,g)
                Y=Y_raw(1:NN,g)
                X=X_raw(1:NN,g)

                S=eye(NN)-lambda_T(t)*W
                YY=matmul(S,Y)
                XX(:,1)=X
                XX(:,2)=matmul(W,X)
                alpha_T(g,t)=sigma_T(t)**(-1.0)*R_g*sum((YY-matmul(XX,beta_T(:,t))))+random_normal()*sqrt(R_g)


                DEALLOCATE(W);         DEALLOCATE(Y)
                DEALLOCATE(X);         DEALLOCATE(XX)
                DEALLOCATE(S);         DEALLOCATE(YY)

            END DO


            call system_clock ( clock_stop, clock_rate, clock_max )
            t_round=t/100
            IF (t-t_round*100==0) THEN
                WRITE(*,*)   'T=', t
                WRITE(*,'(a6, f7.4)') 'Time:', real ( clock_stop - clock_start ) / real ( clock_rate )
                WRITE(*,'(a6, f7.4)') 'LAMBDA:', lambda_T(t)
                WRITE(*,'(a6,2f7.4)') 'BETA:', beta_T(:,t)
                WRITE(*,'(a6,f7.4)') 'SIGMA:',  sigma_T(t)
            END IF

            !WRITE(10000,'(f7.4)')    lambda_T(t)
            !WRITE(20000,'(2f7.4)')  beta_T(:,t)
            !WRITE(30000,'(f7.4)')   sigma_T(t)

        END DO
        !close(10000)
        !close(20000)
        !close(30000)

        lambda_R(r)=sum(lambda_T(5001:TT))/(TT-5000)
        beta_R(:,r)=sum(beta_T(:,5001:TT),2)/(TT-5000)
        sigma_R(r)=sum(sigma_T(5001:TT))/(TT-5000)

        WRITE(40000,'(f7.4)')     lambda_R(r)
        WRITE(50000,'(2f7.4)')    beta_R(:,r)
        WRITE(60000,'(f7.4)')    sigma_R(r)
    END DO
    close(60000)
    close(70000)
    close(80000)


    END PROGRAM estimation



