    include 'mkl_vsl.f90'

    PROGRAM estimation

    USE random
    USE TOOL
    USE lapack95
    USE MKL_VSL_TYPE
    USE MKL_VSL
    USE omp_lib
    IMPLICIT NONE

    !****************** GENERAL VARIABLES ****************!

    CHARACTER(100)     :: path1='D:/research/social_preference_and_social_interaction/simulation/'
    CHARACTER(100)     :: path2='/data/'
    CHARACTER(100)     :: path3='/result/modelIV/'
    CHARACTER(40)      :: numchr1
    INTEGER, PARAMETER :: GG=30, TT=20000, MAX=50, RR=100, THIN=100, Nthreads=80, DD=1, H=5, H1=5, burn=2000
    REAL               :: c_0a(GG), c_0z(GG), c_1, c_2, acc_1, acc_2, rand, rand1(1), c_3, acc_0v, acc_3(GG), acc_0a(GG), acc_0z(GG), acc_3v, acc_4, kk
    INTEGER            ::   NN, N(GG),  k
    INTEGER            :: brng, method, me, i, j, g, t, d, flag, ier,  r, m, seedsize, seed(2), errorflag, INFO, seed_mkl, t_round
    INTEGER            :: clock_max, clock_rate, clock_start, clock_stop, ithread, iblock,ibegin,iend
    REAL, DIMENSION(MAX,MAX,GG):: C_raw, W_raw
    REAL, DIMENSION(MAX,GG):: X_raw, Y_raw
    REAL, ALLOCATABLE :: C(:,:), W(:,:), W_altru(:,:), W_altru1(:,:), W_altru2(:,:)
    REAL, ALLOCATABLE :: IPIV(:), Y(:), X(:)
    REAL(kind=8)      :: pp
    LOGICAL           :: first=.true.
    TYPE (VSL_STREAM_STATE) :: stream
    INTEGER(kind=4)         ::  errcode


    !*** hyperparameters in the prior distribution ***!
    REAL, DIMENSION(2+DD)           :: gamma_0
    REAL, DIMENSION(2+DD,2+DD)      :: G_0
    REAL, DIMENSION(2+2*DD)         :: beta_0
    REAL, DIMENSION(2+2*DD,2+2*DD)  :: B_0, INV_B_0
    REAL                            :: eta_0, ALPHA_0, a_0
    INTEGER                         :: rho_0

    !*** MC collections of parameters *******!

    REAL, DIMENSION(2+DD,RR)     :: gamma_R
    REAL, DIMENSION(RR)          :: lambda_R
    REAL, DIMENSION(2+2*DD, RR)  :: beta_R
    REAL, DIMENSION(RR)          :: sigma_R


    !*** posterior draws of parameters *******!

    REAL, DIMENSION(TT)         :: lambda_T
    REAL, DIMENSION(2+DD,TT)    :: gamma_T
    REAL, DIMENSION(TT)         :: acc_rate1, acc_rate2, acc_rate4
    REAL, DIMENSION(2+2*DD, TT) :: beta_T
    REAL, DIMENSION(TT)         :: sigma_T
    REAL, DIMENSION(GG,TT)      :: alpha_T, acc_rate3, acc_rate0a, acc_rate0z
    REAL, DIMENSION(MAX,GG,TT/THIN):: aa_TT

    !******  VARIABLE IN M-H FOR A_G  *******************************!

    REAL, DIMENSION(MAX,GG) :: aa, aa_mean, aa_temp, aa_var, a_temp2
    REAL, ALLOCATABLE       :: aa_1(:), aa_2(:), cov_aa(:,:), temp_aa(:)

    !******  VARIABLE IN M-H FOR Z_G  *******************************!

    REAL, DIMENSION(MAX,DD,GG) :: zz
    REAL, DIMENSION(DD,GG) :: mu_zz
    REAL, ALLOCATABLE  :: zz_1(:,:), zz_2(:,:), cov_zz(:,:), temp_zz(:), demean_zz_1(:,:), demean_zz_2(:,:)

    !******  VARIABLE IN M-H FOR Z_G  *******************************!

    REAL, ALLOCATABLE  :: psi(:,:), psi_1(:,:), psi_2(:,:), zero(:)
    REAL, ALLOCATABLE  :: V(:,:), S1(:,:), S2(:,:), XX(:,:)
    REAL, ALLOCATABLE  :: V1(:,:), V2(:,:), V3(:,:), V4(:,:)
    REAL, ALLOCATABLE  :: ep_1(:), ep_2(:), ep_3(:), ep_4(:)
    REAL, ALLOCATABLE  :: ep_1v(:), ep_2v(:), ep_3v(:), ep_4v(:)
    REAL(kind=8) :: like_Y1, like_Y2, q_1, q_2


    !********VARIABLE IN M-H FOR GAMMA & LAMBDA   ***************!

    REAL      :: lambda_1, lambda_2 
    REAL      :: gamma_1(2+DD), gamma_2(2+DD), COV_gamma_1(2+DD,2+DD)
    REAL(kind=8) ::  pp_l(GG), pp_G(GG)

    !*************VARIABLE IN M-H FOR BETA **************!

    REAL :: XVX(2+2*DD,2+2*DD,GG), XVY(2+2*DD,GG), INV_B(2+2*DD,2+2*DD), INV_B2(2+2*DD,2+2*DD), beta_temp(2+2*DD)
    REAL, ALLOCATABLE ::  XX2(:,:), YY(:), S(:,:)

    !*************VARIABLE IN M-H FOR SIGMA_E **************!

    REAL :: R_g
    REAL, ALLOCATABLE :: ep_v(:), ep(:)
    INTEGER           :: rho_1, stack

    !***********************************************************!

    seedsize=2
    seed(1)=2.1103e+005
    seed(2)=2.1103e+005
    CALL RANDOM_SEED
    CALL RANDOM_SEED(SIZE=seedsize)
    CALL RANDOM_SEED(PUT=seed)

    seed_mkl=12345
    brng=VSL_BRNG_MCG31
    method=VSL_RNG_METHOD_GAUSSIANMV_BOXMULLER
    me=VSL_MATRIX_STORAGE_FULL

    errcode=vslnewstream(stream,brng,seed_mkl)

	
    OPEN (30000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'gamma_R.txt', status='unknown')
    OPEN (40000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'lambda_R.txt', status='unknown')
    OPEN (50000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'beta_R.txt', status='unknown')
    OPEN (60000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'sigma_R.txt', status='unknown')


    DO r=1, RR

        print*, 'r=', r
        WRITE(numchr1,*) r

        !OPEN (10000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'lambda.txt', status='unknown')
        !OPEN (20000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'beta.txt', status='unknown')
        !OPEN (30000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'sigma.txt', status='unknown')


        aa=0.0
        zz=1.0
        lambda_0=0.0
        gamma_0=0.0
        beta_0=0.0
        B_0=eye(2+2*DD)*10.0
        CALL FINDInv(B_0,INV_B_0,2+2*DD,ier)
        G_0=eye(2+DD)*100.0
        ALPHA_0=400.0
        a_0=0.0
        eta_0=0.1
        rho_0=2

        CALL networksize(GG, MAX, path1, path2, r, N)
        CALL define_variable(C_raw, X_raw, W_raw, Y_raw, GG, N, r, path1, path2, MAX)

        ! initial value of the draws !
        c_0a=0.08
        c_0z=1e-2
        c_3=0.1
        acc_3=0.0
        acc_1=0
        acc_2=0
        acc_4=0
        acc_0a=0.0
        acc_0z=0.0
        acc_rate0a=0.0
        acc_rate0z=0.0

		gamma_T(:,1)=(/-2.0, 0.5, 0.5/)


        DO t=2, TT
            call system_clock ( clock_start, clock_rate, clock_max )
            DO 
                lambda_1=random_normal()*0.1+lambda_T(t-1)
                IF (t>2) THEN  
                    lambda_2=random_normal()*sqrt(var(lambda_T(1:t-1),t-1))*2.38+lambda_T(t-1)
                    lambda_1=0.95*lambda_2+0.05*lambda_1
                END IF  
                IF (abs(lambda_1)<=0.1) EXIT  
            END DO   


            DO
                COV_gamma_1=EYE(2+DD)*1e-4
                call spotrf('U',2+DD, COV_gamma_1, 2+DD, info)
                errcode=vsrnggaussianmv(method,stream,1,gamma_1, 2+DD, me, gamma_0, COV_gamma_1)
                gamma_1=gamma_1+gamma_T(:,t-1)
                if (t>2000) then
                    cov_gamma_1=cov(gamma_t(:,1900:t-1),2+DD,t-1900)*2.38**2/(2+DD)
                    call spotrf('u',2+DD, cov_gamma_1, 2+DD, info)
                    errcode=vsrnggaussianmv(method,stream,1,gamma_2, 2+DD, me, gamma_0, cov_gamma_1)
                    gamma_2=gamma_2+gamma_t(:,t-1)
                    gamma_1=0.7*gamma_2+0.3*gamma_1
                end if
                IF (DD==1) THEN
                    IF (gamma_1(2+DD)>=0) EXIT
                ELSEIF (DD==2) THEN
                    IF ((gamma_1(1+DD)>=gamma_1(2+DD)) .and. (gamma_1(1+DD)>0) .and. (gamma_1(2+DD)>0)) EXIT
                END IF
            END DO
            gamma_2=gamma_T(:,t-1)



            Call OMP_SET_NUM_THREADS(Nthreads)
            !$omp parallel default(shared) private(g, NN, Y, X, XX, W, W_altru1, W_altru2, &
            !$omp & psi, psi_1, psi_2, ep_1, ep_2, S1, S2, INFO,   C, aa_1, aa_2, IPIV, q_1, q_2, &
            !$omp & kk, acc_0v, k, cov_aa, temp_aa, zero, d, pp, i, j, like_Y1, like_Y2, rand, rand1, &
            !$omp & cov_zz, temp_zz, zz_1, zz_2, demean_zz_1, demean_zz_2, &
            !$omp & ithread, iblock, ibegin, iend)

            ithread = OMP_GET_THREAD_NUM()
            iblock = (GG+Nthreads-1)/Nthreads
            ibegin = ithread*iblock+1
            iend = min((ithread+1)*iblock,GG)

            DO g = ibegin,iend

                NN=N(g)
                ALLOCATE(S1(NN,NN));       ALLOCATE(S2(NN,NN));
                ALLOCATE(Y(NN));
                ALLOCATE(X(NN));           ALLOCATE(XX(NN,2+2*DD)) ;
                ALLOCATE(W(NN,NN));
                ALLOCATE(W_altru1(NN,NN)); ALLOCATE(W_altru2(NN,NN))
                ALLOCATE(psi(NN,NN));
                ALLOCATE(psi_1(NN,NN));    ALLOCATE(psi_2(NN,NN))
                ALLOCATE(ep_1(NN));        ALLOCATE(ep_2(NN));
                ALLOCATE(C(NN,NN));
                ALLOCATE(aa_1(NN));        ALLOCATE(aa_2(NN))
                ALLOCATE(zz_1(NN,DD));     ALLOCATE(zz_2(NN,DD))
                ALLOCATE(demean_zz_1(NN,DD));
                ALLOCATE(demean_zz_2(NN,DD))
                ALLOCATE(IPIV(NN));

                W=W_raw(1:NN,1:NN,g)
                Y=Y_raw(1:NN,g)
                X=X_raw(1:NN,g)
                XX(:,1)=X
                XX(:,2)=matmul(W,X)
                zz_1=zz(1:NN,1:DD,g)
                zz_2=zz(1:NN,1:DD,g)

                C=C_raw(1:NN,1:NN,g)


                !***** update latent variable Z *****!

                psi=0.0
                DO i=1,NN
                    DO j=1,NN
                        IF (j/=i) THEN
                            psi(i,j)=gamma_T(1,t-1)+gamma_T(2,t-1)*C(i,j)
                        END IF
                    END DO
                END DO

                kk=NN
                kk=floor(kk/H1)
                IF (kk==0) kk=kk+1

                acc_0v=0.0
                DO k=1, kk
                    IF(k==kk) THEN
                        ALLOCATE(cov_zz(NN-(k-1)*H1,NN-(k-1)*H1))
                        ALLOCATE(temp_zz(NN-(k-1)*H1))
                        ALLOCATE(zero(NN-(k-1)*H1))
                        zero=0.0
                        cov_zz=EYE(NN-(k-1)*H1)*c_0z(g)
                        call spotrf('U',NN-(k-1)*H1, cov_zz, NN-(k-1)*H1, info)
                        DO d=1, DD
                            errcode=vsrnggaussianmv(method,stream, 1, temp_zz, NN-(k-1)*H1, me, zero, cov_zz)
                            zz_1((k-1)*H1+1:NN,d)=temp_zz+zz_2((k-1)*H1+1:NN,d)
                        END DO
                        DEALLOCATE(cov_zz)
                        DEALLOCATE(temp_zz)
                        DEALLOCATE(zero)
                    ELSE
                        ALLOCATE(cov_zz(H1,H1))
                        ALLOCATE(temp_zz(H1))
                        ALLOCATE(zero(H1))
                        zero=0.0
                        cov_zz=EYE(H1)*c_0z(g)
                        call spotrf('U',H1, cov_zz, H1, info)
                        DO d=1,DD
                            errcode=vsrnggaussianmv(method,stream, 1, temp_zz, H1, me, zero, cov_zz)
                            zz_1((k-1)*H1+1:k*H1,d)=temp_zz+zz_2((k-1)*H1+1:k*H1,d)
                        END DO
                        DEALLOCATE(cov_zz)
                        DEALLOCATE(temp_zz)
                        DEALLOCATE(zero)
                    END IF


                    W_altru1=0.0
                    psi_1=0.0
                    psi_2=0.0
                    pp=0.0
                    DO i=1,NN
                        DO j=1,NN
                            IF (j/=i) THEN
                                IF (DD==1) THEN
                                    psi_1(i,j)=psi(i,j)-gamma_T(3,t-1)*abs(zz_1(i,1)-zz_1(j,1))
                                    psi_2(i,j)=psi(i,j)-gamma_T(3,t-1)*abs(zz_2(i,1)-zz_2(j,1))
                                ELSE IF (DD==2) THEN
                                    psi_1(i,j)=psi(i,j)-gamma_T(3,t-1)*abs(zz_1(i,1)-zz_1(j,1))-gamma_T(4,t-1)*abs(zz_1(i,2)-zz_1(j,2))
                                    psi_2(i,j)=psi(i,j)-gamma_T(3,t-1)*abs(zz_2(i,1)-zz_2(j,1))-gamma_T(4,t-1)*abs(zz_2(i,2)-zz_2(j,2))
                                END IF
                                q_1=psi_1(i,j)*W(i,j)-log(1+exp(psi_1(i,j)))
                                q_2=psi_2(i,j)*W(i,j)-log(1+exp(psi_2(i,j)))
                                pp=pp+(q_1-q_2)
                            ENDIF
                        END DO
                    END DO

                    S1=eye(NN)-lambda_T(t-1)*W


                    XX(:,3)=zz_1(:,1)
                    XX(:,4)=matmul(W,zz_1(:,1))
                    ep_1=matmul(S1,Y)-matmul(XX,beta_T(:,t-1))-alpha_T(g,t-1)

                    XX(:,3)=zz_2(:,1)
                    XX(:,4)=matmul(W,zz_2(:,1))
                    ep_2=matmul(S1,Y)-matmul(XX,beta_T(:,t-1))-alpha_T(g,t-1)


                    like_Y1=-dot_product(ep_1, ep_1)/(2*sigma_T(t-1))
                    like_Y2=-dot_product(ep_2, ep_2)/(2*sigma_T(t-1))

                    IF (DD==1) THEN
                        demean_zz_1=zz_1-mu_zz(1,g);
                        demean_zz_2=zz_2-mu_zz(1,g);
                    ELSE IF (DD==2) THEN
                        demean_zz_1(1:NN,1)=zz_1(1:NN,1)-mu_zz(1,g);
                        demean_zz_2(1:NN,1)=zz_2(1:NN,1)-mu_zz(1,g);
                        demean_zz_1(1:NN,2)=zz_1(1:NN,2)-mu_zz(2,g);
                        demean_zz_2(1:NN,2)=zz_2(1:NN,2)-mu_zz(2,g);
                    ELSE IF (DD==3) THEN
                        demean_zz_1(1:NN,1)=zz_1(1:NN,1)-mu_zz(1,g);
                        demean_zz_2(1:NN,1)=zz_2(1:NN,1)-mu_zz(1,g);
                        demean_zz_1(1:NN,2)=zz_1(1:NN,2)-mu_zz(2,g);
                        demean_zz_2(1:NN,2)=zz_2(1:NN,2)-mu_zz(2,g);
                        demean_zz_1(1:NN,3)=zz_1(1:NN,3)-mu_zz(3,g);
                        demean_zz_2(1:NN,3)=zz_2(1:NN,3)-mu_zz(3,g);
                    END IF

                    IF (k==kk) THEN
                        pp=pp+(like_Y1-like_Y2)+logmvnpdf(reshape(demean_zz_1((k-1)*H1+1:NN,:),(/(NN-(k-1)*H1)*DD,1/)),eye((NN-(k-1)*H1)*DD),(NN-(k-1)*H1)*DD) &
                            & -logmvnpdf(reshape(demean_zz_2((k-1)*H1+1:NN,:),(/(NN-(k-1)*H1)*DD,1/)),eye((NN-(k-1)*H1)*DD),(NN-(k-1)*H1)*DD)
                    ELSE
                        pp=pp+(like_Y1-like_Y2)+logmvnpdf(reshape(demean_zz_1((k-1)*H1+1:k*H1,:),(/H1*DD,1/)),eye(H1*DD),H1*DD) &
                            & -logmvnpdf(reshape(demean_zz_2((k-1)*H1+1:k*H1,:),(/H1*DD,1/)),eye(H1*DD),H1*DD)
                    END IF

                    CALL random_number(rand)
                    IF (log(rand)<=pp) THEN
                        zz_2=zz_1
                        acc_0v=acc_0v+1
                    END IF
                    zz_1=zz_2
                END DO
                if (3*acc_0v>kk) acc_0z(g)=acc_0z(g)+1
                acc_rate0z(g,t)=acc_0z(g)/t
                if ((acc_rate0z(g,t)<0.2) .and. (c_0z(g)>=1e-6) )  c_0z(g)=c_0z(g)/1.01
                if ((acc_rate0z(g,t)>0.3) .and. (c_0z(g)<=1.0))  c_0z(g)=c_0z(g)*1.01
                zz(1:NN,1:DD,g)=zz_1


                !***** UPDATE mu_zz *****!


                IF (DD==1) THEN
                    errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                    mu_zz(1,g)=sum(zz_1(:,1))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
                ELSE IF (DD==2) THEN
                    errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                    mu_zz(1,g)=sum(zz_1(:,1))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
                    errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                    mu_zz(2,g)=sum(zz_1(:,2))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
                ELSE IF (DD==3) THEN
                    errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                    mu_zz(1,g)=sum(zz_1(:,1))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
                    errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                    mu_zz(2,g)=sum(zz_1(:,2))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
                    errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                    mu_zz(3,g)=sum(zz_1(:,3))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
                END IF

                !***** THE M-H ALGORITHM FOR SAMPLING GAMMA & LAMBDA ******!

                pp=0.0
                psi_1=0.0
                psi_2=0.0
                DO i=1,NN
                    DO j=1, NN
                        IF (j/=i) THEN
                            IF (DD==1) THEN
                                psi_1(i,j)=gamma_1(1)+gamma_1(2)*C(i,j)-gamma_1(3)*abs(zz_1(i,1)-zz_1(j,1))
                                psi_2(i,j)=gamma_2(1)+gamma_2(2)*C(i,j)-gamma_2(3)*abs(zz_1(i,1)-zz_1(j,1))
                            ELSEIF (DD==2) THEN
                                psi_1(i,j)=gamma_1(1)+gamma_1(2)*C(i,j)-gamma_1(3)*abs(zz_1(i,1)-zz_1(j,1))-gamma_1(4)*abs(zz_1(i,2)-zz_1(j,2))
                                psi_2(i,j)=gamma_2(1)+gamma_2(2)*C(i,j)-gamma_2(3)*abs(zz_1(i,1)-zz_1(j,1))-gamma_2(4)*abs(zz_1(i,2)-zz_1(j,2))
                            END IF
                            q_1=psi_1(i,j)*W(i,j)-log(1+exp(psi_1(i,j)))
                            q_2=psi_2(i,j)*W(i,j)-log(1+exp(psi_2(i,j)))
                            pp=pp+(q_1-q_2)
                        ENDIF
                    END DO
                END DO

                pp_G(g)=pp

                S1=eye(NN)-lambda_1*W
                S2=eye(NN)-lambda_T(t-1)*W
                XX(:,3)=zz_1(:,1)
                XX(:,4)=matmul(W,zz_1(:,1))
                ep_1=matmul(S1,Y)-matmul(XX,beta_T(:,t-1))-alpha_T(g,t-1)
                ep_2=matmul(S2,Y)-matmul(XX,beta_T(:,t-1))-alpha_T(g,t-1)

                like_Y1=log(FindDet(S1,NN))-dot_product(ep_1, ep_1)/(2*sigma_T(t-1))
                like_Y2=log(FindDet(S2,NN))-dot_product(ep_2, ep_2)/(2*sigma_T(t-1))
                pp_l(g)=(like_Y1-like_Y2)

                DEALLOCATE(S1,S2,Y,X,XX,W,W_altru1,W_altru2,psi,psi_1,psi_2,ep_1,ep_2,C,aa_1,aa_2,zz_1,zz_2,demean_zz_1,demean_zz_2,IPIV)
            END DO
            !$omp end parallel

            pp=sum(pp_G)+logmvnpdf(gamma_1, G_0, 2+DD)-logmvnpdf(gamma_2, G_0, 2+DD)

            CALL random_number(rand)
            IF (log(rand)<=pp) THEN
                gamma_T(:,t)=gamma_1
                acc_1=acc_1+1.0
            ELSE
                gamma_T(:,t)=gamma_T(:,t-1)
            ENDIF
            acc_rate1(t)=acc_1/t

            pp=sum(pp_l)

            CALL random_number(rand)
            IF (log(rand)<=pp) THEN
                lambda_T(t)=lambda_1
                acc_2=acc_2+1.0
            ELSE
                lambda_T(t)=lambda_T(t-1)
            END IF
            acc_rate2(t)=acc_2/t




            !***************GIBBS STEP TO SIMULTE BETA *********************!

            XVX=0.0
            XVY=0.0

            Call OMP_SET_NUM_THREADS(Nthreads)
            !$omp parallel default(shared) private(g,NN, Y, YY, W, W_altru, &
            !$omp & X, XX, XX2, S, V, V1, V2, aa_1, zz_1, IPIV, INFO, i, j, &
            !$omp & ithread, iblock, ibegin, iend)

            ithread = OMP_GET_THREAD_NUM()
            iblock = (GG+Nthreads-1)/Nthreads
            ibegin = ithread*iblock+1
            iend = min((ithread+1)*iblock,GG)

            DO g = ibegin,iend

                NN=N(g)
                ALLOCATE(Y(NN));        ALLOCATE(YY(NN))
                ALLOCATE(X(NN)) ;
                ALLOCATE(XX(NN,2+2*DD));ALLOCATE(XX2(NN,2+2*DD)) ;
                ALLOCATE(W(NN,NN));
                ALLOCATE(W_altru(NN,NN));
                ALLOCATE(S(NN,NN));
                ALLOCATE(V(NN,NN));
                ALLOCATE(V1(NN,NN)); ALLOCATE(V2(NN,NN))
                ALLOCATE(aa_1(NN))
                ALLOCATE(zz_1(NN,DD))
                ALLOCATE(IPIV(NN))

                V=sigma_T(t-1)*EYE(NN)
                W=W_raw(1:NN,1:NN,g)
                Y=Y_raw(1:NN,g)
                X=X_raw(1:NN,g)
                zz_1=zz(1:NN,1:DD,g)
                XX(:,1)=X
                XX(:,2)=matmul(W,X)
                XX(:,3)=zz_1(:,1)
                XX(:,4)=matmul(W,zz_1(:,1))
                

                S=eye(NN)-lambda_T(t)*W

                XX2=XX
                V1=V
                CALL SGESV(NN,2+2*DD,V1,NN,IPIV,XX2,NN,INFO)
                YY=matmul(S,Y)-lambda_T(3,t)*sum(W_altru,2)-alpha_T(g,t-1)
                V2=V
                CALL SGESV(NN,1,V2,NN,IPIV,YY,NN,INFO)

                XVX(:,:,g)=matmul(transpose(XX) , XX2)
                XVY(:,g)=matmul(transpose(XX) , YY)

                DEALLOCATE(Y,YY,X,XX,XX2,W,W_altru,S,V,V1,V2,aa_1,zz_1,IPIV)
            END DO
            !$omp end parallel

            CALL FINDInv(sum(XVX,3)+INV_B_0,INV_B,2+2*DD,ier)
            INV_B2=INV_B
            CALL spotrf('U',2+2*DD, INV_B2, 2+2*DD, info)
            errcode=vsrnggaussianmv(method, stream, 1, beta_temp, 2+2*DD, me, beta_0,  INV_B2)
            beta_T(:,t)=beta_temp+matmul(INV_B,sum(XVY,2))



            !*************GIBBS STEP FOR sigma*********************!

            rho_1=0
            ALLOCATE(ep_v(sum(N)))
            stack=0
            DO g=1,GG
                NN=N(G)
                ALLOCATE(Y(NN))
                ALLOCATE(X(NN))
                ALLOCATE(XX(NN,2+2*DD))
                ALLOCATE(W(NN,NN))
                ALLOCATE(aa_1(NN))
                ALLOCATE(zz_1(NN,DD))
                ALLOCATE(W_altru(NN,NN))
                ALLOCATE(S(NN,NN))
                ALLOCATE(ep(NN))

                W=W_raw(1:NN,1:NN,g)
                Y=Y_raw(1:NN,g)
                X=X_raw(1:NN,g)                
                zz_1=zz(1:NN,1:DD,g)
                XX(:,1)=X
                XX(:,2)=matmul(W,X)
                XX(:,3)=zz_1(:,1)
                XX(:,4)=matmul(W,zz_1(:,1))
               

                S=eye(NN)-lambda_T(t)*W

                ep=matmul(S,Y)-matmul(XX,beta_T(:,t))-alpha_T(g,t-1)
                ep_v(stack+1:stack+NN)=ep
                rho_1=rho_1+NN
                stack=stack+NN
                DEALLOCATE(Y,X,XX,W,aa_1,zz_1,W_altru,S,ep)
            END DO
            sigma_T(t)=(dot_product(ep_v,ep_v)+eta_0)/random_chisq(rho_1+rho_0, first)
            DEALLOCATE(ep_v)


            !*************GIBBS STEP FOR ALPHA_G*********************!
            
            
            Call OMP_SET_NUM_THREADS(Nthreads)
            !$omp parallel default(shared) private(g,NN, Y, YY, &
            !$omp & X, XX, W, W_altru, S, aa_1, zz_1, IPIV, R_g, i,j, &
            !$omp & ithread, iblock, ibegin, iend)
            
            ithread = OMP_GET_THREAD_NUM()
            iblock = (GG+Nthreads-1)/Nthreads
            ibegin = ithread*iblock+1
            iend = min((ithread+1)*iblock,GG)
            
            DO g = ibegin,iend
            
                NN=N(g)
                ALLOCATE(Y(NN));
                ALLOCATE(YY(NN));
                ALLOCATE(X(NN))
                ALLOCATE(XX(NN,2+2*DD))
                ALLOCATE(W(NN,NN));
                ALLOCATE(W_altru(NN,NN));
                ALLOCATE(S(NN,NN));
                ALLOCATE(aa_1(NN))
                ALLOCATE(zz_1(NN,DD))
            
                R_g=(ALPHA_0**(-1)+sigma_T(t)**(-1.0)*NN)**(-1.0)
                W=W_raw(1:NN,1:NN,g)
                Y=Y_raw(1:NN,g)
                X=X_raw(1:NN,g)
                zz_1=zz(1:NN,1:DD,g)
                XX(:,1)=X
                XX(:,2)=matmul(W,X)
                XX(:,3)=zz_1(:,1)
                XX(:,4)=matmul(W,zz_1(:,1))
                

            
            
                S=eye(NN)-lambda_T(t)*W
            
                YY=matmul(S,Y)
                alpha_T(g,t)=R_g*(ALPHA_0**(-1)*a_0+(sigma_T(t))**(-1.0)*sum((YY-lambda_T(3,t)*sum(W_altru,2)-matmul(XX,beta_T(:,t)))))+random_normal()*sqrt(R_g)
            
                DEALLOCATE(Y,YY,X,XX,W,W_altru,S,aa_1,zz_1)
            END DO
            !$omp end parallel



            call system_clock ( clock_stop, clock_rate, clock_max )
            t_round=t/100
            IF (t-t_round*100==0) THEN
                WRITE(*,*)   'T=', t
                WRITE(*,'(a6, f7.4)') 'Time:', real ( clock_stop - clock_start ) / real ( clock_rate )
                WRITE(*,'(a6,5f7.4)') 'GAMMA:',  gamma_T(:,t)
                WRITE(*,'(a6, f7.4)') 'LAMBDA:', lambda_T(t)
                WRITE(*,'(a6,6f7.4)') 'BETA:', beta_T(:,t)
                WRITE(*,'(a6,f7.4)') 'SIGMA:',  sigma_T(t)
                WRITE(*,'(a10,3f10.4)') 'acc_0a:',  acc_rate0a(1,t), acc_rate0a(11,t), acc_rate0a(21,t)
            	WRITE(*,'(a10,3f10.4)') 'acc_0z:',  acc_rate0z(1,t), acc_rate0z(11,t), acc_rate0z(31,t)
            	WRITE(*,'(a10,f10.4)') 'acc_1:',  acc_rate1(t)
            	WRITE(*,'(a10,f10.4)') 'acc_2:',  acc_rate2(t)
            	WRITE(*,'(a10,7f10.6)') 'c_0a:', c_0a(1),c_0a(11),c_0a(21)
            	WRITE(*,'(a10,7f10.6)') 'c_0z:', c_0z(1),c_0z(11),c_0z(21)
            END IF

             

        END DO
        !close(10000)
        !close(20000)
        !close(30000)

        gamma_R(:,r)=sum(gamma_T(:,5001:TT),2)/(TT-5000) 
        lambda_R(r)=sum(lambda_T(5001:TT))/(TT-5000)
        beta_R(:,r)=sum(beta_T(:,5001:TT),2)/(TT-5000)
        sigma_R(r)=sum(sigma_T(5001:TT))/(TT-5000)

        WRITE(30000,'(5f7.4)')    gamma_R(:,r) 
        WRITE(40000,'(f7.4)')    lambda_R(r)
        WRITE(50000,'(6f7.4)')    beta_R(:,r)
        WRITE(60000,'(f7.4)')     sigma_R(r)
    END DO
    
    close(30000)
    close(40000)
    close(50000)
    close(60000)


    END PROGRAM estimation



