    include 'mkl_vsl.f90'

    program DGP_GIBBS_INDEP

    USE random
    USE TOOL
    USE lapack95
    USE MKL_VSL_TYPE
    USE MKL_VSL
    IMPLICIT NONE


    !******************* GENERAL VARIABLES ****************!
    CHARACTER(100)          :: path1='D:/research/social_preference_and_social_interaction/'
    CHARACTER(100)          :: path2='/simulation/data/'
    CHARACTER(40)           :: numchr1, numchr2
    INTEGER, PARAMETER      :: NN1=50, NN2=50, NN3=50, GG=30, RR=100, DD=1, Nthreads=12
    REAL, ALLOCATABLE       :: C(:,:), W(:,:), W_altru(:,:), X(:), Y(:), E(:),  Z(:,:), zero(:), C1(:), Iden(:,:), IPIV(:), gamma(:), sigma(:,:)
    REAL                    :: beta(4), lambda(3), rho, eta, siga, alpha, kappa, rand
    INTEGER                 :: NN, clock_max, clock_rate, clock_start, clock_stop
    INTEGER                 :: brng, method, me, i, j, g, t, flag, ier, r, m, seedsize, seed(2), errorflag, INFO, seed_mkl
    LOGICAL, PARAMETER      :: first=.true.
    TYPE (VSL_STREAM_STATE) :: stream
    INTEGER                 ::  errcode

    !*******************************************************!
    REAL, ALLOCATABLE   :: cov_x(:,:), temp_X(:), altruism(:)
    REAL, ALLOCATABLE   :: psi(:,:), XX(:,:), h(:), S(:,:), Y_new(:), cov_e(:,:), temp_e(:), mu(:)
    REAL                :: pp, w1, w2, w3, w4


    seedsize=2
    seed(1)=12345
    seed(2)=12345
    CALL RANDOM_SEED
    CALL RANDOM_SEED(SIZE=seedsize)
    CALL RANDOM_SEED(PUT=seed)
    seed_mkl=12345
    brng=VSL_BRNG_MCG31
    method=VSL_RNG_METHOD_GAUSSIANMV_BOXMULLER
    me=VSL_MATRIX_STORAGE_FULL

    errcode=vslnewstream(stream,brng,seed_mkl) 


    !******* Parameters **********!
    ALLOCATE(gamma(DD+4))
    ALLOCATE(sigma(DD+1,DD+1))
    ALLOCATE(cov_e(DD+1,DD+1))
    ALLOCATE(temp_e(DD+1))
    ALLOCATE(mu(DD+1)) 

    beta=(/0.5,0.2,0.5,0.2/)
    IF (DD==1) THEN
        gamma=(/-1.2, 3.0, 0.3, 0.3, 3.0/)
        sigma(1,1)=1.0
        sigma(1,2)=0.0
        sigma(2,1)=0.0
        sigma(2,2)=1.0   
    ELSEIF (DD==2) THEN
        gamma=(/1.5, 1.0, 0.3, 0.3, 2.0, 1.0/)
        sigma(1,1)=0.5
        sigma(1,2)=0.0
        sigma(1,3)=1.0
        sigma(2,1)=0.0
        sigma(2,2)=4.0
        sigma(2,3)=0.0
        sigma(3,1)=1.0
        sigma(3,2)=0.0
        sigma(3,3)=4.0
    END IF 
    siga=1.0
    lambda=(/ 0.05, 0.04, -0.20 /)
    mu=0.0
    !***************************!


    call system_clock ( clock_start, clock_rate, clock_max )  


    Do r=1, RR
        print*, r
        !Call OMP_SET_NUM_THREADS(Nthreads)
        !omp parallel default(shared) private( g, NN, C, W, X, Y, E, Z, zero, C1, Iden, IPIV, psi, XX, h,  &
        !omp & S, Y_new, cov_x, temp_X, i, j, cov_e, INFO, temp_e, altruism, W_altru, & 
        !omp & m, w1, w2, w3, w4, pp, rand, alpha, numchr1, numchr2)
        !omp do 
        Do g=1,GG

            IF (g<=10) THEN
                NN=NN1
            ELSEIF ((g>10) .and. (g<=20) ) THEN
                NN=NN2
            ELSEIF (g>20) THEN
                NN=NN3
            END IF
            ALLOCATE(C(NN,NN));      ALLOCATE(W(NN,NN))
            ALLOCATE(X(NN));         ALLOCATE(Y(NN))
            ALLOCATE(E(NN));         ALLOCATE(Z(NN,DD))
            ALLOCATE(zero(NN));      ALLOCATE(C1(NN))
            ALLOCATE(Iden(NN,NN));   ALLOCATE(IPIV(NN))
            ALLOCATE(psi(NN,NN));    ALLOCATE(XX(NN,4))
            ALLOCATE(h(NN));         ALLOCATE(S(NN,NN))
            ALLOCATE(Y_new(NN));     ALLOCATE(cov_x(NN,NN))
            ALLOCATE(temp_X(NN))
            ALLOCATE(altruism(NN))
            ALLOCATE(W_altru(NN,NN))

            CALL random_number(C1) 
            C=0.0
            do i=1,NN
                do j=1,NN
                    if((C1(i)>=0.7) .and. (C1(j)>=0.7)) C(i,j)=1.0
                    if((C1(i)<0.3) .and. (C1(j)<0.3)) C(i,j)=1.0                
                end do
                C(i,i)=0.0
                cov_e=sigma
                call spotrf('U', DD+1, cov_e, DD+1,INFO)
                errcode=vsrnggaussianmv(method,stream,1, temp_e, DD+1, me, mu, cov_e) 
                E(i)  =temp_e(1)
                IF (DD==1) THEN
                    Z(i,1)=temp_e(2) 
                ELSEIF (DD==2) THEN
                    Z(i,1)=temp_e(2) 
                    Z(i,2)=temp_e(3) 
                ELSEIF (DD==3) THEN
                    Z(i,1)=temp_e(2) 
                    Z(i,2)=temp_e(3) 
                    Z(i,3)=temp_e(4) 
                END IF
            end do         

            W=0.0 
            DO i=1, NN
                DO j=1, NN
                    if (j/=i) THEN
                        IF (DD==1) THEN
                            psi(i,j)=gamma(1)+gamma(2)*C(i,j)-gamma(5)*abs(Z(i,1)-Z(j,1))
                        ELSEIF (DD==2) THEN
                            psi(i,j)=gamma(1)+gamma(2)*C(i,j)-gamma(5)*abs(Z(i,1)-Z(j,1))-gamma(6)*abs(Z(i,2)-Z(j,2))
                        END IF

                        pp=exp(psi(i,j))/(1+exp(psi(i,j)))
                        CALL random_number(rand)        
                        IF (rand<=pp)  THEN
                            W(i,j)=1.0
                        ELSE
                            W(i,j)=0.0
                        END IF
                    END IF 
                END DO
            END DO        
            
            W_altru=transpose(W)

            Iden=eye(NN) 
            zero=0.0
            cov_x=Iden*2.0
            call spotrf('U',NN, cov_x,NN,INFO)
            errcode=vsrnggaussianmv(method,stream,1,temp_X,NN,me, zero, cov_x) 

            CALL random_number(rand)  
            XX=0.0
            X=temp_X
            XX(:,1)=X
            XX(:,2)=matmul(W,X)
            XX(:,3)=Z(:,1)
            XX(:,4)=matmul(W,Z(:,1))
            alpha=random_normal()*sqrt(siga) 
            h=lambda(3)*sum(W_altru,2)+matmul(XX,beta)+alpha+E
            
            S=eye(NN)-lambda(1)*W-lambda(2)*W_altru
            Y_new=h
            CALL SGESV(NN,1,S,NN,IPIV,Y_new,NN,INFO)

            Y=Y_new

            print*, maxval(sum(W, dim=2)), maxval(sum(W_altru, dim=2)), sum(sum(W_altru, dim=2))/NN, &
              & corr(matmul(W,Y),sum(W_altru, dim=2),NN),  corr(matmul(W_altru,Y),matmul(W,Y),NN), corr(matmul(W_altru,Y),sum(W_altru, dim=2),NN) 
            WRITE(numchr1,*) r
            WRITE(numchr2,*) g
            OPEN (10000+100*r+g, file = trim(adjustl(path1))  // trim(adjustl(path2))  // 'R' // trim(adjustl(numchr1)) // '/C/C'  //  trim(adjustl(numchr2)) // '.txt', status='unknown') 
            OPEN (20000+100*r+g, file = trim(adjustl(path1))  // trim(adjustl(path2))  // 'R' // trim(adjustl(numchr1)) // '/W/W' //  trim(adjustl(numchr2)) //  '.txt', status='unknown') 
            OPEN (30000+100*r+g, file = trim(adjustl(path1))  // trim(adjustl(path2))  // 'R' // trim(adjustl(numchr1)) // '/X/X'  //  trim(adjustl(numchr2))  // '.txt', status='unknown') 
            OPEN (40000+100*r+g, file = trim(adjustl(path1))  // trim(adjustl(path2))  // 'R' // trim(adjustl(numchr1)) // '/Y/Y' //  trim(adjustl(numchr2))   // '.txt', status='unknown') 

            write(30000+100*r+g,300) (X(i), i=1,NN)
            write(40000+100*r+g,400) (Y(i), i=1,NN)

            IF(NN==20) THEN
                write(10000+100*r+g,'(20f6.2)') ((C(i,j),j=1,NN),i=1,NN) 
                write(20000+100*r+g,'(20f6.2)') ((W(i,j),j=1,NN),i=1,NN)
            ELSEIF (NN==30) THEN
                write(10000+100*r+g,'(30f6.2)') ((C(i,j),j=1,NN),i=1,NN) 
                write(20000+100*r+g,'(30f6.2)') ((W(i,j),j=1,NN),i=1,NN)
            ELSEIF (NN==40) THEN     
                write(10000+100*r+g,'(40f6.2)') ((C(i,j),j=1,NN),i=1,NN) 
                write(20000+100*r+g,'(40f6.2)') ((W(i,j),j=1,NN),i=1,NN)
            ELSEIF (NN==50) THEN     
                write(10000+100*r+g,'(50f6.2)') ((C(i,j),j=1,NN),i=1,NN) 
                write(20000+100*r+g,'(50f6.2)') ((W(i,j),j=1,NN),i=1,NN)
            END IF 

            close(10000+100*r+g)
            close(20000+100*r+g)
            close(30000+100*r+g)
            close(40000+100*r+g)

            DEALLOCATE(C);      DEALLOCATE(W)
            DEALLOCATE(X);      DEALLOCATE(Y)
            DEALLOCATE(E);      DEALLOCATE(Z)
            DEALLOCATE(zero);   DEALLOCATE(C1)
            DEALLOCATE(Iden);   DEALLOCATE(IPIV)
            DEALLOCATE(psi);    DEALLOCATE(XX)
            DEALLOCATE(h);      DEALLOCATE(S)
            DEALLOCATE(Y_new);  DEALLOCATE(cov_x)
            DEALLOCATE(temp_X)
            DEALLOCATE(altruism)
            DEALLOCATE(W_altru)
        END DO 
        !omp end  do
        !omp end parallel
    END DO

    call system_clock ( clock_stop, clock_rate, clock_max )
    print*, 'Time:', real ( clock_stop - clock_start ) / real ( clock_rate )   
    


    DEALLOCATE(gamma)
    DEALLOCATE(sigma)
    DEALLOCATE(cov_e)
    DEALLOCATE(temp_e)
    DEALLOCATE(mu) 
    pause

100 format (30F6.2)    
200 format (30F6.2)
300 format (1F12.5)
400 format (1F12.5) 

    end program DGP_GIBBS_INDEP

