    INCLUDE 'mkl_vsl.f90'
    !INCLUDE 'link_fnl_static.h'
    !!DEC$ OBJCOMMENT LIB:'libiomp5md.lib'

    PROGRAM estimation

    USE random
    USE TOOL
    USE lapack95
    USE MKL_VSL_TYPE
    USE MKL_VSL
    !USE LFDRG_INT
    !USE LFTRG_INT
    !USE UMACH_INT
    USE omp_lib
    IMPLICIT NONE


    !****************** GENERAL VARIABLES ****************!
    CHARACTER(100) :: path1='/home/research/social_preference_and_social_interaction/empirical/'
    CHARACTER(100) :: path2='/data/'
    CHARACTER(100) :: path3='/result/social_preference/'
    INTEGER, PARAMETER :: GG=24, TT=50000, MAX=300, THIN=100, Nthreads=125, H=5, H1=5, burn=5000, dep=15, DD=4
    REAL, PARAMETER    :: pi=3.14159265
    REAL               :: c_0a(GG), c_0z(GG), c_1, c_2, c_3, acc_1, acc_2, rand, rand1(1), acc_4, acc_3(GG), acc_0v, acc_0a(GG), acc_0z(GG), kk, AICM
    INTEGER            :: NN, N(GG),  k, censor(GG), flag(GG)
    INTEGER            :: brng, method, me, i, j, g, t, d, ier,  r, seedsize, seed(2), errorflag, INFO, seed_mkl, t_round
    INTEGER            :: clock_max, clock_rate, clock_start, clock_stop, ithread, iblock,ibegin,iend
    REAL, DIMENSION(MAX,MAX,GG):: age, sex, race, network
    REAL, DIMENSION(MAX,16,GG):: group
    REAL, ALLOCATABLE:: C1(:,:), C2(:,:), C3(:,:), W(:,:), Wt(:,:), W_altru(:,:), W_altru1(:,:), W_altru2(:,:), IPIV(:), Y(:), X(:,:), FACT(:,:)
    REAL                 :: DET1, DET2
    REAL(kind=8)         :: pp
    INTEGER, ALLOCATABLE :: INDX(:), p_dim(:), IPVT(:)
    INTEGER              ::  errcode, CODE, DD1, DD2, SEED_PERM
    LOGICAL              :: first=.true.
    TYPE (VSL_STREAM_STATE) :: stream


    !*** hyperparameters in the prior distribution ***!
    REAL, DIMENSION(5+DD)         :: gamma_0
    REAL, DIMENSION(30+2*DD)      :: beta_0
    REAL, DIMENSION(5+DD,5+DD)    :: G_0
    REAL, DIMENSION(30+2*DD,30+2*DD) :: B_0, INV_B_0
    REAL                          :: sigma_0, Sig_0, a_0, eta_0, ALPHA_0
    INTEGER                       :: rho_0

    !*** posterior draws of parameters *******!

    REAL, DIMENSION(GG,TT)         :: gamma_0T
    REAL, DIMENSION(5+DD,TT)       :: gamma_T
    REAL, DIMENSION(3,TT)          :: lambda_T
    REAL, DIMENSION(TT)            :: acc_rate1, acc_rate2
    REAL(kind=8), DIMENSION(TT)    :: logp_T
    REAL, DIMENSION(30+2*DD, TT)   :: beta_T
    REAL, DIMENSION(TT)            :: sigma_T
    REAL, DIMENSION(GG,TT)         :: alpha_T
    REAL, DIMENSION(GG,TT)         :: acc_rate0a, acc_rate0z, acc_rate3
    REAL, DIMENSION(MAX,GG,TT/THIN):: aa_TT

    !******  VARIABLE IN M-H FOR A_G  *******************************!

    REAL, DIMENSION(MAX,GG) :: aa, aa_mean, aa_temp, aa_var, a_temp2
    REAL, ALLOCATABLE       :: aa_1(:), aa_2(:), cov_aa(:,:), temp_aa(:)

    !******  VARIABLE IN M-H FOR Z_G  *******************************!

    REAL, DIMENSION(MAX,DD,GG) :: zz
    REAL, DIMENSION(DD,GG) :: mu_zz
    REAL, ALLOCATABLE  :: zz_1(:,:), zz_2(:,:), cov_zz(:,:), temp_zz(:), demean_zz_1(:,:), demean_zz_2(:,:)

    !*****************************************************************!

    REAL, ALLOCATABLE  :: V1(:,:), V2(:,:), V(:,:), S1(:,:), S2(:,:), XX(:,:)
    REAL, ALLOCATABLE  :: psi(:,:), psi_1(:,:), psi_2(:,:), zero(:)
    REAL, ALLOCATABLE  :: ep(:), ep_1(:), ep_2(:)
    REAL, ALLOCATABLE  :: ep_1v(:), ep_2v(:)
    REAL(kind=8)       :: q_1, q_2, like_Y1, like_Y2, pp_w, q

    !********VARIABLE IN M-H FOR GAMMA & LAMBDA   ***************!

    REAL      :: lambda_1(3), lambda_2(3), lambda_0(3), COV_lambda_1(3,3)
    REAL      :: gamma_01, gamma_02, COV_gamma_01
    REAL      :: gamma_1(5+DD), gamma_2(5+DD), COV_gamma_1(5+DD,5+DD)
    REAL(kind=8)  :: pp_l(GG), pp_G(GG), pp_sig(GG)

    !*************VARIABLE IN M-H FOR BETA **************!

    REAL :: XVX(30+2*DD,30+2*DD,GG), XVY(30+2*DD,GG), INV_B(30+2*DD,30+2*DD), INV_B2(30+2*DD,30+2*DD), beta_temp(30+2*DD)
    REAL, ALLOCATABLE ::  XX2(:,:), YY(:), S(:,:)

    !*************VARIABLE IN M-H FOR SIGMA_E & SIGMA_EZ & ALPHA_G**************!

    REAL              :: R_g, sigma_1
    REAL, ALLOCATABLE :: ep_v(:)
    INTEGER           :: rho_1, stack

    !*******************************************************************************************************!

    INTEGER :: N_1, N_2, T_1, T_2

    !*******************************************************************************************************!

100 format (14f10.4)
200 format (4f10.4)

    seedsize=2
    seed(1)=2.1103e+005
    seed(2)=2.1103e+005
    CALL RANDOM_SEED
    CALL RANDOM_SEED(SIZE=seedsize)
    CALL RANDOM_SEED(PUT=seed)

    seed_mkl=12345
    brng=VSL_BRNG_MCG31
    method=VSL_RNG_METHOD_GAUSSIANMV_BOXMULLER
    me=VSL_MATRIX_STORAGE_FULL

    errcode=vslnewstream(stream,brng,seed_mkl)

    CALL networksize(GG, MAX, path1, path2, N)
    CALL define_variable(GG, age, sex, race, network, group, N, path1, path2, MAX)

    aa=0.0
    zz=0.0
    mu_zz=0.0
    lambda_0=0.0
    gamma_0=0.0
    beta_0=0.0
    sigma_0=0.0
    eta_0=0.1
    rho_0=2
    G_0=eye(5+DD)*100.0
    B_0=eye(30+2*DD)*10.0
    Sig_0=100.0
    CALL FINDInv(B_0,INV_B_0,30+2*DD,ier)
    ALPHA_0=400.0
    a_0=0.0
    censor=0

    c_0a=0.08
    c_0z=1e-2
    c_3=0.1
    acc_1=0.0;acc_2=0.0;acc_3=0
    acc_0a=0.0
    acc_0z=0.0
    acc_rate0a=0.0
    acc_rate0z=0.0
    acc_rate1=0.0
    acc_rate2=0.0
    acc_rate3=0.0


    DO g = 1, GG
        NN=N(g)
        ALLOCATE(W(NN,NN))
        ALLOCATE(Wt(NN,NN))
        W=network(1:NN,1:NN,g)
        Wt=transpose(W)
        DO i=1,NN
            IF (sum(Wt(i,:))>0) aa(i,g)=0.5
            IF (sum(Wt(i,:))==0) aa(i,g)=-0.5
        END DO
        DEALLOCATE(W,Wt)
    END DO

    ! initial value of the draws !
    gamma_0T(:,1)= &
        & (/  -0.1744  ,  0.8588 ,  -0.8953 ,  -0.7872 ,  -0.6963 ,  -1.5372 ,  -1.6731 ,  -1.7438  , -1.5513 ,  -3.0631 ,  -1.6703  , -1.8387 ,  -2.0411 ,  -4.2184 ,  -2.3705  , -2.6336  , -3.0048  , -4.2698  , -2.8882 , &
        &     -2.7322  , -2.6322 ,  -2.8929 ,  -2.8674 ,  -2.8548  /)

    !gamma_0T(:,1)= &
    !(/  1.3568 ,   0.6109 ,   1.0561 ,  -0.3480 ,  -0.6582 ,  -0.6785 ,  -0.4832 ,  -0.3634 ,  -2.1828 ,  -0.9438 ,  -0.8774 ,  -1.2934 ,  -3.2228 ,  -1.8510 ,  -1.8966 ,  -3.4801 ,  &
    !&  -1.8845 ,  -1.4533 ,  -1.7361 ,  -1.8226 ,  -1.9892 ,  -1.8336 ,  -1.7420 ,  -1.9349 ,  -2.0791 ,  -4.6526 ,  -1.9336 ,  -2.9014 ,  -2.2107 ,  -2.8046 ,  -2.6123 ,  -2.3770 ,  &
    !&  -1.8533 ,  -2.8754 /)   !DD=2!

    !gamma_0T(:,1)= &
    !& (/   2.8458  ,  1.2791 ,   0.6654  , -0.1829 ,  -0.6105 ,  -0.9920 ,  -0.7429 ,  -1.0725 ,  -1.3920 ,  -0.8237 ,  -0.6219 ,  -1.1863 ,  -2.3061 ,  -1.6605 ,  -1.5666 ,  -2.8919 ,  &
    !&   -1.6721  , -1.3504 ,  -1.7166  , -1.7647 ,  -2.0613 ,  -1.8532 ,  -1.5290 ,  -2.1145 ,  -1.9974 ,  -3.7588 ,  -2.0601 ,  -2.5218 ,  -2.2214 ,  -2.4695 ,  -2.2704 ,  -2.2910 ,  &
    !&   -1.8067  , -2.3319 /)   !DD=3!

    !gamma_T(:,1)=(/   0.7991 ,  0.3470  , 0.2203 ,  0.9003 ,  1.2923  , 3.5859   /) !DD=1!
    !gamma_T(:,1)=(/  0.7991  ,  0.3989   , 1.0230  , 0.5, 0.5, 2.5138  ,  2.4392   /) !DD=2!
    !gamma_T(:,1)=(/  0.7756  , 0.3876  , 0.5453 ,  0.0529  , 1.2794 ,  2.9272 ,  2.5622  , 2.5046   /) !DD=3!
    gamma_T(:,1)=(/  0.7589  ,  0.3617  ,  0.5157 ,  -0.1689  ,  1.4115  ,  2.8694  ,  2.5378 ,   2.4313  ,  2.2299 /) !DD=4!
    beta_T(:,1)=0.0
    sigma_T(1)=0.4
    lambda_T(:,1)=(/ 0.0504, 0.5260, -0.1436 /)

    OPEN (1001, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'gamma0.txt', status='unknown')
    OPEN (1000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'gamma.txt', status='unknown')
    OPEN (2000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'lambda.txt', status='unknown')
    OPEN (3000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'beta.txt', status='unknown')
    OPEN (4000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'sigma.txt', status='unknown')
    OPEN (5000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'latent_a.txt', status='replace')
    OPEN (6000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'alpha.txt', status='unknown')
    OPEN (8000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'aa.txt', status='unknown')
    OPEN (9000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'logp.txt', status='unknown')


    DO t=2, TT

        call system_clock ( clock_start, clock_rate, clock_max )

        DO
            COV_lambda_1=EYE(3)*1e-4/2.0
            call spotrf('U',3, COV_lambda_1, 3, info)
            errcode=vsrnggaussianmv(method,stream,1,lambda_1, 3, me, lambda_0, COV_lambda_1)
            lambda_1=lambda_1+lambda_T(:,t-1)
            IF (t>100) THEN
                COV_lambda_1=cov(lambda_T(:,1:t-1),3,t-1)*2.38**2/3.0
                call spotrf('U',3, COV_lambda_1, 3, info)
                errcode=vsrnggaussianmv(method,stream,1,lambda_2, 3, me, lambda_0, COV_lambda_1)
                lambda_2=lambda_2+lambda_T(:,t-1)
                lambda_1=0.50*lambda_2+0.50*lambda_1
            END IF
            IF (abs(lambda_1(1)<=0.1) .and. (lambda_1(2)<=1.0) .and. (lambda_1(2)>=0.0)) EXIT
        END DO
        DO
            COV_gamma_1=EYE(5+DD)*1e-5
            call spotrf('U',5+DD, COV_gamma_1, 5+DD, info)
            errcode=vsrnggaussianmv(method,stream,1,gamma_1, 5+DD, me, gamma_0, COV_gamma_1)
            gamma_1=gamma_1+gamma_T(:,t-1)
            if (t>2*5+DD) then
                cov_gamma_1=cov(gamma_t(:,1:t-1),5+dd,t-1)*2.38**2/(5+dd)
                call spotrf('u',5+dd, cov_gamma_1, 5+dd, info)
                errcode=vsrnggaussianmv(method,stream,1,gamma_2, 5+dd, me, gamma_0, cov_gamma_1)
                gamma_2=gamma_2+gamma_t(:,t-1)
                gamma_1=0.95*gamma_2+0.05*gamma_1
            end if
            IF (DD==1) THEN
                IF (gamma_1(5+DD)>=0) EXIT
            ELSEIF (DD==2) THEN
                IF ((gamma_1(4+DD)>=gamma_1(5+DD)) .and. (gamma_1(4+DD)>0) .and. (gamma_1(5+DD)>0)) EXIT
            ELSEIF (DD==3) THEN
                IF ((gamma_1(3+DD)>=gamma_1(4+DD)) .and. (gamma_1(4+DD)>=gamma_1(5+DD)) .and. (gamma_1(3+DD)>0) .and. (gamma_1(4+DD)>0) .and. (gamma_1(5+DD)>0)) EXIT
            ELSEIF (DD==4) THEN
                IF ((gamma_1(2+DD)>=gamma_1(3+DD)) .and. (gamma_1(3+DD)>=gamma_1(4+DD)) .and. (gamma_1(4+DD)>=gamma_1(5+DD)) .and. (gamma_1(3+DD)>0) .and. (gamma_1(4+DD)>0) .and. (gamma_1(5+DD)>0)) EXIT
            END IF
        END DO

        gamma_2=gamma_T(:,t-1)



        Call OMP_SET_NUM_THREADS(Nthreads)
        !$omp parallel default(shared) private(g, NN, Y, X, XX, W, Wt, W_altru1, W_altru2, IPVT, FACT, &
        !$omp & psi, psi_1, psi_2, ep_1, ep_2, S1, S2, INFO, CODE, DD1, DD2, &
        !$omp & C1, C2, C3, aa_1, aa_2, IPIV, INDX, DET1, DET2, q_1, q_2, &
        !$omp & kk, acc_0v, k, cov_aa, temp_aa, zero, d, pp, i, j, like_Y1, like_Y2, rand, rand1, &
        !$omp & cov_zz, temp_zz, zz_1, zz_2, demean_zz_1, demean_zz_2, &
        !$omp & ithread, iblock, ibegin, iend)

        ithread = OMP_GET_THREAD_NUM()
        iblock = (GG+Nthreads-1)/Nthreads
        ibegin = ithread*iblock+1
        iend = min((ithread+1)*iblock,GG)

        DO g = ibegin,iend

            NN=N(g)
            ALLOCATE(S1(NN,NN));       ALLOCATE(S2(NN,NN));
            ALLOCATE(Y(NN));
            ALLOCATE(X(NN,14)) ;       ALLOCATE(XX(NN,30+2*DD)) ;
            ALLOCATE(W(NN,NN));        ALLOCATE(Wt(NN,NN));
            ALLOCATE(W_altru1(NN,NN)); ALLOCATE(W_altru2(NN,NN))
            ALLOCATE(psi(NN,NN));
            ALLOCATE(psi_1(NN,NN));    ALLOCATE(psi_2(NN,NN))
            ALLOCATE(ep_1(NN));        ALLOCATE(ep_2(NN));
            ALLOCATE(C1(NN,NN));       ALLOCATE(C2(NN,NN));
            ALLOCATE(C3(NN,NN));
            ALLOCATE(aa_1(NN));        ALLOCATE(aa_2(NN))
            ALLOCATE(zz_1(NN,DD));     ALLOCATE(zz_2(NN,DD))
            ALLOCATE(demean_zz_1(NN,DD));
            ALLOCATE(demean_zz_2(NN,DD))
            ALLOCATE(IPIV(NN));        ALLOCATE(INDX(NN));
            ALLOCATE(FACT(NN,NN));     ALLOCATE(IPVT(NN))

            Y=group(1:NN,dep,g)
            X=group(1:NN,1:14,g)
            W=network(1:NN,1:NN,g)
            Wt=transpose(W)
            XX(:,1:14)=X
            XX(:,15:28)=matmul(W,X)
            aa_1=aa(1:NN,g)
            aa_2=aa(1:NN,g)
            zz_1=zz(1:NN,1:DD,g)
            zz_2=zz(1:NN,1:DD,g)

            C1=age(1:NN,1:NN,g)
            C2=sex(1:NN,1:NN,g)
            C3=race(1:NN,1:NN,g)


            !****** update altruism levels ******!

            psi=0.0
            DO i=1,NN
                DO j=1,NN
                    IF (j/=i) THEN
                        IF (DD==1) THEN
                            psi(i,j)=gamma_0T(g,t-1)+gamma_T(1,t-1)*C1(i,j)+gamma_T(2,t-1)*C2(i,j)+gamma_T(3,t-1)*C3(i,j) &
                                & -gamma_T(6,t-1)*abs(zz_2(i,1)-zz_2(j,1))
                        ELSEIF (DD==2) THEN
                            psi(i,j)=gamma_0T(g,t-1)+gamma_T(1,t-1)*C1(i,j)+gamma_T(2,t-1)*C2(i,j)+gamma_T(3,t-1)*C3(i,j) &
                                & -gamma_T(6,t-1)*abs(zz_2(i,1)-zz_2(j,1))-gamma_T(7,t-1)*abs(zz_2(i,2)-zz_2(j,2))
                        ELSEIF (DD==3) THEN
                            psi(i,j)=gamma_0T(g,t-1)+gamma_T(1,t-1)*C1(i,j)+gamma_T(2,t-1)*C2(i,j)+gamma_T(3,t-1)*C3(i,j) &
                                & -gamma_T(6,t-1)*abs(zz_2(i,1)-zz_2(j,1))-gamma_T(7,t-1)*abs(zz_2(i,2)-zz_2(j,2))        &
                                & -gamma_T(8,t-1)*abs(zz_2(i,3)-zz_2(j,3))
                        ELSEIF (DD==4) THEN
                            psi(i,j)=gamma_0T(g,t-1)+gamma_T(1,t-1)*C1(i,j)+gamma_T(2,t-1)*C2(i,j)+gamma_T(3,t-1)*C3(i,j) &
                                & -gamma_T(6,t-1)*abs(zz_2(i,1)-zz_2(j,1))-gamma_T(7,t-1)*abs(zz_2(i,2)-zz_2(j,2))        &
                                & -gamma_T(8,t-1)*abs(zz_2(i,3)-zz_2(j,3))-gamma_T(9,t-1)*abs(zz_2(i,4)-zz_2(j,4))
                        END IF
                    END IF
                END DO
            END DO


            kk=NN
            kk=floor(kk/H)
            IF (kk==0) kk=kk+1

            acc_0v=0.0
            DO k=1, kk
                DO
                    IF(k==kk) THEN
                        ALLOCATE(cov_aa(NN-(k-1)*H,NN-(k-1)*H))
                        ALLOCATE(temp_aa(NN-(k-1)*H))
                        ALLOCATE(zero(NN-(k-1)*H))
                        zero=0.0
                        cov_aa=EYE(NN-(k-1)*H)*c_0a(g)
                        call spotrf('U',NN-(k-1)*H, cov_aa, NN-(k-1)*H, info)
                        errcode=vsrnggaussianmv(method,stream, 1, temp_aa, NN-(k-1)*H, me, zero, cov_aa)
                        aa_1((k-1)*H+1:NN)=temp_aa+aa_2((k-1)*H+1:NN)
                        DEALLOCATE(cov_aa)
                        DEALLOCATE(temp_aa)
                        DEALLOCATE(zero)
                    ELSE
                        ALLOCATE(cov_aa(H,H))
                        ALLOCATE(temp_aa(H))
                        ALLOCATE(zero(H))
                        zero=0.0
                        cov_aa=EYE(H)*c_0a(g)
                        call spotrf('U',H, cov_aa, H, info)
                        errcode=vsrnggaussianmv(method,stream, 1, temp_aa, H, me, zero, cov_aa)
                        aa_1((k-1)*H+1:k*H)=temp_aa+aa_2((k-1)*H+1:k*H)
                        DEALLOCATE(cov_aa)
                        DEALLOCATE(temp_aa)
                        DEALLOCATE(zero)
                    END IF
                    IF ((maxval(aa_1)<=1) .and. (minval(aa_1)>=-1)) EXIT
                END DO

                W_altru1=0.0
                W_altru2=0.0
                psi_1=0.0
                psi_2=0.0
                pp=0.0
                DO i=1,NN
                    DO j=1,NN
                        IF (j/=i) THEN
                            psi_1(i,j)=psi(i,j)+gamma_T(4,t-1)*aa_1(i)+gamma_T(5,t-1)*aa_1(j)
                            psi_2(i,j)=psi(i,j)+gamma_T(4,t-1)*aa_2(i)+gamma_T(5,t-1)*aa_2(j)
                            q_1=psi_1(i,j)*W(i,j)-log(1+exp(psi_1(i,j)))
                            q_2=psi_2(i,j)*W(i,j)-log(1+exp(psi_2(i,j)))
                            pp=pp+(q_1-q_2)
                        ENDIF
                        W_altru1(i,j)=(aa_1(i)+lambda_T(2,t-1)*aa_1(j))/(1+lambda_T(2,t-1))*Wt(i,j)
                        W_altru2(i,j)=(aa_2(i)+lambda_T(2,t-1)*aa_2(j))/(1+lambda_T(2,t-1))*Wt(i,j)
                    END DO
                END DO

                S1=eye(NN)-lambda_T(1,t-1)*(W+W_altru1)
                S2=eye(NN)-lambda_T(1,t-1)*(W+W_altru2)

                XX(:,29)=aa_1
                XX(:,30)=matmul(W,aa_1)
                XX(:,31:30+DD)=zz_2
                XX(:,31+DD:30+2*DD)=matmul(W,zz_2)
                ep_1=matmul(S1,Y)-lambda_T(3,t-1)*sum(W_altru1,2)-matmul(XX,beta_T(:,t-1))-alpha_T(g,t-1)

                XX(:,29)=aa_2
                XX(:,30)=matmul(W,aa_2)
                ep_2=matmul(S2,Y)-lambda_T(3,t-1)*sum(W_altru2,2)-matmul(XX,beta_T(:,t-1))-alpha_T(g,t-1)


                like_Y1=-dot_product(ep_1, ep_1)/(2*sigma_T(t-1))
                like_Y2=-dot_product(ep_2, ep_2)/(2*sigma_T(t-1))

                pp=pp+(like_Y1-like_Y2)

                CALL random_number(rand)
                IF (log(rand)<=pp) THEN
                    aa_2=aa_1
                    acc_0v=acc_0v+1
                END IF
                aa_1=aa_2
            END DO
            if (3*acc_0v>2*kk) acc_0a(g)=acc_0a(g)+1
            acc_rate0a(g,t)=acc_0a(g)/t
            aa(1:NN,g)=aa_1

            t_round=t/THIN
            IF (t-t_round*THIN==0) THEN
                aa_TT(:,g,t/THIN)=aa(:,g)
            END IF

            IF ((t-burn)==2) THEN
                aa_mean(:,g)=aa(:,g)
            ELSEIF ((t-burn)>=3) THEN
                aa_temp(:,g)=aa_mean(:,g)
                aa_mean(:,g)=aa_temp(:,g)+(aa(:,g)-aa_temp(:,g))/((t-burn)-1)
            ENDIF


            !***** update latent variable Z *****!

            psi=0.0
            DO i=1,NN
                DO j=1,NN
                    IF (j/=i) THEN
                        psi(i,j)=gamma_0T(g,t-1)+gamma_T(1,t-1)*C1(i,j)+gamma_T(2,t-1)*C2(i,j)+gamma_T(3,t-1)*C3(i,j) &
                            & +gamma_T(4,t-1)*aa_1(i)+gamma_T(5,t-1)*aa_1(j)
                    END IF
                END DO
            END DO

            kk=NN
            kk=floor(kk/H1)
            IF (kk==0) kk=kk+1

            acc_0v=0.0
            DO k=1, kk
                IF(k==kk) THEN
                    ALLOCATE(cov_zz(NN-(k-1)*H1,NN-(k-1)*H1))
                    ALLOCATE(temp_zz(NN-(k-1)*H1))
                    ALLOCATE(zero(NN-(k-1)*H1))
                    zero=0.0
                    cov_zz=EYE(NN-(k-1)*H1)*c_0z(g)
                    call spotrf('U',NN-(k-1)*H1, cov_zz, NN-(k-1)*H1, info)
                    DO d=1, DD
                        errcode=vsrnggaussianmv(method,stream, 1, temp_zz, NN-(k-1)*H1, me, zero, cov_zz)
                        zz_1((k-1)*H1+1:NN,d)=temp_zz+zz_2((k-1)*H1+1:NN,d)
                    END DO
                    DEALLOCATE(cov_zz)
                    DEALLOCATE(temp_zz)
                    DEALLOCATE(zero)
                ELSE
                    ALLOCATE(cov_zz(H1,H1))
                    ALLOCATE(temp_zz(H1))
                    ALLOCATE(zero(H1))
                    zero=0.0
                    cov_zz=EYE(H1)*c_0z(g)
                    call spotrf('U',H1, cov_zz, H1, info)
                    DO d=1,DD
                        errcode=vsrnggaussianmv(method,stream, 1, temp_zz, H1, me, zero, cov_zz)
                        zz_1((k-1)*H1+1:k*H1,d)=temp_zz+zz_2((k-1)*H1+1:k*H1,d)
                    END DO
                    DEALLOCATE(cov_zz)
                    DEALLOCATE(temp_zz)
                    DEALLOCATE(zero)
                END IF

                W_altru1=0.0
                psi_1=0.0
                psi_2=0.0
                pp=0.0
                DO i=1,NN
                    DO j=1,NN
                        IF (j/=i) THEN
                            IF (DD==1) THEN
                                psi_1(i,j)=psi(i,j)-gamma_T(6,t-1)*abs(zz_1(i,1)-zz_1(j,1))
                                psi_2(i,j)=psi(i,j)-gamma_T(6,t-1)*abs(zz_2(i,1)-zz_2(j,1))
                            ELSE IF (DD==2) THEN
                                psi_1(i,j)=psi(i,j)-gamma_T(6,t-1)*abs(zz_1(i,1)-zz_1(j,1))-gamma_T(7,t-1)*abs(zz_1(i,2)-zz_1(j,2))
                                psi_2(i,j)=psi(i,j)-gamma_T(6,t-1)*abs(zz_2(i,1)-zz_2(j,1))-gamma_T(7,t-1)*abs(zz_2(i,2)-zz_2(j,2))
                            ELSE IF (DD==3) THEN
                                psi_1(i,j)=psi(i,j)-gamma_T(6,t-1)*abs(zz_1(i,1)-zz_1(j,1))-gamma_T(7,t-1)*abs(zz_1(i,2)-zz_1(j,2))-gamma_T(8,t-1)*abs(zz_1(i,3)-zz_1(j,3))
                                psi_2(i,j)=psi(i,j)-gamma_T(6,t-1)*abs(zz_2(i,1)-zz_2(j,1))-gamma_T(7,t-1)*abs(zz_2(i,2)-zz_2(j,2))-gamma_T(8,t-1)*abs(zz_2(i,3)-zz_2(j,3))
                            ELSE IF (DD==4) THEN
                                psi_1(i,j)=psi(i,j)-gamma_T(6,t-1)*abs(zz_1(i,1)-zz_1(j,1))-gamma_T(7,t-1)*abs(zz_1(i,2)-zz_1(j,2))-gamma_T(8,t-1)*abs(zz_1(i,3)-zz_1(j,3))-gamma_T(9,t-1)*abs(zz_1(i,4)-zz_1(j,4))
                                psi_2(i,j)=psi(i,j)-gamma_T(6,t-1)*abs(zz_2(i,1)-zz_2(j,1))-gamma_T(7,t-1)*abs(zz_2(i,2)-zz_2(j,2))-gamma_T(8,t-1)*abs(zz_2(i,3)-zz_2(j,3))-gamma_T(9,t-1)*abs(zz_2(i,4)-zz_2(j,4))
                            END IF
                            q_1=psi_1(i,j)*W(i,j)-log(1+exp(psi_1(i,j)))
                            q_2=psi_2(i,j)*W(i,j)-log(1+exp(psi_2(i,j)))
                            pp=pp+(q_1-q_2)
                        ENDIF
                        W_altru1(i,j)=(aa_1(i)+lambda_T(2,t-1)*aa_1(j))/(1+lambda_T(2,t-1))*Wt(i,j)
                    END DO
                END DO

                S1=eye(NN)-lambda_T(1,t-1)*(W+W_altru1)

                XX(:,29)=aa_1
                XX(:,30)=matmul(W,aa_1)
                XX(:,31:30+DD)=zz_1
                XX(:,31+DD:30+2*DD)=matmul(W,zz_1)
                ep_1=matmul(S1,Y)-lambda_T(3,t-1)*sum(W_altru1,2)-matmul(XX,beta_T(:,t-1))-alpha_T(g,t-1)

                XX(:,31:30+DD)=zz_2
                XX(:,31+DD:30+2*DD)=matmul(W,zz_2)
                ep_2=matmul(S1,Y)-lambda_T(3,t-1)*sum(W_altru1,2)-matmul(XX,beta_T(:,t-1))-alpha_T(g,t-1)


                like_Y1=-dot_product(ep_1, ep_1)/(2*sigma_T(t-1))
                like_Y2=-dot_product(ep_2, ep_2)/(2*sigma_T(t-1))

                IF (DD==1) THEN
                    demean_zz_1=zz_1-mu_zz(1,g);
                    demean_zz_2=zz_2-mu_zz(1,g);
                ELSE IF (DD==2) THEN
                    demean_zz_1(1:NN,1)=zz_1(1:NN,1)-mu_zz(1,g);
                    demean_zz_2(1:NN,1)=zz_2(1:NN,1)-mu_zz(1,g);
                    demean_zz_1(1:NN,2)=zz_1(1:NN,2)-mu_zz(2,g);
                    demean_zz_2(1:NN,2)=zz_2(1:NN,2)-mu_zz(2,g);
                ELSE IF (DD==3) THEN
                    demean_zz_1(1:NN,1)=zz_1(1:NN,1)-mu_zz(1,g);
                    demean_zz_2(1:NN,1)=zz_2(1:NN,1)-mu_zz(1,g);
                    demean_zz_1(1:NN,2)=zz_1(1:NN,2)-mu_zz(2,g);
                    demean_zz_2(1:NN,2)=zz_2(1:NN,2)-mu_zz(2,g);
                    demean_zz_1(1:NN,3)=zz_1(1:NN,3)-mu_zz(3,g);
                    demean_zz_2(1:NN,3)=zz_2(1:NN,3)-mu_zz(3,g);
                ELSE IF (DD==4) THEN
                    demean_zz_1(1:NN,1)=zz_1(1:NN,1)-mu_zz(1,g);
                    demean_zz_2(1:NN,1)=zz_2(1:NN,1)-mu_zz(1,g);
                    demean_zz_1(1:NN,2)=zz_1(1:NN,2)-mu_zz(2,g);
                    demean_zz_2(1:NN,2)=zz_2(1:NN,2)-mu_zz(2,g);
                    demean_zz_1(1:NN,3)=zz_1(1:NN,3)-mu_zz(3,g);
                    demean_zz_2(1:NN,3)=zz_2(1:NN,3)-mu_zz(3,g);
                    demean_zz_1(1:NN,4)=zz_1(1:NN,4)-mu_zz(4,g);
                    demean_zz_2(1:NN,4)=zz_2(1:NN,4)-mu_zz(4,g);
                ELSE IF (DD==5) THEN
                    demean_zz_1(1:NN,1)=zz_1(1:NN,1)-mu_zz(1,g);
                    demean_zz_2(1:NN,1)=zz_2(1:NN,1)-mu_zz(1,g);
                    demean_zz_1(1:NN,2)=zz_1(1:NN,2)-mu_zz(2,g);
                    demean_zz_2(1:NN,2)=zz_2(1:NN,2)-mu_zz(2,g);
                    demean_zz_1(1:NN,3)=zz_1(1:NN,3)-mu_zz(3,g);
                    demean_zz_2(1:NN,3)=zz_2(1:NN,3)-mu_zz(3,g);
                    demean_zz_1(1:NN,4)=zz_1(1:NN,4)-mu_zz(4,g);
                    demean_zz_2(1:NN,4)=zz_2(1:NN,4)-mu_zz(4,g);
                    demean_zz_1(1:NN,5)=zz_1(1:NN,5)-mu_zz(5,g);
                    demean_zz_2(1:NN,5)=zz_2(1:NN,5)-mu_zz(5,g);
                END IF


                IF (k==kk) THEN
                    pp=pp+(like_Y1-like_Y2)+logmvnpdf(reshape(zz_1((k-1)*H1+1:NN,:),(/(NN-(k-1)*H1)*DD,1/)),eye((NN-(k-1)*H1)*DD),(NN-(k-1)*H1)*DD) &
                        & -logmvnpdf(reshape(zz_2((k-1)*H1+1:NN,:),(/(NN-(k-1)*H1)*DD,1/)),eye((NN-(k-1)*H1)*DD),(NN-(k-1)*H1)*DD)
                ELSE
                    pp=pp+(like_Y1-like_Y2)+logmvnpdf(reshape(zz_1((k-1)*H1+1:k*H1,:),(/H1*DD,1/)),eye(H1*DD),H1*DD) &
                        & -logmvnpdf(reshape(zz_2((k-1)*H1+1:k*H1,:),(/H1*DD,1/)),eye(H1*DD),H1*DD)
                END IF
                CALL random_number(rand)
                IF (log(rand)<=pp) THEN
                    zz_2=zz_1
                    acc_0v=acc_0v+1
                END IF
                zz_1=zz_2
            END DO
            if (3*acc_0v>2*kk) acc_0z(g)=acc_0z(g)+1
            acc_rate0z(g,t)=acc_0z(g)/t
            if ((acc_rate0z(g,t)<0.2) .and. (c_0z(g)>=1e-6) )  c_0z(g)=c_0z(g)/1.01
            if ((acc_rate0z(g,t)>0.3) .and. (c_0z(g)<=1.0))  c_0z(g)=c_0z(g)*1.01
            zz(1:NN,1:DD,g)=zz_1

            !***** UPDATE mu_zz *****!


            IF (DD==1) THEN
                errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                mu_zz(1,g)=sum(zz_1(:,1))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
            ELSE IF (DD==2) THEN
                errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                mu_zz(1,g)=sum(zz_1(:,1))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
                errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                mu_zz(2,g)=sum(zz_1(:,2))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
            ELSE IF (DD==3) THEN
                errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                mu_zz(1,g)=sum(zz_1(:,1))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
                errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                mu_zz(2,g)=sum(zz_1(:,2))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
                errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                mu_zz(3,g)=sum(zz_1(:,3))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
            ELSE IF (DD==4) THEN
                errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                mu_zz(1,g)=sum(zz_1(:,1))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
                errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                mu_zz(2,g)=sum(zz_1(:,2))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
                errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                mu_zz(3,g)=sum(zz_1(:,3))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
                errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                mu_zz(4,g)=sum(zz_1(:,4))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
            ELSE IF (DD==5) THEN
                errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                mu_zz(1,g)=sum(zz_1(:,1))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
                errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                mu_zz(2,g)=sum(zz_1(:,2))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
                errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                mu_zz(3,g)=sum(zz_1(:,3))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
                errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                mu_zz(4,g)=sum(zz_1(:,4))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
                errcode=vsrnggaussian(method,stream, 1, rand1, 0.0, 1.0)
                mu_zz(5,g)=sum(zz_1(:,5))/(NN+0.5)+rand1(1)*sqrt(1/(NN+0.5))
            END IF

            !***** THE M-H ALGORITHM FOR SAMPLING GAMMA & LAMBDA ******!

            pp=0.0
            psi_1=0.0
            psi_2=0.0
            DO i=1,NN
                DO j=1, NN
                    IF (j/=i) THEN
                        IF (DD==1) THEN
                            psi_1(i,j)=gamma_0T(g,t-1)+gamma_1(1)*c1(i,j)+gamma_1(2)*c2(i,j)+gamma_1(3)*c3(i,j)+gamma_1(4)*aa_1(i)+gamma_1(5)*aa_1(j) &
                                & -gamma_1(6)*abs(zz_1(i,1)-zz_1(j,1))
                            psi_2(i,j)=gamma_0T(g,t-1)+gamma_2(1)*c1(i,j)+gamma_2(2)*c2(i,j)+gamma_2(3)*c3(i,j)+gamma_2(4)*aa_1(i)+gamma_2(5)*aa_1(j) &
                                & -gamma_2(6)*abs(zz_1(i,1)-zz_1(j,1))
                        ELSEIF (DD==2) THEN
                            psi_1(i,j)=gamma_0T(g,t-1)+gamma_1(1)*c1(i,j)+gamma_1(2)*c2(i,j)+gamma_1(3)*c3(i,j)+gamma_1(4)*aa_1(i)+gamma_1(5)*aa_1(j) &
                                & -gamma_1(6)*abs(zz_1(i,1)-zz_1(j,1))-gamma_1(7)*abs(zz_1(i,2)-zz_1(j,2))
                            psi_2(i,j)=gamma_0T(g,t-1)+gamma_2(1)*c1(i,j)+gamma_2(2)*c2(i,j)+gamma_2(3)*c3(i,j)+gamma_2(4)*aa_1(i)+gamma_2(5)*aa_1(j) &
                                & -gamma_2(6)*abs(zz_1(i,1)-zz_1(j,1))-gamma_2(7)*abs(zz_1(i,2)-zz_1(j,2))
                        ELSEIF (DD==3) THEN
                            psi_1(i,j)=gamma_0T(g,t-1)+gamma_1(1)*c1(i,j)+gamma_1(2)*c2(i,j)+gamma_1(3)*c3(i,j)+gamma_1(4)*aa_1(i)+gamma_1(5)*aa_1(j) &
                                & -gamma_1(6)*abs(zz_1(i,1)-zz_1(j,1))-gamma_1(7)*abs(zz_1(i,2)-zz_1(j,2))-gamma_1(8)*abs(zz_1(i,3)-zz_1(j,3))
                            psi_2(i,j)=gamma_0T(g,t-1)+gamma_2(1)*c1(i,j)+gamma_2(2)*c2(i,j)+gamma_2(3)*c3(i,j)+gamma_2(4)*aa_1(i)+gamma_2(5)*aa_1(j) &
                                & -gamma_2(6)*abs(zz_1(i,1)-zz_1(j,1))-gamma_2(7)*abs(zz_1(i,2)-zz_1(j,2))-gamma_2(8)*abs(zz_1(i,3)-zz_1(j,3))
                        ELSEIF (DD==4) THEN
                            psi_1(i,j)=gamma_0T(g,t-1)+gamma_1(1)*c1(i,j)+gamma_1(2)*c2(i,j)+gamma_1(3)*c3(i,j)+gamma_1(4)*aa_1(i)+gamma_1(5)*aa_1(j) &
                                & -gamma_1(6)*abs(zz_1(i,1)-zz_1(j,1))-gamma_1(7)*abs(zz_1(i,2)-zz_1(j,2))-gamma_1(8)*abs(zz_1(i,3)-zz_1(j,3))        &
                                & -gamma_1(9)*abs(zz_1(i,4)-zz_1(j,4)) 
                            psi_2(i,j)=gamma_0T(g,t-1)+gamma_2(1)*c1(i,j)+gamma_2(2)*c2(i,j)+gamma_2(3)*c3(i,j)+gamma_2(4)*aa_1(i)+gamma_2(5)*aa_1(j) &
                                & -gamma_2(6)*abs(zz_1(i,1)-zz_1(j,1))-gamma_2(7)*abs(zz_1(i,2)-zz_1(j,2))-gamma_2(8)*abs(zz_1(i,3)-zz_1(j,3))        &
                                & -gamma_2(9)*abs(zz_1(i,4)-zz_1(j,4))
                        END IF
                        q_1=psi_1(i,j)*W(i,j)-log(1+exp(psi_1(i,j)))
                        q_2=psi_2(i,j)*W(i,j)-log(1+exp(psi_2(i,j)))
                        pp=pp+(q_1-q_2)
                    ENDIF
                    W_altru1(i,j)=(aa_1(i)+lambda_1(2)*aa_1(j))/(1+lambda_1(2))*Wt(i,j)
                    W_altru2(i,j)=(aa_1(i)+lambda_T(2,t-1)*aa_1(j))/(1+lambda_T(2,t-1))*Wt(i,j)
                END DO
            END DO

            pp_G(g)=pp

            S1=eye(NN)-lambda_1(1)*(W+W_altru1)
            S2=eye(NN)-lambda_T(1,t-1)*(W+W_altru2)

            XX(:,29)=aa_1
            XX(:,30)=matmul(W,aa_1)
            XX(:,31:30+DD)=zz_1
            XX(:,31+DD:30+2*DD)=matmul(W,zz_1)
            ep_1=matmul(S1,Y)-lambda_1(3)*sum(W_altru1,2)-matmul(XX,beta_T(:,t-1))-alpha_T(g,t-1)
            ep_2=matmul(S2,Y)-lambda_T(3,t-1)*sum(W_altru2,2)-matmul(XX,beta_T(:,t-1))-alpha_T(g,t-1)

            like_Y1=log(FindDet(S1,NN))-dot_product(ep_1, ep_1)/(2*sigma_T(t-1))
            
            like_Y2=log(FindDet(S2,NN))-dot_product(ep_2, ep_2)/(2*sigma_T(t-1))
            pp_l(g)=(like_Y1-like_Y2)

            DEALLOCATE(S1,S2,Y,X,XX,W,Wt,W_altru1,W_altru2,psi,psi_1,psi_2,ep_1,ep_2,C1,C2,C3,aa_1,aa_2,zz_1,zz_2,demean_zz_1,demean_zz_2,IPIV,INDX,FACT,IPVT)
            
        END DO
        !$omp end parallel

        pp=sum(pp_G)+logmvnpdf(gamma_1, G_0, 5+DD)-logmvnpdf(gamma_2, G_0, 5+DD)

        CALL random_number(rand)
        IF (log(rand)<=pp) THEN
            gamma_T(:,t)=gamma_1
            acc_1=acc_1+1.0
        ELSE
            gamma_T(:,t)=gamma_T(:,t-1)
        ENDIF
        acc_rate1(t)=acc_1/t

        CALL random_number(rand)
        IF (log(rand)<=sum(pp_l)) THEN
            lambda_T(:,t)=lambda_1
            acc_2=acc_2+1.0
        ELSE
            lambda_T(:,t)=lambda_T(:,t-1)
        END IF
        acc_rate2(t)=acc_2/t



        !************** M-H STEP TO SIMULATE GAMMA_0T *******************!

        Call OMP_SET_NUM_THREADS(Nthreads)
        !$omp parallel default(shared) private(g, NN, Y, X, XX, W, Wt, W_altru1, W_altru2, IPVT, FACT, &
        !$omp & psi, psi_1, psi_2, ep_1, ep_2, S1, S2, INFO, CODE, DD1, DD2, gamma_01, gamma_02, &
        !$omp & C1, C2, C3, aa_1, zz_1, IPIV, INDX, DET1, DET2, q_1, q_2, &
        !$omp & kk, acc_0v, k, cov_aa, temp_aa, zero, d, pp, i, j, like_Y1, like_Y2, rand, &
        !$omp & ithread, iblock, ibegin, iend)

        ithread = OMP_GET_THREAD_NUM()
        iblock = (GG+Nthreads-1)/Nthreads
        ibegin = ithread*iblock+1
        iend = min((ithread+1)*iblock,GG)

        DO g = ibegin,iend

            gamma_01=random_normal()*0.1+gamma_0T(g,t-1)
            IF (t>2) THEN
                gamma_02=random_normal()*sqrt(var(gamma_0T(g,1:t-1),t-1))*2.38+gamma_0T(g,t-1)
                gamma_01=0.95*gamma_02+0.05*gamma_01
            END IF

            gamma_02=gamma_0T(g,t-1)

            NN=N(g)
            ALLOCATE(W(NN,NN));
            ALLOCATE(psi(NN,NN));
            ALLOCATE(psi_1(NN,NN));    ALLOCATE(psi_2(NN,NN))
            ALLOCATE(C1(NN,NN));       ALLOCATE(C2(NN,NN));
            ALLOCATE(C3(NN,NN));
            ALLOCATE(aa_1(NN))
            ALLOCATE(zz_1(NN,DD))
            ALLOCATE(IPIV(NN));        ALLOCATE(INDX(NN));
            ALLOCATE(FACT(NN,NN));     ALLOCATE(IPVT(NN))

            W=network(1:NN,1:NN,g)
            aa_1=aa(1:NN,g)
            zz_1=zz(1:NN,1:DD,g)
            C1=age(1:NN,1:NN,g)
            C2=sex(1:NN,1:NN,g)
            C3=race(1:NN,1:NN,g)

            !***** THE M-H ALGORITHM FOR SAMPLING GAMMA & LAMBDA ******!

            psi=0.0
            DO i=1,NN
                DO j=1, NN
                    IF (j/=i) THEN
                        IF (DD==1) THEN
                            psi(i,j)=gamma_T(1,t)*c1(i,j)+gamma_T(2,t)*c2(i,j)+gamma_T(3,t)*c3(i,j)+gamma_T(4,t)*aa_1(i)+gamma_T(5,t)*aa_1(j) &
                                & -gamma_T(6,t)*abs(zz_1(i,1)-zz_1(j,1))
                        ELSE IF (DD==2) THEN
                            psi(i,j)=gamma_T(1,t)*c1(i,j)+gamma_T(2,t)*c2(i,j)+gamma_T(3,t)*c3(i,j)+gamma_T(4,t)*aa_1(i)+gamma_T(5,t)*aa_1(j) &
                                & -gamma_T(6,t)*abs(zz_1(i,1)-zz_1(j,1))-gamma_T(7,t)*abs(zz_1(i,2)-zz_1(j,2))
                        ELSE IF (DD==3) THEN
                            psi(i,j)=gamma_T(1,t)*c1(i,j)+gamma_T(2,t)*c2(i,j)+gamma_T(3,t)*c3(i,j)+gamma_T(4,t)*aa_1(i)+gamma_T(5,t)*aa_1(j) &
                                & -gamma_T(6,t)*abs(zz_1(i,1)-zz_1(j,1))-gamma_T(7,t)*abs(zz_1(i,2)-zz_1(j,2))-gamma_T(8,t)*abs(zz_1(i,3)-zz_1(j,3))
                        ELSE IF (DD==4) THEN
                            psi(i,j)=gamma_T(1,t)*c1(i,j)+gamma_T(2,t)*c2(i,j)+gamma_T(3,t)*c3(i,j)+gamma_T(4,t)*aa_1(i)+gamma_T(5,t)*aa_1(j) &
                                & -gamma_T(6,t)*abs(zz_1(i,1)-zz_1(j,1))-gamma_T(7,t)*abs(zz_1(i,2)-zz_1(j,2))-gamma_T(8,t)*abs(zz_1(i,3)-zz_1(j,3)) &
                                & -gamma_T(9,t)*abs(zz_1(i,4)-zz_1(j,4))
                        END IF
                    ENDIF
                END DO
            END DO

            psi_1=psi+gamma_01
            psi_2=psi+gamma_02
            pp=0.0
            DO i=1,NN
                DO j=1, NN
                    IF (j/=i) THEN
                        q_1=psi_1(i,j)*W(i,j)-log(1+exp(psi_1(i,j)))
                        q_2=psi_2(i,j)*W(i,j)-log(1+exp(psi_2(i,j)))
                        pp=pp+(q_1-q_2)
                    ENDIF
                END DO
            END DO

            CALL random_number(rand)
            IF (log(rand)<=pp) THEN
                gamma_0T(g,t)=gamma_01
                acc_3(g)=acc_3(g)+1.0
            ELSE
                gamma_0T(g,t)=gamma_0T(g,t-1)
            ENDIF
            acc_rate3(g,t)=acc_3(g)/t

            DEALLOCATE(W,psi,psi_1,psi_2,C1,C2,C3,aa_1,zz_1,IPIV,INDX,FACT,IPVT)
            
        END DO
        !$omp end parallel



        !***************GIBBS STEP TO SIMULTE BETA *********************!

        XVX=0.0
        XVY=0.0

        Call OMP_SET_NUM_THREADS(Nthreads)
        !$omp parallel default(shared) private(g,NN, Y, YY, W, Wt, W_altru, &
        !$omp & X, XX, XX2, S, V, V1, V2, aa_1, zz_1, IPIV, INFO, i, j, &
        !$omp & ithread, iblock, ibegin, iend)

        ithread = OMP_GET_THREAD_NUM()
        iblock = (GG+Nthreads-1)/Nthreads
        ibegin = ithread*iblock+1
        iend = min((ithread+1)*iblock,GG)

        DO g = ibegin,iend

            NN=N(g)
            ALLOCATE(Y(NN));        ALLOCATE(YY(NN))
            ALLOCATE(X(NN,14)) ;
            ALLOCATE(XX(NN,30+2*DD)); ALLOCATE(XX2(NN,30+2*DD)) ;
            ALLOCATE(W(NN,NN));     ALLOCATE(Wt(NN,NN));
            ALLOCATE(W_altru(NN,NN));
            ALLOCATE(S(NN,NN));
            ALLOCATE(V(NN,NN));
            ALLOCATE(V1(NN,NN)); ALLOCATE(V2(NN,NN))
            ALLOCATE(aa_1(NN))
            ALLOCATE(zz_1(NN,DD))
            ALLOCATE(IPIV(NN))

            V=sigma_T(t-1)*EYE(NN)
            Y=group(1:NN,dep,g)
            X=group(1:NN,1:14,g)
            W=network(1:NN,1:NN,g)
            Wt=transpose(W)
            aa_1=aa(1:NN,g)
            zz_1=zz(1:NN,1:DD,g)
            XX(:,1:14)=X
            XX(:,15:28)=matmul(W,X)
            XX(:,29)=aa_1
            XX(:,30)=matmul(W,aa_1)
            XX(:,31:30+DD)=zz_1
            XX(:,31+DD:30+2*DD)=matmul(W,zz_1)

            DO i=1,NN
                DO j=1, NN
                    W_altru(i,j)=(aa_1(i)+lambda_T(2,t)*aa_1(j))/(1+lambda_T(2,t))*Wt(i,j)
                END DO
            END DO

            S=eye(NN)-lambda_T(1,t)*(W+W_altru)

            XX2=XX
            V1=V
            CALL SGESV(NN,30+2*DD,V1,NN,IPIV,XX2,NN,INFO)
            YY=matmul(S,Y)-lambda_T(3,t)*sum(W_altru,2)-alpha_T(g,t-1)
            V2=V
            CALL SGESV(NN,1,V2,NN,IPIV,YY,NN,INFO)

            XVX(:,:,g)=matmul(transpose(XX) , XX2)
            XVY(:,g)=matmul(transpose(XX) , YY)
            
            DEALLOCATE(Y,YY,X,XX,XX2,W,Wt,W_altru,S,V,V1,V2,aa_1,zz_1,IPIV)
        END DO
        !$omp end parallel

        CALL FINDInv(sum(XVX,3)+INV_B_0,INV_B,30+2*DD,ier)
        INV_B2=INV_B
        CALL spotrf('U',30+2*DD, INV_B2, 30+2*DD, info)
        errcode=vsrnggaussianmv(method, stream, 1, beta_temp, 30+2*DD, me, beta_0,  INV_B2)
        beta_T(:,t)=beta_temp+matmul(INV_B,sum(XVY,2))



        !*************GIBBS STEP FOR sigma*********************!

        rho_1=0
        ALLOCATE(ep_v(sum(N)))
        stack=0
        DO g=1,GG
            NN=N(G)
            ALLOCATE(Y(NN))
            ALLOCATE(X(NN,14))
            ALLOCATE(XX(NN,30+2*DD))
            ALLOCATE(W(NN,NN))
            ALLOCATE(Wt(NN,NN))
            ALLOCATE(aa_1(NN))
            ALLOCATE(zz_1(NN,DD))
            ALLOCATE(W_altru(NN,NN))
            ALLOCATE(S(NN,NN))
            ALLOCATE(ep(NN))

            Y=group(1:NN,dep,g)
            X=group(1:NN,1:14,g)
            W=network(1:NN,1:NN,g)
            Wt=transpose(W)
            aa_1=aa(1:NN,g)
            zz_1=zz(1:NN,1:DD,g)
            XX(:,1:14)=X
            XX(:,15:28)=matmul(W,X)
            XX(:,29)=aa_1
            XX(:,30)=matmul(W,aa_1)
            XX(:,31:30+DD)=zz_1
            XX(:,31+DD:30+2*DD)=matmul(W,zz_1)

            DO i=1,NN
                DO j=1, NN
                    W_altru(i,j)=(aa_1(i)+lambda_T(2,t)*aa_1(j))/(1+lambda_T(2,t))*Wt(i,j)
                END DO
            END DO

            S=eye(NN)-lambda_T(1,t)*(W+W_altru)

            ep=matmul(S,Y)-lambda_T(3,t)*sum(W_altru,2)-matmul(XX,beta_T(:,t))-alpha_T(g,t-1)
            ep_v(stack+1:stack+NN)=ep
            rho_1=rho_1+NN
            stack=stack+NN
            
            DEALLOCATE(Y,X,XX,W,Wt,aa_1,zz_1,W_altru,S,ep)
        END DO
        sigma_T(t)=(dot_product(ep_v,ep_v)+eta_0)/random_chisq(rho_1+rho_0, first)
        DEALLOCATE(ep_v)


        !*************GIBBS STEP FOR ALPHA_G*********************!


        Call OMP_SET_NUM_THREADS(Nthreads)
        !$omp parallel default(shared) private(g,NN, Y, YY, &
        !$omp & X, XX, W, Wt, W_altru, S, aa_1, zz_1, IPIV, R_g, i,j, &
        !$omp & ithread, iblock, ibegin, iend)

        ithread = OMP_GET_THREAD_NUM()
        iblock = (GG+Nthreads-1)/Nthreads
        ibegin = ithread*iblock+1
        iend = min((ithread+1)*iblock,GG)

        DO g = ibegin,iend

            NN=N(g)
            ALLOCATE(Y(NN));
            ALLOCATE(YY(NN));
            ALLOCATE(X(NN,14))
            ALLOCATE(XX(NN,30+2*DD))
            ALLOCATE(W(NN,NN));
            ALLOCATE(Wt(NN,NN));
            ALLOCATE(W_altru(NN,NN));
            ALLOCATE(S(NN,NN));
            ALLOCATE(aa_1(NN))
            ALLOCATE(zz_1(NN,DD))

            R_g=(ALPHA_0**(-1)+sigma_T(t)**(-1.0)*NN)**(-1.0)
            Y=group(1:NN,dep,g)
            X=group(1:NN,1:14,g)
            W=network(1:NN,1:NN,g)
            Wt=transpose(W)
            aa_1=aa(1:NN,g)
            zz_1=zz(1:NN,1:DD,g)
            XX(:,1:14)=X
            XX(:,15:28)=matmul(W,X)
            XX(:,29)=aa_1
            XX(:,30)=matmul(W,aa_1)
            XX(:,31:30+DD)=zz_1
            XX(:,31+DD:30+2*DD)=matmul(W,zz_1)

            DO i=1,NN
                DO j=1, NN
                    W_altru(i,j)=(aa_1(i)+lambda_T(2,t)*aa_1(j))/(1+lambda_T(2,t))*Wt(i,j)
                END DO
            END DO

            S=eye(NN)-lambda_T(1,t)*(W+W_altru)

            YY=matmul(S,Y)
            alpha_T(g,t)=R_g*(ALPHA_0**(-1)*a_0+(sigma_T(t))**(-1.0)*sum((YY-lambda_T(3,t)*sum(W_altru,2)-matmul(XX,beta_T(:,t)))))+random_normal()*sqrt(R_g)

            DEALLOCATE(Y,YY,X,XX,W,Wt,W_altru,S,aa_1,zz_1)
        END DO
        !$omp end parallel



        !!******** Calculate Log likelihood function value *********!

        Call OMP_SET_NUM_THREADS(Nthreads)
        !$omp parallel default(shared) private(g, NN, Y, X, XX, W, Wt, W_altru, IPVT, FACT, &
        !$omp & psi, ep_1, S, INFO, CODE, DD1, DD2, &
        !$omp & C1, C2, C3, IPIV, INDX, DET1, DET2, q_1, q_2, &
        !$omp & kk, acc_0v, k, zero, d, pp, i, j, like_Y1, like_Y2, rand, rand1, zz_1, aa_1, &
        !$omp & ithread, iblock, ibegin, iend)
        
        ithread = OMP_GET_THREAD_NUM()
        iblock = (GG+Nthreads-1)/Nthreads
        ibegin = ithread*iblock+1
        iend = min((ithread+1)*iblock,GG)
        
        DO g = ibegin,iend
        
            NN=N(g)
            ALLOCATE(S(NN,NN));
            ALLOCATE(Y(NN));
            ALLOCATE(X(NN,14)) ;       ALLOCATE(XX(NN,30+2*DD))
            ALLOCATE(W(NN,NN));        ALLOCATE(Wt(NN,NN));
            ALLOCATE(W_altru(NN,NN));
            ALLOCATE(psi(NN,NN));
            ALLOCATE(ep_1(NN));
            ALLOCATE(C1(NN,NN));       ALLOCATE(C2(NN,NN));
            ALLOCATE(C3(NN,NN));
            ALLOCATE(zz_1(NN,DD));
            ALLOCATE(aa_1(NN))
            ALLOCATE(IPIV(NN));        ALLOCATE(INDX(NN));
            ALLOCATE(FACT(NN,NN));     ALLOCATE(IPVT(NN))
        
            Y=group(1:NN,dep,g)
            X(:,1:14)=group(1:NN,1:14,g)
            W=network(1:NN,1:NN,g)
            Wt=transpose(W)
            aa_1=aa(1:NN,g)
            zz_1=zz(1:NN,1:DD,g)
            XX(:,1:14)=X
            XX(:,15:28)=matmul(W,X)
            XX(:,29)=aa_1
            XX(:,30)=matmul(W,aa_1)
            XX(:,31:30+DD)=zz_1
            XX(:,31+DD:30+2*DD)=matmul(W,zz_1)
        
        
            C1=age(1:NN,1:NN,g)
            C2=sex(1:NN,1:NN,g)
            C3=race(1:NN,1:NN,g)
        
        
            pp=0.0
            psi=0.0
            DO i=1,NN
                DO j=1, NN
                    IF (j/=i) THEN
                        IF (DD==1) THEN
                            psi(i,j)=gamma_0T(g,t)+gamma_T(1,t)*c1(i,j)+gamma_T(2,t)*c2(i,j)+gamma_T(3,t)*c3(i,j)+gamma_T(4,t)*aa_1(i)+gamma_T(5,t)*aa_1(j) &
                                & -gamma_T(6,t)*abs(zz_1(i,1)-zz_1(j,1))
                        ELSE IF (DD==2) THEN
                            psi(i,j)=gamma_0T(g,t)+gamma_T(1,t)*c1(i,j)+gamma_T(2,t)*c2(i,j)+gamma_T(3,t)*c3(i,j)+gamma_T(4,t)*aa_1(i)+gamma_T(5,t)*aa_1(j) &
                                & -gamma_T(6,t)*abs(zz_1(i,1)-zz_1(j,1))-gamma_T(7,t)*abs(zz_1(i,2)-zz_1(j,2))
                        ELSE IF (DD==3) THEN
                            psi(i,j)=gamma_0T(g,t)+gamma_T(1,t)*c1(i,j)+gamma_T(2,t)*c2(i,j)+gamma_T(3,t)*c3(i,j)+gamma_T(4,t)*aa_1(i)+gamma_T(5,t)*aa_1(j) &
                                & -gamma_T(6,t)*abs(zz_1(i,1)-zz_1(j,1))-gamma_T(7,t)*abs(zz_1(i,2)-zz_1(j,2))-gamma_T(8,t)*abs(zz_1(i,3)-zz_1(j,3))
                        ELSE IF (DD==4) THEN
                            psi(i,j)=gamma_0T(g,t)+gamma_T(1,t)*c1(i,j)+gamma_T(2,t)*c2(i,j)+gamma_T(3,t)*c3(i,j)+gamma_T(4,t)*aa_1(i)+gamma_T(5,t)*aa_1(j) &
                                & -gamma_T(6,t)*abs(zz_1(i,1)-zz_1(j,1))-gamma_T(7,t)*abs(zz_1(i,2)-zz_1(j,2))-gamma_T(8,t)*abs(zz_1(i,3)-zz_1(j,3)) &
                                & -gamma_T(9,t)*abs(zz_1(i,4)-zz_1(j,4))
                        END IF
                        q_1=psi(i,j)*W(i,j)-log(1+exp(psi(i,j)))
                        pp=pp+q_1
                    ENDIF
                END DO
            END DO
            
            DO i=1,NN
                DO j=1, NN
                    W_altru(i,j)=(aa_1(i)+lambda_T(2,t)*aa_1(j))/(1+lambda_T(2,t))*Wt(i,j)
                END DO
            END DO
        
            S=eye(NN)-lambda_T(1,t)*(W+W_altru)
        
            ep_1=matmul(S,Y)-lambda_T(3,t)*sum(W_altru,2)-matmul(XX,beta_T(:,t))-alpha_T(g,t-1)
                    
            like_Y1=-0.5*NN*log(2*pi)-0.5*NN*log(sigma_T(t))+log(FindDet(S,NN))-dot_product(ep_1, ep_1)/(2*sigma_T(t))
        
            pp_G(g)=pp+like_Y1
          
            DEALLOCATE(S,Y,X,XX,W,Wt,W_altru,psi,ep_1,C1,C2,C3,zz_1,aa_1,IPIV,INDX,FACT,IPVT)
        END DO
        !$omp end parallel
        
        logp_T(t)=sum(pp_G)
        
        
        !If(t>burn) THEN
        !    AICM=2*(var_8(logp_T(burn:t),(t-burn+1))-sum(logp_T(burn:t))/(t-burn+1))
        !END IF



        call system_clock ( clock_stop, clock_rate, clock_max )
        t_round=t/10
        IF (t-t_round*10==0) THEN
            WRITE(*,*)   'T=', t
            WRITE(*,'(a10, f9.4)') 'Time:', real ( clock_stop - clock_start ) / real ( clock_rate )
            WRITE(*,'(a10,13f9.4)') 'GAMMA_0:', gamma_0T(1,t), gamma_0T(24,t)
            WRITE(*,'(a10,13f9.4)') 'GAMMA:', gamma_T(:,t)
            WRITE(*,'(a10,3f9.4)') 'LAMBDA:', lambda_T(:,t)
            WRITE(*,'(a10,8f9.4)') 'BETA:',   beta_T(29:30+DD,t)
            WRITE(*,'(a10, f9.4)') 'SIGMA:',  sigma_T(t)
            !WRITE(*,'(a10,f10.2)') 'Likeli:',  logp_T(t)
            WRITE(*,'(a10,2f9.4)') 'acc_0a:',  acc_rate0a(1,t), acc_rate0a(11,t)
            WRITE(*,'(a10,2f9.4)') 'acc_0z:',  acc_rate0z(1,t), acc_rate0z(11,t)
            WRITE(*,'(a10,f9.4)') 'acc_1:',  acc_rate1(t)
            WRITE(*,'(a10,f9.4)') 'acc_2:',  acc_rate2(t)
	    WRITE(*,'(a10,2f9.4)') 'acc_3:',  acc_rate3(1,t), acc_rate3(24,t)
            WRITE(*,'(a10,7f9.4)') 'c_0z:', c_0z(1),c_0z(11)
            WRITE(*,'(a10,27f9.4)') 'aa:', aa(1,1)
            WRITE(*,'(a10,27f9.4)') 'zz:', zz(1,1:DD,1), zz(1,1:DD,11)
            WRITE(*,'(a10,f15.2)') 'logp', logp_T(t)

            WRITE(1001,'(24f10.4)') gamma_0T(:,t)
            WRITE(1000,'(5f12.4)')  gamma_T(:,t)
            WRITE(2000,'(3f10.4)')  lambda_T(:,t)
            WRITE(3000,'(30f10.4)') beta_T(:,t)
            WRITE(4000,'(f12.4)')   sigma_T(t)
            WRITE(6000,'(24f10.4)') alpha_T(:,t)

            WRITE(9000,'(f12.3)')   logp_T(t)
        END IF

        t_round=t/THIN
        IF (t-t_round*THIN==0) THEN
            DO g=1,GG
                WRITE(8000,'(29f10.4)') aa_TT(:,g,t/THIN)
            END DO
        END IF

    END DO

    DO g=1,GG
        WRITE(5000,'(29f10.4)')  aa_mean(:,g)
    END DO

    END PROGRAM estimation



